/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.nav;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.RunProcess;
import oracle.ide.util.Assert;
import oracle.javatools.util.ImageIconCache;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.migrate.VCSStreamMonitor;
import oracle.jdeveloper.vcs.nav.ConnectionNode;
import oracle.jdevimpl.vcs.perforce2.ConnectionEvent;
import oracle.jdevimpl.vcs.perforce2.ConnectionSessionListener;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.cmd.PerforceLoginCommand;
import oracle.jdevimpl.vcs.perforce2.error.PerforceProcessException;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceConnectionDepotNode;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.perforce2.nav.PerforceRemoteFolder;
import oracle.jdevimpl.vcs.perforce2.nav.cmd.PerforceEditConnectionCommand;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PerforceConnectionNode
extends PerforceRemoteFolder
implements ConnectionSessionListener,
ConnectionNode {
    private static final Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceConnectionNode.class.getName());

    public PerforceConnectionNode(PerforceConnectionProfile con) {
        super(con);
    }

    @Override
    public String getLongLabel() {
        return this.getShortLabel();
    }

    @Override
    public String getShortLabel() {
        return this.getConnectionProfile().toString();
    }

    @Override
    public Icon getIcon() {
        return ImageIconCache.get((URL)PerforceArb.class.getResource(PerforceArb.get("PERFORCE_CONNECTION_ICON")));
    }

    @Override
    protected void openImpl() throws IOException {
        if (!this.isLoggedIn()) {
            return;
        }
        super.openImpl();
    }

    public String getToolTipText() {
        if (PerforceSessionManager.getInstance().isConnected(this.getConnectionProfile())) {
            return super.getToolTipText() + PerforceArb.get("PERFORCE_LOGIN");
        }
        return super.getToolTipText() + PerforceArb.get("PERFORCE_LOGOUT");
    }

    @Override
    public void connected(ConnectionEvent ce) {
    }

    @Override
    public void disconnected(ConnectionEvent ce) {
        if (ce.getSource().equals(this.getConnectionProfile())) {
            this.removeAndClose();
        }
    }

    public URL getURL() {
        if (super.getURL() == null) {
            try {
                if (PerforceSessionManager.getInstance().isConnected(this.getConnectionProfile())) {
                    this.setUrl();
                }
            }
            catch (IOException e) {
                sLogger.log(Level.WARNING, "Failed to create URL for " + this.getConnectionProfile().getName());
            }
        }
        return super.getURL();
    }

    @Override
    protected Collection list(PerforceConnectionProfile connect, boolean filter) throws IOException, PerforceProcessException {
        PerforceShellRunner runner = new PerforceShellRunner();
        ArrayList<String> cmds = new ArrayList<String>();
        URL url = this.getURL();
        DepotMonitor monitor = new DepotMonitor();
        if (url == null) {
            return Collections.EMPTY_LIST;
        }
        cmds.add("depots");
        runner.setConnection(connect);
        runner.setCmdList(cmds);
        runner.setQuiet(true);
        runner.addOutputMonitor(monitor);
        try {
            runner.exec();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, e.getMessage());
            throw new IOException(e.getMessage());
        }
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            PerforceUtil.isErrorConnection(runner, connect, PerforceArb.get("PERFORCE_CONNECTION_TITLE"));
            throw new IOException(PerforceArb.format("ERROR_DIR_CHILDREN_OF", this.getShortLabel()));
        }
        return monitor.getDepots();
    }

    private void removeAndClose() {
        this.removeAll(true);
        try {
            this.close();
        }
        catch (IOException e) {
            sLogger.log(Level.WARNING, "Failed to close " + URLFileSystem.getPlatformPathName((URL)this.getURL()));
            Assert.printStackTrace((Throwable)e);
        }
        this.markDirty(false);
    }

    private void setUrl() throws IOException {
        Integer port = this.getConnectionProfile().getPortNumber();
        String host = this.getConnectionProfile().getHostName();
        URL url = URLFactory.newURL((String)PerforceNavURLFileSystemHelper.PERFORCE_NAV_PROTOCOL, null, (String)host, (int)port, (String)"/", null, null);
        this.setURL(url);
    }

    public Map<String, String> getConnectionCriteria() {
        Integer port = this.getConnectionProfile().getPortNumber();
        String server = this.getConnectionProfile().getHostName();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("server", server);
        criteria.put("port", port.toString());
        return criteria;
    }

    @Override
    public PerforceConnectionProfile getConnectionProfile() {
        return (PerforceConnectionProfile)this.getData();
    }

    String getServer() {
        return this.getConnectionProfile().getHostName();
    }

    Integer getPort() {
        return this.getConnectionProfile().getPortNumber();
    }

    private boolean isLoggedIn() {
        if (!PerforceConnectionManager.getInstance().hasConnectionDetails(this.getConnectionProfile())) {
            PerforceEditConnectionCommand edit = new PerforceEditConnectionCommand();
            this.invokeCommand((Command)edit);
            return PerforceSessionManager.getInstance().isConnected(this.getConnectionProfile());
        }
        if (!PerforceSessionManager.getInstance().isConnected(this.getConnectionProfile())) {
            PerforceLoginCommand login = new PerforceLoginCommand();
            login.setConnectionProfile(this.getConnectionProfile());
            login.setProfile(VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce"));
            this.invokeCommand((Command)login);
            return PerforceSessionManager.getInstance().isConnected(this.getConnectionProfile());
        }
        return true;
    }

    private void invokeCommand(Command command) {
        try {
            Context con = Context.newIdeContext((Node)this);
            command.setContext(con);
            CommandProcessor.getInstance().invoke(command);
        }
        catch (Exception e) {
            sLogger.warning("Failed to login " + e.getMessage());
            PerforceProfile.getErrorHandler().handleException(e);
        }
    }

    private class DepotMonitor
    extends VCSStreamMonitor {
        private Collection<PerforceConnectionDepotNode> _depots = new ArrayList<PerforceConnectionDepotNode>();

        private DepotMonitor() {
        }

        protected void streamLine(String line, RunProcess process) throws Exception {
            PerforceConnectionDepotNode depot = new PerforceConnectionDepotNode(PerforceConnectionNode.this.getConnectionProfile());
            String[] parts = line.split(" ");
            StringBuilder path = new StringBuilder("//");
            path.append(parts[1]);
            path.append('/');
            URL url = URLFactory.newURL((String)PerforceNavURLFileSystemHelper.PERFORCE_NAV_PROTOCOL, null, (String)PerforceConnectionNode.this.getConnectionProfile().getHostName(), (int)PerforceConnectionNode.this.getConnectionProfile().getPortNumber(), (String)path.toString(), null, null);
            depot.setURL(url);
            this._depots.add(depot);
        }

        private Collection<PerforceConnectionDepotNode> getDepots() {
            return this._depots;
        }
    }
}

