/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.migration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import oracle.ide.migration.XMLMigrator;
import oracle.ide.util.FileCopyUtil;
import oracle.jdevimpl.vcs.perforce2.Perforce903to11111Connection;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.connection.PerforceConnectionHelper;

public class PerforceConnectionMigrator
extends XMLMigrator {
    private static final Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceShellRunner.class.getName());

    public PerforceConnectionMigrator() {
        super(new int[]{0});
    }

    protected String getFileName() {
        return "perforceconnections.xml";
    }

    protected String getNamespaceURI() {
        return "http://xmlns.oracle.com/jdeveloper/1013/perforce";
    }

    protected String getRootTag() {
        return "perforce";
    }

    public String getDescription(int category) {
        return null;
    }

    public String[] migrate(File sourceDir, File destDir) {
        File migrateFile = this.getMigrateFile(sourceDir);
        File dstFile = new File(destDir, this.getFileName());
        if (migrateFile != null) {
            this.migrateSingleConnection(migrateFile, dstFile);
        } else {
            File srcFile = new File(sourceDir, this.getFileName());
            try {
                FileCopyUtil.copyFile((File)srcFile, (File)dstFile);
            }
            catch (IOException e) {
                String[] error = new String[]{e.getMessage()};
                return error;
            }
        }
        return null;
    }

    public boolean canMigrate(int category, File sourceDir) {
        File file;
        return this.isValidCategory(category) && sourceDir != null && sourceDir.exists() && (file = this.getMigrateFile(sourceDir)) != null && file.exists() && file.canRead();
    }

    private File getMigrateFile(File sourceDir) {
        File migrate = new File(sourceDir, "o.jdeveloper.perforce");
        if (migrate.exists() && (migrate = new File(migrate, "perforcecon.xml")).exists()) {
            return migrate;
        }
        migrate = new File(sourceDir, "o.jdeveloper.perforce2");
        if (migrate.exists() && (migrate = new File(migrate, "perforcecon.xml")).exists()) {
            return migrate;
        }
        migrate = new File(sourceDir, "perforcecon.xml");
        if (migrate.exists()) {
            return migrate;
        }
        return null;
    }

    private void migrateSingleConnection(File migrateFile, File destDir) {
        Perforce903to11111Connection old = new Perforce903to11111Connection();
        try {
            PerforceConnectionProfile con = old.loadConnection(migrateFile.toURI().toURL());
            if (con != null) {
                PerforceConnectionHelper helper = new PerforceConnectionHelper();
                ArrayList<PerforceConnectionProfile> col = new ArrayList<PerforceConnectionProfile>();
                col.add(con);
                helper.setPersistedProfiles(col);
            }
        }
        catch (Exception e) {
            sLogger.warning("Failed to migrate the perforce connection ");
        }
    }
}

