/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.merge;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.runner.RunProcess;
import oracle.jdeveloper.vcs.migrate.VCSStreamMonitor;
import oracle.jdevimpl.vcs.perforce2.merge.ConflictFile;

public class MergeConflictMonitor
extends VCSStreamMonitor {
    private List conflictFiles = new ArrayList();
    private ConflictFile currentFile;
    private static final String INFO = "info:";
    private static final String MERGING = "- merging";
    private static final String USING_BASE = "using base";
    private static final String RESOLVE_SKIPPED = "resolve skipped.";

    public List getConflicts() {
        return this.conflictFiles;
    }

    protected final void streamLine(String line, RunProcess process) {
        if (line.startsWith(INFO)) {
            int mergeFilePos = line.indexOf(MERGING);
            int baseFilePos = line.indexOf(USING_BASE);
            if (mergeFilePos > 0 && baseFilePos > 0 && baseFilePos > mergeFilePos) {
                this.currentFile = this.getConflictDetails(line, mergeFilePos, baseFilePos);
            } else if (line.endsWith(RESOLVE_SKIPPED)) {
                this.conflictFiles.add(this.currentFile);
            }
        }
    }

    private ConflictFile getConflictDetails(String line, int mergeFilePos, int baseFilePos) {
        ConflictFile conflict = new ConflictFile();
        String temp = line.substring(INFO.length(), mergeFilePos);
        int pos = this.getFileNamePos(temp);
        if (pos < 0) {
            pos = 0;
        }
        conflict.ourFile = temp.substring(pos).trim();
        temp = line.substring(mergeFilePos, baseFilePos);
        pos = this.getFileNamePos(temp);
        if (pos < 0) {
            pos = mergeFilePos + MERGING.length();
        }
        conflict.theirFile = temp.substring(pos).trim();
        temp = line.substring(baseFilePos);
        pos = this.getFileNamePos(temp);
        if (pos < 0) {
            pos = baseFilePos + USING_BASE.length();
        }
        conflict.baseFile = temp.substring(pos).trim();
        return conflict;
    }

    private int getFileNamePos(String temp) {
        int pos = temp.lastIndexOf(47);
        if (pos < 0) {
            pos = temp.lastIndexOf(92);
        }
        if (pos >= 0) {
            ++pos;
        }
        return pos;
    }
}

