/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.history;

import java.awt.Component;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.util.ImageIconCache;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.vcs.generic.HistoryEntryProducer;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceRevisionNumber;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.PerforceURLInfoCache;
import oracle.jdevimpl.vcs.perforce2.error.PerforceProcessException;
import oracle.jdevimpl.vcs.perforce2.history.PerforceHistoryEntry;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PerforceHistoryEntryProducer
implements HistoryEntryProducer {
    private static final Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceHistoryEntryProducer.class.getName());
    private DateFormat _dateFormat;

    public HistoryEntry[] produceEntries(URL url) {
        PerforceRevisionNumber rNumber = PerforceURLInfoCache.getInstance().getRevisionInfo(url);
        ArrayList<String> command = new ArrayList<String>();
        command.add("filelog");
        command.add("-l");
        command.add("-t");
        PerforceShellRunner runner = new PerforceShellRunner();
        runner.setConnection(PerforceConnectionManager.getInstance().getConnectionProfile(url));
        runner.setCmdList(command);
        runner.setOptionDirURL(URLFileSystem.getParent((URL)url));
        ArrayList<String> filename = new ArrayList<String>(1);
        filename.add(PerforceUtil.convertToAscii(URLFileSystem.getFileName((URL)url)));
        runner.setFiles(filename);
        runner.setCmdList(command);
        runner.setQuiet(true);
        try {
            runner.exec();
            List revisions = this.read(url, runner.getOutputText(), rNumber != null ? rNumber.getHaveRevision() : "");
            return revisions.toArray(new HistoryEntry[revisions.size()]);
        }
        catch (Exception e) {
            if (runner.getExitCode() == null || runner.getExitCode() != 0) {
                PerforceProcessException ex = new PerforceProcessException(PerforceArb.get("ERROR_HISTORY_FAILED_TITLE"), PerforceArb.get("ERROR_HISTORY_FAILED"), runner.getErrorText());
                new VCSExceptionHandler().handleException((Exception)((Object)ex), (Component)VCSWindowUtils.getCurrentWindow());
            }
            sLogger.log(Level.WARNING, "Failed to get version history for " + URLFileSystem.getPlatformPathName((URL)url));
            return new HistoryEntry[0];
        }
    }

    private final List read(URL url, String log, String headRev) {
        ImageIcon icon = ImageIconCache.get((URL)PerforceArb.class.getResource(PerforceArb.get("PERFORCE_CONNECTION_ICON")));
        ArrayList<PerforceHistoryEntry> list = new ArrayList<PerforceHistoryEntry>();
        Pattern separatorRE = Pattern.compile("^\\.\\.\\. ", 8);
        String revision = "#([0-9]+)\\s+change\\s+([0-9]+)\\s+([^\\s]*)\\s+on\\s+([0-9/]*\\p{Space}[0-9:]*)\\s+by\\s+([^\\s]*)\\s+\\(([^\\)]*)\\)\\s+";
        Pattern shortRE = Pattern.compile("#([0-9]+)\\s+change\\s+([0-9]+)\\s+([^\\s]*)\\s+on\\s+([0-9/]*\\p{Space}[0-9:]*)\\s+by\\s+([^\\s]*)\\s+\\(([^\\)]*)\\)\\s+'(.*)'");
        Pattern longRE = Pattern.compile("#([0-9]+)\\s+change\\s+([0-9]+)\\s+([^\\s]*)\\s+on\\s+([0-9/]*\\p{Space}[0-9:]*)\\s+by\\s+([^\\s]*)\\s+\\(([^\\)]*)\\)\\s+[\\n\\r\\f]*(\\s+.*)");
        String[] revisions = separatorRE.split(log);
        for (int i = 0; i < revisions.length; ++i) {
            Matcher matcher = longRE.matcher(revisions[i]);
            if (!matcher.find() && !(matcher = shortRE.matcher(revisions[i])).find()) {
                matcher = null;
            }
            if (matcher == null) continue;
            String revisionNumber = matcher.group(1);
            String changelist = matcher.group(2);
            String action = matcher.group(3);
            Date date = this.getDate(matcher.group(4));
            String user = matcher.group(5);
            int pos = user.indexOf(64);
            String client = null;
            if (pos > 0 && pos + 1 < user.length()) {
                client = user.substring(pos + 1);
                user = user.substring(0, pos);
            }
            String description = this.removeNewlines(matcher.group(7));
            RevisionIdentifier rIdentifier = new RevisionIdentifier((Icon)icon, revisionNumber);
            rIdentifier.setCurrent(headRev.equals(revisionNumber));
            PerforceHistoryEntry entry = new PerforceHistoryEntry(url, rIdentifier, date, changelist, action, user, client, description);
            list.add(entry);
        }
        return list;
    }

    private String removeNewlines(String description) {
        Pattern newlineRE = Pattern.compile("[\\n\\r\\f\\t]");
        String[] lines = newlineRE.split(description);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < lines.length; ++i) {
            buffer.append(lines[i]);
            if (i >= lines.length - 1 || lines[i].length() <= 0) continue;
            buffer.append(" ");
        }
        return buffer.toString();
    }

    private Date getDate(String date) {
        if (date != null) {
            try {
                Date realDate = this.getDateFormater().parse(date);
                return realDate;
            }
            catch (ParseException pe) {
                sLogger.log(Level.WARNING, "Failed to parse " + date);
            }
        }
        return null;
    }

    private DateFormat getDateFormater() {
        if (this._dateFormat == null) {
            this._dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        }
        return this._dateFormat;
    }
}

