/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cmd;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdevimpl.vcs.perforce2.cmd.PerforceSyncCommand;

public final class PerforceSyncProjectCommand
extends PerforceSyncCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.perforce2.syncProject";

    public PerforceSyncProjectCommand() {
        super(COMMAND_ID);
    }

    protected int doitImpl(VCSProfile profile) throws Exception {
        Locatable[] locatables = this.getContextLocatablesToSync();
        URL[] urls = VCSModelUtils.convertNodesToURLs((Locatable[])locatables);
        Node[] affectedNodes = this.getCachedBaseURLNodes(urls);
        if (!this.saveDirtyNodes((Locatable[])affectedNodes)) {
            return 1;
        }
        CommandState commandState = this.getCommandState(profile, locatables, affectedNodes, urls);
        if (commandState == null) {
            return 9;
        }
        if (this.isSilent(this.getContext(), profile)) {
            this.invokeCommandSilently(profile, commandState);
            return 1;
        }
        boolean success = this.invokeCommand(profile, commandState);
        this.postInvoke(profile, commandState);
        return success ? 0 : 1;
    }

    protected CommandState getCommandState(VCSProfile profile, Locatable[] locatables, Node[] affectedNodes, URL[] urls) throws Exception {
        Collection nodesPreCoalesce = this.getFilteredSelection(locatables);
        Collection nodes = this.coalesceNodesForSync(nodesPreCoalesce);
        Map timestamps = VCSBufferUtils.storeTimestamps(Arrays.asList(affectedNodes));
        VCSDirectoryInvokableState invokableState = new VCSDirectoryInvokableState(VCSModelUtils.convertNodesToURLs((Collection)nodes));
        CommandState commandState = new CommandState();
        commandState.setInvokableState(invokableState);
        commandState.setTimestampMap(timestamps);
        commandState.setLocatables(nodes.toArray(new Locatable[0]));
        return commandState;
    }

    protected Locatable[] getContextLocatablesToSync() {
        Collection prj = this.getContextProject(this.getContextLocatables());
        if (prj.size() > 0) {
            return this.getProjectFolderNodes(prj);
        }
        return null;
    }

    private Collection getContextProject(Locatable[] locatables) {
        ArrayList<Locatable> prjs = new ArrayList<Locatable>();
        for (Locatable locatable : locatables) {
            if (!(locatable instanceof Project)) continue;
            prjs.add(locatable);
        }
        return prjs;
    }

    private final Node[] getCachedBaseURLNodes(URL[] baseUrls) {
        return VCSModelUtils.findCachedNodes((URLFilter)VCSURLFilters.createBaseURLContentsFilter((URL[])baseUrls));
    }

    protected Collection coalesceNodesForSync(Collection nodes) {
        return this.coalesceNodesForFolderOperation(nodes, false);
    }

    protected final Locatable[] getProjectFolderNodes(Collection project) {
        URL[] urls = this.getProjectFolderURLs(project);
        return new LinkedHashSet<Locatable>(Arrays.asList(VCSModelUtils.findOrCreateNodes((URL[])urls))).toArray(new Locatable[0]);
    }

    private URL[] getProjectFolderURLs(Collection projects) {
        Iterator it = projects.iterator();
        ArrayList urls = new ArrayList();
        while (it.hasNext()) {
            Project project = (Project)it.next();
            urls.addAll(this.getCandidateProjectSourcePathURLs(project));
        }
        return urls.toArray(new URL[0]);
    }

    private URL[] getProjectSourcePathURLs(Project project) {
        LinkedHashSet<URL> baseDirectoryUrls = new LinkedHashSet<URL>();
        baseDirectoryUrls.add(URLFileSystem.getParent((URL)project.getURL()));
        baseDirectoryUrls.addAll(ProjectContent.getInstance((PropertyStorage)project).getAllContents().getAllRootDirs().asList());
        return baseDirectoryUrls.toArray(new URL[0]);
    }

    private Collection getCandidateProjectSourcePathURLs(Project project) {
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        urls.addAll(Arrays.asList(this.getProjectSourcePathURLs(project)));
        return urls;
    }
}

