/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cmd;

import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.help.HelpSystem;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.cmd.PerforceLoginCommand;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.ui.PerforceLoginUIPanel;

public class PerforceMultiLoginCommand
extends PerforceLoginCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.perforce2.mltlogin";
    private PerforceLoginUIPanel _panel;

    public PerforceMultiLoginCommand() {
        super(COMMAND_ID);
    }

    @Override
    protected int doitImpl(VCSProfile vcsProfile) throws Exception {
        List<PerforceConnectionProfile> connects = this.getLoggedOutConnectionProfile();
        if (connects.size() == 1) {
            this.setConnectionProfile(connects.get(0));
            return super.doitImpl(vcsProfile);
        }
        this._panel = new PerforceLoginUIPanel(connects);
        JEWTDialog dialog = this.createLoginDialog(this._panel);
        dialog.setOKButtonEnabled(true);
        dialog.addVetoableChangeListener((VetoableChangeListener)new PerforceLoginCommand.LoginVetoableChangeListener());
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._panel, this.getHelpTopicId());
        if (dialog.runDialog()) {
            return 0;
        }
        return 1;
    }

    @Override
    protected PerforceConnectionProfile getConnectionProfile() {
        if (this._panel == null) {
            return super.getConnectionProfile();
        }
        return this._panel.getConnectionProfile();
    }

    protected String getDialogHint() {
        if (this._panel == null) {
            return super.getDialogHint();
        }
        return PerforceArb.get("CONNECT_LOGIN_TO");
    }

    private List<PerforceConnectionProfile> getLoggedOutConnectionProfile() throws Exception {
        ArrayList<PerforceConnectionProfile> connected = new ArrayList<PerforceConnectionProfile>();
        Collection<PerforceConnectionProfile> cons = PerforceConnectionManager.getInstance().list();
        for (PerforceConnectionProfile con : cons) {
            if (PerforceSessionManager.getInstance().isConnected(con)) continue;
            connected.add(con);
        }
        return connected;
    }
}

