/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cl.node;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.controls.OverlayIcon;
import oracle.ide.model.Locatable;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ImageIconCache;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.res.Bundle;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;

public class ChangelistFileNode
implements Locatable {
    private URL _url;
    private String _label;
    private String _depotFile;
    private String _action;
    private Icon _icon;
    private String _tooltip;
    private PerforceConnectionProfile _connect;

    public ChangelistFileNode(PerforceConnectionProfile connect, URL url, String depotFile, String action) {
        this._connect = connect;
        this._url = url;
        this._depotFile = depotFile;
        this._action = action;
        this._label = url.getPath();
    }

    public String toString() {
        return this._label;
    }

    public String getToolTipText() {
        if (this._tooltip == null) {
            this._tooltip = this.getToolTip();
        }
        return this._tooltip;
    }

    public Icon getIcon() {
        if (this._icon == null) {
            this._icon = new OverlayIcon(OracleIcons.getIcon((String)"file.png"), this.getIconForAction(this._action));
        }
        return this._icon;
    }

    private String getToolTip() {
        if (this._action.equals("delete")) {
            return PerforceArb.get("PENDING_OPEN_DELETE");
        }
        if (this._action.equals("add")) {
            return PerforceArb.get("PENDING_OPEN_ADD");
        }
        if (this._action.equals("edit")) {
            return PerforceArb.get("PENDING_OPEN_EDIT");
        }
        return null;
    }

    private Icon getIconForAction(String _action) {
        if (_action.equals("delete")) {
            return ImageIconCache.get((URL)Bundle.class.getResource(Bundle.get("OVERLAY_DELETE")));
        }
        if (_action.equals("add")) {
            return ImageIconCache.get((URL)Bundle.class.getResource(Bundle.get("OVERLAY_ADD")));
        }
        if (_action.equals("edit")) {
            return ImageIconCache.get((URL)Bundle.class.getResource(Bundle.get("OVERLAY_OPEN")));
        }
        return null;
    }

    public URL getURL() {
        return this._url;
    }

    public void setURL(URL url) {
        this._url = url;
    }

    public PerforceConnectionProfile getConnectionProfile() {
        return this._connect;
    }
}

