/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cl.cmd;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.generic.ActionCommand;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.cl.node.ChangelistNoNode;
import oracle.jdevimpl.vcs.perforce2.error.PerforceProcessException;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.ChangeListFile;
import oracle.jdevimpl.vcs.perforce2.util.PerforceCommands;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PerforceDeleteChangelistCommand
extends ActionCommand {
    public static final String COMMAND_ID = "oracle.jdeveloper.perforce2.deletechangelist";
    private static Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceDeleteChangelistCommand.class.getName());

    public PerforceDeleteChangelistCommand() {
        super(Ide.findCmdID((String)COMMAND_ID).intValue());
    }

    public int doitImpl() throws Exception {
        Context context = this.getContext();
        Element[] elms = context.getSelection();
        if (!(elms[0].getData() instanceof ChangelistNoNode)) {
            return 1;
        }
        ChangelistNoNode cl = (ChangelistNoNode)elms[0].getData();
        try {
            Collection<ChangeListFile> files = PerforceCommands.getOpenFilesOnChangelist(cl.getConnectionProfile(), cl.getChangelistNo());
            if (files.size() > 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)PerforceArb.format("ERROR_DEL_CHANGELIST", cl.getChangelistNo()), (String)PerforceArb.get("ERROR_DEL_CHANGELIST_TITLE"), null);
                return 1;
            }
            this.deleteChangelist(cl.getConnectionProfile(), cl.getChangelistNo());
        }
        catch (Exception e) {
            PerforceProfile.getErrorHandler().handleException(e);
            return 1;
        }
        PerforceUtil.changelistSubmitted(cl.getConnectionProfile(), cl.getChangelistNo());
        return 0;
    }

    private void deleteChangelist(PerforceConnectionProfile connect, String changeNo) throws PerforceProcessException {
        PerforceShellRunner runner = new PerforceShellRunner();
        runner.setConnection(connect);
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("change");
        cmds.add("-d");
        cmds.add(changeNo);
        runner.setCmdList(cmds);
        try {
            runner.exec();
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, "Failed to delete changelist " + changeNo);
            throw new PerforceProcessException(PerforceArb.get("DELETE_CL_ERROR_TITLE"), PerforceArb.format("DELETE_CL_ERROR_MESSAGE", changeNo), e.getMessage());
        }
        if (runner.getExitCode() == null || runner.getExitCode() != 0) {
            sLogger.log(Level.WARNING, "Failed to move file(s) to changelist " + changeNo);
            throw new PerforceProcessException(PerforceArb.get("MOVE_ERROR_TITLE"), PerforceArb.get("MOVE_ERROR_MESSAGE"), runner.getErrorText());
        }
    }
}

