/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cl;

import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Locatable;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ImageIconCache;
import oracle.jdevimpl.vcs.perforce2.ConnectionEvent;
import oracle.jdevimpl.vcs.perforce2.ConnectionSessionListener;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.cl.ChangelistTreeNode;
import oracle.jdevimpl.vcs.perforce2.cl.ConnectionDetail;
import oracle.jdevimpl.vcs.perforce2.cl.PendingCLTreeModel;
import oracle.jdevimpl.vcs.perforce2.cl.node.ChangelistFileNode;
import oracle.jdevimpl.vcs.perforce2.cl.node.ChangelistNoNode;
import oracle.jdevimpl.vcs.perforce2.cl.node.PendingChangelistNode;
import oracle.jdevimpl.vcs.perforce2.cl.node.ServerDepotNode;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;

public class PendingChangelistTree
extends JTree {
    private static Logger sLogger = PerforceProfile.getQualifiedLogger(PendingChangelistTree.class.getName());

    public PendingChangelistTree(DefaultTreeModel model) {
        super(model);
        this.setCellRenderer(new ChangelistTreeCellRender());
        this.getSelectionModel().setSelectionMode(4);
        PerforceSessionManager.getInstance().addConnectionListeners(new TreeConnectionListener());
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        ToolTipManager.sharedInstance().registerComponent(this);
        int num = model.getChildCount(model.getRoot());
        for (int n = num - 1; n >= 0; --n) {
            TreePath path = this.getPathForRow(n);
            this.setExpandedState(path, true);
        }
    }

    Collection<Element> getElementSelection() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Element> nodes = new ArrayList<Element>();
        for (TreePath path : paths) {
            nodes.add(new ElementAdapter((DefaultMutableTreeNode)path.getLastPathComponent()));
        }
        return nodes;
    }

    void refresh() throws IOException {
        PendingCLTreeModel model = (PendingCLTreeModel)this.getModel();
        DefaultMutableTreeNode node = this.getSelectionPath() != null ? (DefaultMutableTreeNode)this.getSelectionPath().getLastPathComponent() : (DefaultMutableTreeNode)model.getRoot();
        model.reload(node);
    }

    void expandRootNode() {
        TreePath path = this.getPathForRow(0);
        this.setExpandedState(path, true);
    }

    private class ElementAdapter
    implements Element,
    Locatable,
    ConnectionDetail {
        private DefaultMutableTreeNode _node;
        private Collection<Element> _children;

        private ElementAdapter(DefaultMutableTreeNode node) {
            this._node = node;
        }

        public boolean mayHaveChildren() {
            return this._node.getAllowsChildren();
        }

        public Iterator<Element> getChildren() {
            this._children = new ArrayList<Element>();
            for (int c = 0; c < this._node.getChildCount(); ++c) {
                ElementAdapter ea = new ElementAdapter((DefaultMutableTreeNode)this._node.getChildAt(c));
                this._children.add(ea);
            }
            return this._children.iterator();
        }

        public Attributes getAttributes() {
            return ElementAttributes.EMPTY_ATTRIBUTES;
        }

        public Object getData() {
            return this._node.getUserObject();
        }

        public String getShortLabel() {
            return null;
        }

        public String getLongLabel() {
            return null;
        }

        public Icon getIcon() {
            return null;
        }

        public String getToolTipText() {
            return null;
        }

        public URL getURL() {
            if (this._node.getUserObject() instanceof Locatable) {
                return ((Locatable)this._node.getUserObject()).getURL();
            }
            return null;
        }

        public void setURL(URL url) {
        }

        @Override
        public PerforceConnectionProfile getConnectionProfile() {
            if (this._node.getUserObject() instanceof PendingChangelistNode) {
                return ((PendingChangelistNode)this._node.getUserObject()).getConnectionProfile();
            }
            if (this._node.getUserObject() instanceof ChangelistFileNode) {
                return ((ChangelistFileNode)this._node.getUserObject()).getConnectionProfile();
            }
            return null;
        }
    }

    private class TreeConnectionListener
    implements ConnectionSessionListener {
        private TreeConnectionListener() {
        }

        @Override
        public void connected(ConnectionEvent ce) {
        }

        @Override
        public void disconnected(ConnectionEvent ce) {
            PerforceConnectionProfile con = ce.getSource();
            final PendingCLTreeModel model = (PendingCLTreeModel)PendingChangelistTree.this.getModel();
            for (int c = 0; c < model.getChildCount(model.getRoot()); ++c) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)model.getChild(model.getRoot(), c);
                if (!((ServerDepotNode)child.getUserObject()).getConnectionProfile().equals(con)) continue;
                ChangelistTreeNode pendingNode = (ChangelistTreeNode)model.getChild(child, 0);
                final ArrayList<DefaultMutableTreeNode> rmList = new ArrayList<DefaultMutableTreeNode>();
                pendingNode.setClosing(true);
                for (int sc = 0; sc < model.getChildCount(pendingNode); ++sc) {
                    DefaultMutableTreeNode schild = (DefaultMutableTreeNode)model.getChild(pendingNode, sc);
                    rmList.add(schild);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Iterator it = rmList.iterator();
                        while (it.hasNext()) {
                            model.removeNodeFromParent((MutableTreeNode)it.next());
                        }
                    }
                });
                pendingNode.setClosing(false);
            }
        }
    }

    private class PerforceTransferHandler
    extends TransferHandler {
        private PerforceTransferHandler() {
        }

        @Override
        public boolean canImport(JComponent c, DataFlavor[] ft) {
            System.out.println("canImport");
            return super.canImport(c, ft);
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            System.out.println("createTransferable");
            return super.createTransferable(c);
        }

        @Override
        public void exportAsDrag(JComponent comp, InputEvent e, int action) {
            System.out.println("exportAsDrag");
            super.exportAsDrag(comp, e, action);
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            System.out.println("exportDone");
            super.exportDone(source, data, action);
        }

        @Override
        public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
            System.out.println("exportToClipboard");
            super.exportToClipboard(comp, clip, action);
        }

        @Override
        public int getSourceActions(JComponent c) {
            System.out.println("getSourceActions");
            return 2;
        }

        @Override
        public Icon getVisualRepresentation(Transferable t) {
            System.out.println("getVisualRepresentation");
            return super.getVisualRepresentation(t);
        }

        @Override
        public boolean importData(JComponent c, Transferable t) {
            System.out.println("importData");
            return super.importData(c, t);
        }
    }

    private class ChangelistTreeCellRender
    extends DefaultTreeCellRenderer {
        private ChangelistTreeCellRender() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof ChangelistFileNode) {
                this.setIcon(((ChangelistFileNode)node.getUserObject()).getIcon());
                this.setToolTipText(((ChangelistFileNode)node.getUserObject()).getToolTipText());
            } else if (node.getUserObject() instanceof ChangelistNoNode) {
                this.setIcon(OracleIcons.getIcon((String)"bullist.png"));
            } else if (node.getUserObject() instanceof PendingChangelistNode) {
                this.setIcon(OracleIcons.getIcon((String)"legend.png"));
            } else if (node.getUserObject() instanceof ServerDepotNode) {
                this.setIcon(ImageIconCache.get((URL)PerforceArb.class.getResource(PerforceArb.get("PERFORCE_CONNECTION_ICON"))));
            }
            return this;
        }
    }
}

