/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cl;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.cl.cmd.MoveChangelistCommand;
import oracle.jdevimpl.vcs.perforce2.cl.cmd.PerforceCLRefresh;
import oracle.jdevimpl.vcs.perforce2.cl.cmd.PerforceCLSubmitChangelistCommand;
import oracle.jdevimpl.vcs.perforce2.cl.cmd.PerforceDeleteChangelistCommand;
import oracle.jdevimpl.vcs.perforce2.cl.node.ChangelistFileNode;
import oracle.jdevimpl.vcs.perforce2.cl.node.ChangelistNoNode;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public class PendingChangelistController
implements Controller {
    private static final Logger sLogger = PerforceProfile.getQualifiedLogger(PendingChangelistController.class.getName());

    public boolean update(IdeAction action, Context context) {
        int cmd = action.getCommandId();
        Element elm = context.getElement();
        if (cmd == Ide.findCmdID((String)"oracle.jdeveloper.vcs.perforce2.refreshcl")) {
            action.setEnabled(true);
            return true;
        }
        if (cmd == Ide.findCmdID((String)"oracle.jdeveloper.perforce2.cl.cmd.submitchangelist")) {
            if (elm.getData() instanceof ChangelistNoNode) {
                action.setEnabled(true);
            }
            return true;
        }
        if (cmd == Ide.findCmdID((String)"oracle.jdeveloper.perforce2.deletechangelist")) {
            action.setEnabled(this.canDeleteCL(context));
            return true;
        }
        if (cmd == Ide.findCmdID((String)"oracle.jdeveloper.perforce2.movechangelist")) {
            if (elm.getData() instanceof ChangelistFileNode) {
                action.setEnabled(true);
            }
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmd = action.getCommandId();
        if (cmd == Ide.findCmdID((String)"oracle.jdeveloper.vcs.perforce2.refreshcl")) {
            this.invokeCommand(context, new PerforceCLRefresh());
            return true;
        }
        if (cmd == Ide.findCmdID((String)"oracle.jdeveloper.perforce2.cl.cmd.submitchangelist")) {
            VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce");
            PerforceCLSubmitChangelistCommand command = new PerforceCLSubmitChangelistCommand();
            command.setProfile(profile);
            this.invokeCommand(context, (Command)command);
            return true;
        }
        if (cmd == Ide.findCmdID((String)"oracle.jdeveloper.perforce2.deletechangelist")) {
            VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce");
            PerforceDeleteChangelistCommand command = new PerforceDeleteChangelistCommand();
            this.invokeCommand(context, (Command)command);
            return true;
        }
        if (cmd == Ide.findCmdID((String)"oracle.jdeveloper.perforce2.movechangelist")) {
            this.invokeCommand(context, new MoveChangelistCommand());
            return true;
        }
        return false;
    }

    private void invokeCommand(Context context, Command command) {
        try {
            command.setContext(context);
            CommandProcessor.getInstance().invoke(command);
        }
        catch (Exception e) {
            PerforceProfile.getErrorHandler().handleException(e);
            sLogger.log(Level.WARNING, "Error " + e.getMessage());
        }
    }

    private boolean canDeleteCL(Context context) {
        Element[] elms = context.getSelection();
        if (!(elms[0].getData() instanceof ChangelistNoNode)) {
            return false;
        }
        if (elms[0].mayHaveChildren()) {
            ChangelistNoNode clNode = (ChangelistNoNode)elms[0].getData();
            try {
                String defaultCL = PerforceUtil.getDefaultChangelist(clNode.getConnectionProfile());
                return !clNode.getChangelistNo().equals(defaultCL);
            }
            catch (Exception e) {
                sLogger.warning("Can't delete changelist " + e.getMessage());
            }
        }
        return false;
    }
}

