/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.cl;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.cl.node.CLContainer;

public final class ChangelistTreeNode
extends DefaultMutableTreeNode {
    private static final Logger sLogger = PerforceProfile.getQualifiedLogger(ChangelistTreeNode.class.getName());
    private boolean _populated = false;
    private boolean _loading = false;
    private boolean _closing = false;

    public ChangelistTreeNode(Object userObj) {
        super(userObj, userObj instanceof CLContainer);
    }

    public void setClosing(boolean value) {
        this._closing = value;
    }

    @Override
    public int getChildCount() {
        this.populate();
        return super.getChildCount();
    }

    public Enumeration children() {
        this.populate();
        return super.children();
    }

    @Override
    public boolean isLeaf() {
        return !(this.getUserObject() instanceof CLContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populate() {
        if (!(this._populated || this._loading || this._closing)) {
            this._loading = true;
            try {
                if (this.getUserObject() instanceof CLContainer) {
                    Collection kids = ((CLContainer)this.getUserObject()).getChildren();
                    Iterator it = kids.iterator();
                    while (it.hasNext()) {
                        ChangelistTreeNode tNode = new ChangelistTreeNode(it.next());
                        this.add(tNode);
                    }
                }
                this._populated = true;
            }
            catch (Exception e) {
                sLogger.log(Level.WARNING, "Error " + e.getMessage());
            }
            finally {
                this._loading = false;
            }
        }
    }

    void removeAll() {
        this.removeAllChildren();
        this._populated = false;
    }
}

