/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2.changelist;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.net.URLFactory;
import oracle.ide.runner.RunProcess;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.migrate.VCSStreamMonitor;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.changelist.PerforceAbstractEventQueue;

public class PerforceCandidateEventQueue
extends PerforceAbstractEventQueue {
    private int _iBatch;

    public PerforceCandidateEventQueue(ChangeList changeList) {
        super(changeList);
        changeList.setExcludeDirectories(true);
        String btn = System.getProperty("PERFORCE_CHANGELIST_NO");
        this._iBatch = btn == null ? 20 : Integer.parseInt(btn);
    }

    protected int getBatchCount() {
        return this._iBatch;
    }

    @Override
    protected Collection<VCSHashURL> getFiles(PerforceConnectionProfile connection) throws VCSException {
        final ArrayList<VCSHashURL> modUrl = new ArrayList<VCSHashURL>();
        PerforceShellRunner runner = new PerforceShellRunner();
        ArrayList<String> cmds = new ArrayList<String>();
        final URL root = PerforceSessionManager.getInstance().getClientRootFolder(connection);
        cmds.add("status");
        Map envp = runner.getEnvpMap();
        runner.setOptionDirURL(root);
        runner.setCmdList(cmds);
        runner.setConnection(connection);
        runner.setQuiet(false);
        runner.addOutputMonitor(new VCSStreamMonitor(){

            protected void streamLine(String line, RunProcess process) throws Exception {
                String[] parts = line.split(" - ");
                URL fileURL = URLFactory.newURL((URL)root, (String)parts[0]);
                if (!GlobalIgnoreList.isGloballyIgnored((URL)fileURL)) {
                    modUrl.add(new VCSHashURL(fileURL));
                }
            }
        });
        try {
            runner.exec();
        }
        catch (Exception ex) {
            PerforceProfile.getQualifiedLogger(PerforceCandidateEventQueue.class.getName()).log(Level.WARNING, "Failed to find unversioned files " + ex.getMessage());
        }
        return modUrl;
    }
}

