/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2;

import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.generic.StatusResolver;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceFstatResult;
import oracle.jdevimpl.vcs.perforce2.PerforceGetStatus;
import oracle.jdevimpl.vcs.perforce2.PerforceRevisionNumber;
import oracle.jdevimpl.vcs.perforce2.PerforceSessionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceURLInfoCache;
import oracle.jdevimpl.vcs.perforce2.util.PerforceUtil;

public final class PerforceStatusResolver
implements StatusResolver {
    private URLFilter _defaultFilter;
    private URLFilter _clientRootFilter;
    private VCSStatus _unrecognizedStatus;

    public void populateStatuses(VCSProfile profile, URL[] urls, VCSStatus[] statuses) throws Exception {
        URL[] copyurls = new URL[urls.length];
        if (this._unrecognizedStatus == null) {
            this._unrecognizedStatus = profile.getStatusInstance("oracle.jdeveloper.vcs.status.UNRECOGNIZED");
        }
        if (!PerforceSessionManager.getInstance().hasConnection()) {
            this.UnRecognized(statuses);
            return;
        }
        if (this._defaultFilter == null) {
            this._defaultFilter = profile.getURLFilter("oracle.jdeveloper.vcs.filters.url.DEFAULT");
            this._clientRootFilter = profile.getURLFilter("oracle.jdeveloper.perforce.filters.url.CLIENT_ROOT");
        }
        System.arraycopy(urls, 0, copyurls, 0, urls.length);
        for (int u = 0; u < copyurls.length; ++u) {
            if (!this._defaultFilter.accept(copyurls[u]) || !this._clientRootFilter.accept(copyurls[u])) {
                statuses[u] = this._unrecognizedStatus;
                copyurls[u] = null;
                continue;
            }
            if (!URLFileSystem.isDirectoryPath((URL)copyurls[u])) continue;
            statuses[u] = this._unrecognizedStatus;
            copyurls[u] = null;
        }
        if (this.assigned(statuses)) {
            return;
        }
        PerforceConnectionProfile connect = null;
        for (int u = 0; u < urls.length && connect == null; ++u) {
            connect = PerforceConnectionManager.getInstance().getConnectionProfile(urls[u]);
        }
        if (connect == null) {
            return;
        }
        PerforceFstatResult[] results = this.fixUp(PerforceGetStatus.fstat(connect, copyurls), copyurls);
        for (int r = 0; r < results.length; ++r) {
            PerforceFstatResult result = results[r];
            if (result == null) continue;
            statuses[r] = this.getStatus(profile, result, copyurls[r]);
            if (statuses[r].isVersioned() && result.getHeadRevNo() > 0) {
                PerforceRevisionNumber number = this.getRevisionNumber(result);
                PerforceURLInfoCache.getInstance().putRevisionInfo(copyurls[r], number);
            }
            if (result.getChangelist() == null) continue;
            PerforceURLInfoCache.getInstance().putChangeList(copyurls[r], result.getChangelist());
        }
        PerforceUtil.clear(connect);
    }

    private VCSStatus getStatus(VCSProfile profile, PerforceFstatResult result, URL url) {
        if (result.isNotUnderRoot()) {
            return this._unrecognizedStatus;
        }
        if (result.isNotVersioned()) {
            return profile.getStatusInstance("UNVERSIONED");
        }
        String action = result.getAction();
        if (action != null) {
            if (action.equals("add")) {
                return profile.getStatusInstance("ADDED");
            }
            if (action.equals("delete")) {
                if (!URLFileSystem.exists((URL)url)) {
                    return profile.getStatusInstance("DELETE");
                }
                return profile.getStatusInstance("UNVERSIONED");
            }
            if (result.isLocked()) {
                return profile.getStatusInstance("OPENLOCKED");
            }
            if (result.isUnresolved()) {
                return profile.getStatusInstance("UNRESOLVED");
            }
            return profile.getStatusInstance("OPENEDIT");
        }
        if (result.getHeadAction().equals("delete")) {
            return profile.getStatusInstance("UNVERSIONED");
        }
        return profile.getStatusInstance("NOTOPEN");
    }

    private boolean assigned(VCSStatus[] statuses) {
        for (VCSStatus status : statuses) {
            if (status != null) continue;
            return false;
        }
        return true;
    }

    private VCSStatus[] UnRecognized(VCSStatus[] status) {
        for (int u = 0; u < status.length; ++u) {
            status[u] = this._unrecognizedStatus;
        }
        return status;
    }

    private PerforceRevisionNumber getRevisionNumber(PerforceFstatResult result) {
        if (result.getHaveRev() == null) {
            return null;
        }
        return PerforceRevisionNumber.createRevisionNumber(result.getHaveRev(), result.getHeadRev());
    }

    private PerforceFstatResult[] fixUp(PerforceFstatResult[] results, URL[] urls) {
        PerforceFstatResult[] fixResults = new PerforceFstatResult[urls.length];
        int resultCopy = 0;
        for (int u = 0; u < urls.length; ++u) {
            if (urls[u] == null) continue;
            fixResults[u] = results[resultCopy];
            ++resultCopy;
        }
        return fixResults;
    }
}

