/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import oracle.ide.config.Preferences;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPrintWriter;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.RunProcessListener;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.migrate.VCSShellRunner;
import oracle.jdeveloper.vcs.spi.VCSPreferences;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.prefs.PerforceSystemPreferences;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;

public final class PerforceShellRunner
extends VCSShellRunner {
    private static final String PERFORCE_MESSAGE_PREFIX = "perforce client> ";
    static final String PERFORCE_EXE_NAME = "p4";
    private static final Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceShellRunner.class.getName());
    private String _useclient;
    private LogPrintWriter _logWriter;
    private final RunProcessListener _timeoutListener = new RunProcessListener(){

        public final void processFinished(int exitCode) {
            long timeout = PerforceShellRunner.this.getTimeout();
            if (PerforceShellRunner.this._quiet || PerforceShellRunner.this.getExitCode() != null) {
                return;
            }
            if (!PerforceShellRunner.this.isTimedOut() || timeout <= 0L) {
                return;
            }
            if (PerforceShellRunner.this.getPrintWriter() != null) {
                PerforceShellRunner.this.getPrintWriter().println(PerforceShellRunner.PERFORCE_MESSAGE_PREFIX + PerforceShellRunner.getTimeoutErrorMessage(timeout));
            }
        }
    };
    private List _files = null;
    private boolean _quiet = false;
    private boolean _wait = true;
    private List connectLst;
    private List directoryList;

    public PerforceShellRunner() {
        this.setTimeout(-1L);
        this.getSimpleProcess().setShowStartStatus(false);
        this.getSimpleProcess().setAddToProcessesFolder(false);
        Integer value = VCSProfileRegistry.getInstance() != null ? this.getPreferenceTimeOut() : Integer.valueOf(60);
        if (value != null) {
            this.setTimeout((int)((double)value.intValue() * Math.pow(10.0, 3.0)));
        }
    }

    public final void setClientCommand(String client) {
        this._useclient = client;
    }

    public final void setFiles(List files) {
        this._files = files;
    }

    public final void setQuiet(boolean quiet) {
        this._quiet = LogManager.getLogManager() == null ? true : quiet;
    }

    public final void setWait(boolean wait) {
        this._wait = wait;
    }

    public final List getFiles() {
        return this._files;
    }

    public final boolean isQuiet() {
        return this._quiet;
    }

    public void setOptionDirURL(URL dir) {
        this.directoryList = new ArrayList();
        this.directoryList.add("-d");
        this.directoryList.add(URLFileSystem.getPlatformPathName((URL)dir));
    }

    public final boolean getWait() {
        return this._wait;
    }

    public void exec() throws Exception {
        boolean quiet = this.isQuiet();
        Boolean write = this.writeMsgToLogConsole();
        if (write != null && !write.booleanValue()) {
            quiet = true;
        }
        this.getSimpleProcess().setUseLogPage(!quiet);
        this.getSimpleProcess().setUseLogPageQuietly(true);
        this.getSimpleProcess().setLogPage(quiet ? null : LogManager.getLogManager().getMsgPage());
        this.getSimpleProcess().setAddToTerminateMenu(!this.isQuiet());
        this.getSimpleProcess().setRunProcessListener(this._timeoutListener);
        if (this._wait) {
            super.execAndWait();
        } else {
            super.exec();
        }
    }

    public int execAndWait() throws Exception {
        throw new UnsupportedOperationException();
    }

    public String getErrorText() {
        String error = super.getErrorText();
        long timeout = this.getTimeout();
        if (!this.isTimedOut() || timeout <= 0L) {
            return error;
        }
        StringBuffer sb = new StringBuffer();
        if (error != null && error.length() > 0) {
            sb.append(error);
            sb.append('\n');
        }
        sb.append(PerforceShellRunner.getTimeoutErrorMessage(timeout));
        return sb.toString();
    }

    public final void setConnection(PerforceConnectionProfile connection) {
        this.connectLst = new ArrayList();
        if (connection.getServer() != null && connection.getServer().length() > 0) {
            this.connectLst.add("-p");
            this.connectLst.add(connection.getServer());
        }
        if (connection.getClient() != null && connection.getClient().length() > 0) {
            this.connectLst.add("-c");
            this.connectLst.add(connection.getClient());
        }
        if (connection.getUser() != null && connection.getUser().length() > 0) {
            this.connectLst.add("-u");
            this.connectLst.add(connection.getUser());
        }
    }

    private static final String getTimeoutErrorMessage(long timeout) {
        return PerforceArb.format("MESSAGE_TEMPLATE_PROCESS_TIMEOUT", Long.toString(timeout));
    }

    private String getClient() {
        if (this._useclient == null) {
            return PerforceSystemPreferences.getInstance((PropertyStorage)Preferences.getPreferences()).getPerforceCommandLocation();
        }
        return this._useclient;
    }

    private LogPrintWriter getPrintWriter() {
        if (this._logWriter == null && LogManager.getLogManager() != null) {
            this._logWriter = new LogPrintWriter(LogManager.getLogManager().getMsgPage());
        }
        return this._logWriter;
    }

    private Integer getPreferenceTimeOut() {
        int iTime = VCSPreferences.getInstance((PropertyStorage)Preferences.getPreferences(), (String)"oracle.jdeveloper.perforce").getOperationTimeout();
        return (int)((double)iTime * Math.pow(10.0, 3.0));
    }

    private Boolean writeMsgToLogConsole() {
        return VCSPreferences.getInstance((PropertyStorage)Preferences.getPreferences(), (String)"oracle.jdeveloper.perforce").getAutoLogMessages();
    }

    protected String createCommandStringForLog(String[] cmdArray) {
        if (this.connectLst != null) {
            StringBuffer commandLogString = new StringBuffer(this.getClient());
            if (cmdArray != null) {
                for (int s = 0; s < cmdArray.length; ++s) {
                    commandLogString.append(' ');
                    commandLogString.append(cmdArray[s]);
                }
            }
            if (this._files != null) {
                Iterator it = this._files.iterator();
                while (it.hasNext()) {
                    commandLogString.append(' ');
                    commandLogString.append((String)it.next());
                }
            }
            return commandLogString.toString();
        }
        return null;
    }

    protected String[] createCommandSpi(String[] cmdArray) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.getClient());
        if (this.connectLst != null) {
            cmd.addAll(this.connectLst);
        }
        if (this.directoryList != null) {
            cmd.addAll(this.directoryList);
        }
        if (cmdArray != null) {
            cmd.addAll(Arrays.asList(cmdArray));
        }
        if (this._files != null) {
            cmd.addAll(this._files);
        }
        return cmd.toArray(new String[0]);
    }

    public void writeMessage(String msg) {
        this.getPrintWriter().println(msg);
    }

    public boolean connectionError() {
        String err = this.getErrorText();
        return err.startsWith("Your session has expired");
    }
}

