/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.URLChooserShortcut;
import oracle.ide.dialogs.URLChooserShortcutProvider;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPrintWriter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.runner.RunProcess;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.migrate.VCSStreamMonitor;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdevimpl.vcs.perforce2.ConnectionEvent;
import oracle.jdevimpl.vcs.perforce2.ConnectionSessionListener;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionManager;
import oracle.jdevimpl.vcs.perforce2.PerforceConnectionProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceProfile;
import oracle.jdevimpl.vcs.perforce2.PerforceShellRunner;
import oracle.jdevimpl.vcs.perforce2.PerforceURLInfoCache;
import oracle.jdevimpl.vcs.perforce2.prefs.PerforceSystemPreferences;
import oracle.jdevimpl.vcs.perforce2.res.PerforceArb;
import oracle.jdevimpl.vcs.perforce2.util.PerforceCommands;
import oracle.jdevimpl.vcs.perforce2.util.PerforceLoginProcess;

public class PerforceSessionManager {
    private static final PerforceSessionManager _instance = new PerforceSessionManager();
    private static Logger sLogger = PerforceProfile.getQualifiedLogger(PerforceProfile.class.getName());
    private List<PerforceConnectionProfile> _connected = new ArrayList<PerforceConnectionProfile>();
    private Map<PerforceConnectionProfile, String> _sessionPass = new HashMap<PerforceConnectionProfile, String>();
    private String _clientUsed;
    private boolean _clientInstalled;
    private String _versionOutput;
    private Map clientRoot = new HashMap();
    private LogPrintWriter _logWriter;
    private URLChooserShortcutProvider _shortcutProvider;
    private Collection<ConnectionSessionListener> _connectionListeners = new ArrayList<ConnectionSessionListener>();
    private IOException _ioe;
    private Map<PerforceConnectionProfile, Map<String, String>> _connectDepotRoots = new HashMap<PerforceConnectionProfile, Map<String, String>>();

    private PerforceSessionManager() {
    }

    public static PerforceSessionManager getInstance() {
        return _instance;
    }

    public boolean isConnected(PerforceConnectionProfile connect) {
        return this._connected.contains(connect);
    }

    public String getSessionPass(PerforceConnectionProfile connect) {
        return this._sessionPass.get(connect);
    }

    public final URL getClientRootFolder(PerforceConnectionProfile connect) {
        String key = this.getServerClientKey(connect.getServer(), connect.getClient());
        if (this.clientRoot.containsKey(key)) {
            return (URL)this.clientRoot.get(key);
        }
        if (this.isConnected(connect)) {
            try {
                PerforceShellRunner runner = this.getPerforceInfo(connect);
                this.clientNameAndFolder(connect.getServer(), runner.getOutputText());
                return (URL)this.clientRoot.get(key);
            }
            catch (Exception e) {
                sLogger.log(Level.WARNING, "Failed to get client root " + e.getMessage());
            }
        }
        return null;
    }

    public boolean disconnect(PerforceConnectionProfile connect, boolean notify) {
        if (!this._connected.contains(connect)) {
            return false;
        }
        this.logout(connect);
        connect.setAutoLogIn(false);
        Ide.getVersionInfo().removeComponent(PerforceArb.get("PERFORCE_ABOUT_TITLE"));
        this.clearCaches();
        this._connected.remove(connect);
        this._sessionPass.remove(connect);
        Ide.getStatusBar().setText(PerforceArb.get("STATUS_DISCONNECTED_TO_PERFORCE"));
        if (this._connected.size() == 0) {
            this.removeShortCutProvider();
        }
        if (notify) {
            this.fireDisconnectedEvent(connect);
        }
        return true;
    }

    public boolean testConnect(PerforceConnectionProfile connect) {
        if (!this.isClientVerified()) {
            this.verifyClient();
        }
        if (!this.isClientInstalled()) {
            return false;
        }
        if (!this.login(connect)) {
            return false;
        }
        this.logout(connect);
        return true;
    }

    public boolean connect(PerforceConnectionProfile connect) throws Exception {
        return this.connect(connect, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(PerforceConnectionProfile connect, boolean login) throws Exception {
        if (this._connected.contains(connect)) {
            return true;
        }
        if (!this.isClientVerified()) {
            this.verifyClient();
        }
        if (!this.isClientInstalled()) {
            return false;
        }
        if (login && !this.login(connect)) {
            return false;
        }
        PerforceSessionManager perforceSessionManager = this;
        synchronized (perforceSessionManager) {
            this._connected.add(connect);
        }
        PerforceConnectionManager.getInstance().addConnection(connect);
        sLogger.log(Level.INFO, " Connected to Perforce server");
        if (this._connected.size() == 1) {
            DialogUtil.addURLChooserShortcutProvider((URLChooserShortcutProvider)this.getShortCutProvider());
        }
        Ide.getStatusBar().setText(PerforceArb.get("STATUS_CONNECTED_TO_PERFORCE"));
        this.clearCaches();
        this.fireConnectedEvent(connect);
        return true;
    }

    private void clearCaches() {
        VCSControlCache.getInstance().fireControlStateChanged("oracle.jdeveloper.perforce");
        if (!IdeUtil.isHeadless()) {
            VCSProfile profile = VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.perforce");
            profile.getPolicyStatusCache().clear();
        }
        PerforceURLInfoCache.getInstance().clear();
    }

    public URLChooserShortcutProvider getShortCutProvider() {
        if (this._shortcutProvider == null) {
            this._shortcutProvider = new URLChooserShortcutProvider(){
                Collection<URLChooserShortcut> shortColl = null;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Collection<URLChooserShortcut> createShortcuts(Context context) {
                    this.shortColl = new ArrayList<URLChooserShortcut>();
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        for (PerforceConnectionProfile con : PerforceSessionManager.this._connected) {
                            String name = PerforceArb.get("OPEN_PERFORCE");
                            if (con.getName() != null && con.getName().length() > 0) {
                                name = con.getName();
                            }
                            URLChooserShortcut cs = new URLChooserShortcut(OracleIcons.getIcon((String)"header/mapped_rootFolder.png"), name, PerforceSessionManager.this.getClientRootFolder(con));
                            this.shortColl.add(cs);
                        }
                    }
                    return this.shortColl;
                }
            };
        }
        return this._shortcutProvider;
    }

    public URL getClientURL(PerforceConnectionProfile connect, URL serverURL) throws IOException {
        if (this.isConnected(connect)) {
            Map<String, String> depotRoots = this.getDepotRootFolders(connect);
            URL clientURL = this.getClientRootFolder(connect);
            if (clientURL == null) {
                return null;
            }
            String serverPath = serverURL.getPath();
            for (String serverDepotPath : depotRoots.keySet()) {
                if (!serverPath.startsWith(serverDepotPath)) continue;
                String depotRoot = depotRoots.get(serverDepotPath);
                String relativePath = depotRoot + serverPath.substring(serverDepotPath.length());
                return URLFactory.newURL((URL)clientURL, (String)relativePath);
            }
        }
        return null;
    }

    public void addConnectionListeners(ConnectionSessionListener con) {
        this._connectionListeners.add(con);
    }

    public void removeConnectionListeners(ConnectionSessionListener con) {
        this._connectionListeners.remove(con);
    }

    public boolean hasConnection() {
        return !this._connected.isEmpty();
    }

    public Map<String, String> getDepotRootFolders(PerforceConnectionProfile connect) throws IOException {
        if (!this._connectDepotRoots.containsKey(connect)) {
            ClientStreamMonitor monitor = new ClientStreamMonitor(connect.getClient());
            ArrayList<String> cmds = new ArrayList<String>();
            PerforceShellRunner dp = new PerforceShellRunner();
            cmds.add("client");
            cmds.add("-o");
            dp.setConnection(connect);
            dp.setCmdList(cmds);
            dp.setQuiet(true);
            dp.addOutputMonitor(monitor);
            try {
                dp.exec();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
            if (dp.getExitCode() == null || dp.getExitCode() != 0) {
                throw new IOException(PerforceArb.get("ERROR_DEPOTS") + dp.getErrorText());
            }
            this._connectDepotRoots.put(connect, monitor.getMapping());
        }
        return this._connectDepotRoots.get(connect);
    }

    private boolean login(PerforceConnectionProfile connect) {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("-p");
        cmds.add(connect.getServer());
        cmds.add("-u");
        cmds.add(connect.getUser());
        cmds.add("login");
        PerforceLoginProcess login = new PerforceLoginProcess(cmds, connect.getUser());
        login.setCmdPasswd(connect.getConnectionPassword());
        login.execAndWait();
        login.destroyProcess();
        return !login.isError();
    }

    private boolean logout(PerforceConnectionProfile connect) {
        try {
            PerforceCommands.logout(connect.getServer(), connect.getUser());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private PrintWriter getLogWriter() {
        if (this._logWriter == null) {
            this._logWriter = new LogPrintWriter(LogManager.getLogManager().getMsgPage());
        }
        return this._logWriter;
    }

    private void removeShortCutProvider() {
        DialogUtil.removeURLChooserShortcutProvider((URLChooserShortcutProvider)this.getShortCutProvider());
        this._shortcutProvider = null;
    }

    private String getClientVersionInfo(PerforceConnectionProfile connect) throws Exception {
        String[] sections;
        String versionInfo = null;
        if (this.getVersionOutput(connect) != null && (sections = this.getVersionOutput(connect).split("/")).length > 1) {
            versionInfo = sections[sections.length - 2];
        }
        return versionInfo != null ? versionInfo.trim() : "?";
    }

    private String getVersionOutput(PerforceConnectionProfile connect) throws Exception {
        if (this._versionOutput == null) {
            this._versionOutput = this.checkVersion(connect);
        }
        return this._versionOutput;
    }

    private boolean isClientVerified() {
        if (this._clientUsed == null) {
            return false;
        }
        return this._clientUsed.equals(PerforceSystemPreferences.getInstance((PropertyStorage)Preferences.getPreferences()).getPerforceCommandLocation());
    }

    public boolean isClientInstalled() {
        this.verifyClient();
        return this._clientInstalled;
    }

    public Collection<PerforceConnectionProfile> getConnectedProfiles() {
        return this._connected;
    }

    private void verifyClient() {
        if (this.isClientVerified()) {
            return;
        }
        this._clientInstalled = this.perforceClientOnPath();
        if (!this._clientInstalled) {
            this.getLogWriter().println(PerforceArb.get("WARNING_PERFORCE_UNSUPPORTED"));
        }
    }

    private boolean perforceClientOnPath() {
        URL clientExe;
        String cmd;
        this._clientUsed = cmd = PerforceSystemPreferences.getInstance((PropertyStorage)Preferences.getPreferences()).getPerforceCommandLocation();
        return !(!cmd.contains(File.separator) ? (clientExe = VCSFileSystemUtils.searchSystemPath((String)cmd)) == null : !URLFileSystem.exists((URL)URLFactory.newFileURL((String)cmd)));
    }

    private final String checkVersion(PerforceConnectionProfile connect) throws Exception {
        PerforceShellRunner com = this.getPerforceInfo(connect);
        Pattern pattern = Pattern.compile("Server version: ((\\w+)/(\\w+))(\\/(\\d+)\\.(\\d+))(/(\\d+))");
        Matcher matcher = pattern.matcher(com.getOutputText());
        this.clientNameAndFolder(connect.getServer(), com.getOutputText());
        if (matcher.find()) {
            String version = matcher.group(0);
            return version;
        }
        return null;
    }

    private PerforceShellRunner getPerforceInfo(PerforceConnectionProfile connect) throws Exception {
        if (this._ioe != null) {
            throw this._ioe;
        }
        PerforceShellRunner com = new PerforceShellRunner();
        com.setConnection(connect);
        com.setCommand("info");
        com.setQuiet(true);
        try {
            com.exec();
        }
        catch (IOException ioe) {
            this._ioe = ioe;
            throw this._ioe;
        }
        if (com.getExitCode() == null || com.getExitCode() != 0) {
            throw new Exception();
        }
        return com;
    }

    private void clientNameAndFolder(String server, String text) {
        String[] lines = text.split("\n");
        String rootdir = null;
        String name = null;
        for (String line : lines) {
            String[] part = line.split("Client root:");
            if (part.length == 2) {
                rootdir = part[1].trim();
                continue;
            }
            part = line.split("Client name:");
            if (part.length != 2) continue;
            name = part[1].trim();
        }
        if (name != null && rootdir != null) {
            URL url = URLFactory.newDirURL(rootdir);
            this.clientRoot.put(this.getServerClientKey(server, name), URLFileSystem.canonicalize((URL)url));
        }
    }

    private void fireConnectedEvent(PerforceConnectionProfile perforceConnection) {
        Iterator<ConnectionSessionListener> it = this._connectionListeners.iterator();
        ConnectionEvent ce = new ConnectionEvent(perforceConnection);
        while (it.hasNext()) {
            it.next().connected(ce);
        }
    }

    private void fireDisconnectedEvent(PerforceConnectionProfile connect) {
        Iterator<ConnectionSessionListener> it = this._connectionListeners.iterator();
        ConnectionEvent ce = new ConnectionEvent(connect);
        while (it.hasNext()) {
            it.next().disconnected(ce);
        }
    }

    private String getServerClientKey(String server, String name) {
        StringBuilder sb = new StringBuilder(server);
        sb.append("#");
        sb.append(name);
        return sb.toString();
    }

    private static class ClientStreamMonitor
    extends VCSStreamMonitor {
        private Map<String, String> depotFolders = new HashMap<String, String>();
        private String _client;
        private boolean viewDefinition = false;

        ClientStreamMonitor(String client) {
            this._client = client;
        }

        protected void streamLine(String line, RunProcess process) throws Exception {
            String[] parts;
            if (line.startsWith("View:")) {
                this.viewDefinition = true;
            } else if (this.viewDefinition && (parts = line.split(" ")).length == 2) {
                String depotFolder = parts[0].trim().replace("...", "");
                String localFolder = parts[1].trim().replace("//" + this._client, "").replace("...", "");
                this.depotFolders.put(depotFolder, localFolder);
            }
        }

        Map getMapping() {
            return this.depotFolders;
        }
    }
}

