/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.perforce2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PerforceConnectionProfile {
    private String name;
    private String user;
    private char[] password;
    private String server;
    private String client;
    private String _host;
    private Integer _port;
    private String _label;
    private boolean _autoLogIn;

    public PerforceConnectionProfile() {
        this(null, null, null, null, null);
    }

    public PerforceConnectionProfile(String name, String user, char[] password, String server, String client) {
        this.name = name;
        this.user = user;
        if (password != null) {
            this.password = password;
        }
        this.server = server;
        this.client = client;
        this._autoLogIn = false;
    }

    public void setAutoLogIn(boolean _autoLogIn) {
        this._autoLogIn = _autoLogIn;
    }

    public boolean isAutoLogIn() {
        return this._autoLogIn;
    }

    public void setName(String name) {
        this.name = name;
        this._label = null;
    }

    public String getName() {
        return this.name;
    }

    public void setUser(String user) {
        this.user = user;
        this._label = null;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(char[] password) {
        this.password = (char[])(password != null ? password : null);
    }

    public char[] getConnectionPassword() {
        if (this.password != null) {
            return this.password;
        }
        return null;
    }

    public void setServer(String server) {
        this.server = server;
        this._label = null;
        this._host = null;
    }

    public String getServer() {
        return this.server;
    }

    public void setClient(String client) {
        this.client = client;
        this._label = null;
    }

    public String getClient() {
        return this.client;
    }

    public List getOptionSwitches() {
        ArrayList<Object> args = new ArrayList<Object>();
        if (this.getUser() != null) {
            args.add("-u");
            args.add(this.getUser());
        }
        if (this.getConnectionPassword() != null) {
            args.add("-P");
            args.add(this.getConnectionPassword());
        }
        if (this.getServer() != null) {
            args.add("-p");
            args.add(this.getServer());
        }
        if (this.getClient() != null) {
            args.add("-c");
            args.add(this.getClient());
        }
        return args;
    }

    public Map getEnvironmentSettings() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.getUser() != null) {
            map.put("P4USER", this.getUser());
        }
        if (this.getConnectionPassword() != null) {
            map.put("P4PASSWD", this.getConnectionPassword());
        }
        if (this.getServer() != null) {
            map.put("P4PORT", this.getServer());
        }
        if (this.getClient() != null) {
            map.put("P4CLIENT", this.getClient());
        }
        return map;
    }

    public String getHostName() {
        if (this._host == null && this.server != null) {
            this.portAndHost();
        }
        return this._host;
    }

    public Integer getPortNumber() {
        if (this._port == null && this.server != null) {
            this.portAndHost();
        }
        return this._port;
    }

    public String toString() {
        if (this.name == null || this.name.isEmpty()) {
            if (this._label == null) {
                StringBuilder label = new StringBuilder();
                label.append(this.getServer());
                if (this.getUser() != null) {
                    label.append(", ");
                    label.append(this.getUser());
                }
                if (this.getClient() != null) {
                    label.append(", ");
                    label.append(this.getClient());
                }
                this._label = label.toString();
            }
            return this._label;
        }
        return this.name;
    }

    public boolean equals(PerforceConnectionProfile con) {
        return con.getServer().equals(this.server) && con.getUser() != null && con.getUser().equals(this.user) && con.getClient() != null && con.getClient().equals(this.client);
    }

    private void portAndHost() {
        String[] sp = this.server.split(":");
        if (sp.length == 3) {
            this._host = sp[0] + ':' + sp[1];
            this._port = new Integer(Integer.parseInt(sp[2]));
        } else if (sp.length == 2) {
            this._host = sp[0];
            this._port = new Integer(Integer.parseInt(sp[1]));
        } else {
            this._host = "";
            this._port = new Integer(Integer.parseInt(this.server));
        }
    }
}

