/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.wiz.shared;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import oracle.jdevimpl.vcs.cvs.control.CVSConnectionComboBoxRenderer;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.ui.CVSModuleSelectionPanelUI;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardPage;

public abstract class CVSAbstractModulePage
extends CVSWizardPage {
    protected CVSAbstractModulePage() {
    }

    protected abstract CVSModuleSelectionPanelUI getModuleSelectionPanel();

    protected void createPanel() {
        this.initializePanel();
        this.getModuleSelectionPanel().getModuleSelectionPanel().grabFocus();
    }

    @Override
    public Component getFocusComponent() {
        return this.getModuleSelectionPanel().getConnectionNameCombo();
    }

    protected final void setComboItem(JComboBox combo, Object item) {
        Util.setComboItem(combo, item);
    }

    protected final boolean isValidModuleName(String s) {
        return Util.isValidModuleName(s);
    }

    protected final void connectionNameChanged() {
        this._connectionNameComboBox_actionPerformed(null);
    }

    private void _connectionNameComboBox_actionPerformed(ActionEvent e) {
        String connectionName = (String)this.getModuleSelectionPanel().getConnectionNameCombo().getSelectedItem();
        if (connectionName == null) {
            connectionName = "";
        }
        this.getModuleSelectionPanel().getModuleSelectionPanel().connectionNameChanged(connectionName);
    }

    private void initializePanel() {
        this.initializeConnectionComboBox();
        this.initializeModuleSelectionPanel();
    }

    private void initializeConnectionComboBox() {
        JComboBox connectionCombo = this.getModuleSelectionPanel().getConnectionNameCombo();
        Util.initializeConnectionComboBox(connectionCombo);
        connectionCombo.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                CVSAbstractModulePage.this._connectionNameComboBox_actionPerformed(e);
            }
        });
    }

    private void initializeModuleSelectionPanel() {
        this.getModuleSelectionPanel().getModuleSelectionPanel().setParentComponent(this.getModuleSelectionPanel());
        this._connectionNameComboBox_actionPerformed(null);
    }

    public static class Util {
        public static final void initializeConnectionComboBox(JComboBox connectionCombo) {
            connectionCombo.setEditable(false);
            ArrayList<String> names = new ArrayList<String>(CVSConnectionNodes.getConnectionListAPI().getConnectionNames());
            Collections.sort(names);
            for (int i = 0; i < names.size(); ++i) {
                connectionCombo.addItem(names.get(i));
            }
            if (names.size() > 0) {
                connectionCombo.setSelectedIndex(0);
            }
            connectionCombo.setRenderer(new CVSConnectionComboBoxRenderer());
        }

        public static final void setComboItem(JComboBox combo, Object item) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)combo.getModel();
            if (model.getIndexOf(item) < 0) {
                combo.addItem(item);
            }
            combo.setSelectedItem(item);
        }

        public static final boolean isValidModuleName(String s) {
            return s != null && !Util.isWhitespace(s);
        }

        private static final boolean isWhitespace(String s) {
            if (s.equals("")) {
                return true;
            }
            String illegal = " \t\n\f\r";
            for (int i = 0; i < s.length(); ++i) {
                if (" \t\n\f\r".indexOf(s.charAt(i)) >= 0) continue;
                return false;
            }
            return true;
        }
    }
}

