/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.wiz.import_;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSInternalClientSupport;
import oracle.jdevimpl.vcs.cvs.CVSResourcePicker;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.control.CVSHintContainer;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListAPI;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.ui.CVSImportOptionsPageUI;
import oracle.jdevimpl.vcs.cvs.ui.CVSImportOptionsUI;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardPage;
import oracle.jdevimpl.vcs.cvs.wiz.import_.CVSImportModelKey;

public final class CVSImportOptionsPage
extends CVSWizardPage
implements CVSImportModelKey {
    private JComponent _panel = null;
    private CVSImportOptionsPageUI _ui = new CVSImportOptionsPageUI();
    private CVSImportOptionsUI _ui2 = new CVSImportOptionsUI();

    CVSImportOptionsPage() {
        this.createPanel();
    }

    private void createPanel() {
        CVSResourcePicker.getPicker(this.getClass()).start((Container)this._ui);
        CVSResourcePicker.getPicker(this.getClass()).start((Container)this._ui2);
        this._ui.getOptionsPanel().removeAll();
        this._ui.getOptionsPanel().setLayout(new BorderLayout());
        this._ui.getOptionsPanel().add((Component)this._ui2, "Center");
        if (!this.isUseTimestampSupported()) {
            this._ui2.getUseTimestampCheckBox().setEnabled(false);
        }
        String hint = CVSArb.get("IMPORT_OPTIONS_PAGE_HINT");
        this._panel = new CVSHintContainer(hint, this._ui);
    }

    @Override
    public String getAccessibleDescription() {
        return CVSArb.get("IMPORT_OPTIONS_PAGE_HINT");
    }

    @Override
    public String getHelpTopic() {
        return "f1_cvsimpwoptions_html";
    }

    @Override
    public JComponent getPanel() {
        return this._panel;
    }

    @Override
    public Component getFocusComponent() {
        return this.isUseTimestampSupported() ? this._ui2.getUseTimestampCheckBox() : this._ui2.getDoCheckoutCheckBox();
    }

    @Override
    public String getLabel() {
        return CVSArb.get("IMPORT_OPTIONS_PAGE_LABEL");
    }

    @Override
    public Object[] getPropertyKeys() {
        ArrayList<Object> options = new ArrayList<Object>();
        options.add(KEY_IMPORT_USE_TIMESTAMP);
        options.add(KEY_IMPORT_DO_CHECKOUT);
        return options.toArray();
    }

    @Override
    public void populatePage(Map props) {
        Map defaults = this.createDefaultOptionsValues();
        defaults.putAll(props);
        props = defaults;
        if (props.containsKey(KEY_IMPORT_DO_CHECKOUT)) {
            this._ui2.getDoCheckoutCheckBox().setSelected((Boolean)props.get(KEY_IMPORT_DO_CHECKOUT));
        }
        if (this.isUseTimestampSupported()) {
            boolean use_ts_enabled = this.isUseTimestampEnabled(props);
            if (props.containsKey(KEY_IMPORT_USE_TIMESTAMP)) {
                this._ui2.getUseTimestampCheckBox().setSelected((Boolean)props.get(KEY_IMPORT_USE_TIMESTAMP) != false && use_ts_enabled);
            }
            this._ui2.getUseTimestampCheckBox().setEnabled(use_ts_enabled);
        }
    }

    @Override
    public void validatePage() throws CVSWizardException {
    }

    @Override
    public void applyPage(Map props) {
        if (this.isUseTimestampSupported() && this.isUseTimestampEnabled(props)) {
            props.put(KEY_IMPORT_USE_TIMESTAMP, new Boolean(this._ui2.getUseTimestampCheckBox().isSelected()));
        }
        props.put(KEY_IMPORT_DO_CHECKOUT, new Boolean(this._ui2.getDoCheckoutCheckBox().isSelected()));
    }

    private final boolean isUseTimestampEnabled(Map props) {
        String connection = (String)props.get(KEY_IMPORT_CONNECTION_NAME);
        if (connection == null) {
            return false;
        }
        CVSConnectionListAPI list = CVSConnectionNodes.getConnectionListAPI();
        String root = ((CVSConnectionListData)list).getConnectionRoot(connection);
        if (root == null) {
            return false;
        }
        return new CVSRootString(root).isAccessLocal();
    }

    protected Map createDefaultOptionsValues() {
        HashMap<Object, Boolean> defaultOptionValues = new HashMap<Object, Boolean>();
        defaultOptionValues.put(KEY_IMPORT_DO_CHECKOUT, Boolean.TRUE);
        return defaultOptionValues;
    }

    private boolean isUseTimestampSupported() {
        return !CVSClient.getInstance().isUsingInternalClient() || CVSInternalClientSupport.isSupportedCommandOption("import", 'd');
    }
}

