/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.wiz.import_;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionModuleNameCache;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodeUtils;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.op.CVSOperationAdd;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.CVSListFilesUtil;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardAbortException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardCommitWatcher;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardCommitter;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardProcessMonitor;
import oracle.jdevimpl.vcs.cvs.wiz.import_.CVSImportModelKey;
import oracle.jdevimpl.vcs.util.FileOrFolderFilter;
import oracle.jdevimpl.vcs.util.FilterPanel;

public final class CVSImportCommitter
extends CVSWizardCommitter
implements CVSImportModelKey {
    @Override
    public String getCommitText() {
        return CVSArb.get("IMPORT_COMMITTER_TEXT");
    }

    @Override
    public String getCommitTitle() {
        return CVSArb.get("IMPORT_COMMITTER_TITLE");
    }

    @Override
    public void prepareCommit(Map props, Component modal_c) throws CVSWizardException, CVSWizardAbortException {
        CVSConnectionData connection = CVSConnectionNodes.getConnectionListData().getConnectionAPI(props.get(KEY_IMPORT_CONNECTION_NAME).toString());
        if (connection != null && connection.getEncoding() != null && !connection.getEncoding().equals(IdeUtil.getIdeEncoding()) && !MessageDialog.confirm((Component)modal_c, (Object)CVSArb.get("CONFIRM_IMPORT_ENCODING_CLASH"), (String)CVSArb.get("CONFIRM_IMPORT_ENCODING_CLASH_TITLE"), null)) {
            throw new CVSWizardAbortException();
        }
        try {
            CVSConnectionNodeUtils.ensureLogin(props.get(KEY_IMPORT_CONNECTION_NAME).toString(), modal_c);
        }
        catch (VCSCancelException cce) {
            throw new CVSWizardAbortException();
        }
        catch (VCSException ce) {
            throw new CVSWizardException(ce.getMessage());
        }
        catch (Exception e) {
            CVSClient.getInstance().getExceptionHandler().handleException(e, modal_c);
            return;
        }
        URL dir = URLFactory.newDirURL((URL)URLFactory.newFileURL((String)props.get(CVSImportModelKey.KEY_IMPORT_SOURCES).toString()), (String)"");
        List<URL> urls = CVSListFilesUtil.listFiles(dir, 5);
        Collection selectedFilters = new FilterPanel().createFileOrFolderFilters((Collection)props.get(CVSImportModelKey.KEY_IMPORT_FILTER_PATTERNS), false);
        for (FileOrFolderFilter filter : selectedFilters) {
            filter.setApplyRecursively(true);
        }
        Iterator itr = urls.iterator();
        block5: while (itr.hasNext()) {
            URL url = (URL)itr.next();
            Iterator itr2 = selectedFilters.iterator();
            while (itr2.hasNext()) {
                if (!((URLFilter)itr2.next()).accept(url)) continue;
                itr.remove();
                continue block5;
            }
        }
        if (!CVSOperationAdd.registerUnrecognizedFileTypesUI(urls.toArray(new URL[0]))) {
            throw new CVSWizardAbortException();
        }
    }

    static final Collection<String> createRunnerOptions(Map props, boolean noDiskChanges) {
        Object value;
        Collection filters;
        ArrayList<String> options = new ArrayList<String>();
        String comments = (String)props.get(KEY_IMPORT_COMMENTS);
        URL commentFile = null;
        if (CVSClient.getInstance().isUsingInternalClient() && !noDiskChanges) {
            try {
                commentFile = URLFactory.newFileURL((File)File.createTempFile(".jdevcvs_cmt", null));
                CVSUtil.writeFileBytes(commentFile, comments.getBytes("UTF-8"));
                options.add("-F");
                options.add(URLFileSystem.getPlatformPathName((URL)commentFile));
            }
            catch (IOException ioe) {
                Assert.printStackTrace((Throwable)ioe);
                commentFile = null;
            }
        }
        if (commentFile == null) {
            options.add("-m");
            if (comments.equals("")) {
                comments = "\"\"";
            }
            options.add(comments);
        }
        if ((filters = (Collection)props.get(CVSImportModelKey.KEY_IMPORT_FILTER_PATTERNS)) == null) {
            options.add("-I");
            options.add("!");
        } else {
            Iterator itr = filters.iterator();
            while (itr.hasNext()) {
                options.add("-I");
                options.add(itr.next().toString());
            }
        }
        String[] wrappers = CVSUtil.getCVSWrappers();
        if (wrappers != null) {
            for (int i = 0; i < wrappers.length; ++i) {
                options.add(wrappers[i]);
            }
        }
        if ((value = props.get(KEY_IMPORT_USE_TIMESTAMP)) != null && ((Boolean)value).booleanValue()) {
            options.add("-d");
        }
        options.add(props.get(KEY_IMPORT_MODULE_NAME).toString());
        options.add(props.get(KEY_IMPORT_VENDOR_TAG).toString());
        options.add(props.get(KEY_IMPORT_RELEASE_TAG).toString());
        return options;
    }

    @Override
    public void commitWizard(Map props, Component modal_c, CVSWizardCommitWatcher watcher) throws CVSWizardException, CVSWizardAbortException {
        Collection<String> options = CVSImportCommitter.createRunnerOptions(props, false);
        CVSRunner runner = null;
        try {
            List<Node> nodes;
            URL dirUrl = URLFactory.newDirURL((URL)URLFactory.newFileURL((String)props.get(KEY_IMPORT_SOURCES).toString()), (String)"");
            if (dirUrl != null && !CVSUtil.saveDirtyNodes(nodes = Arrays.asList(CVSUtil.getCachedBaseURLNodes(new URL[]{dirUrl})))) {
                throw new VCSCancelException();
            }
            runner = CVSRunnerFactory.getInstance().createRunner();
            runner.addOutputMonitor(new CVSWizardProcessMonitor(watcher));
            runner.getParameters().setRoot(CVSImportCommitter.getConnectionRoot(props.get(KEY_IMPORT_CONNECTION_NAME).toString()));
            runner.setCommand_("import");
            runner.getParameters().setOptions(options);
            runner.getParameters().setBuilderOptions(props);
            runner.setDirURL_(dirUrl);
            runner.getParameters().setQuiet(false);
            runner.exec_();
        }
        catch (VCSCancelException cce) {
            throw new CVSWizardAbortException();
        }
        catch (VCSException ce) {
            throw new CVSWizardException(ce.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (watcher.isCancelled()) {
            throw new CVSWizardAbortException();
        }
        if (runner.getExitCode_() == null || runner.getExitCode_() != 0) {
            String error = CVSArb.get("IMPORT_COMMIT_ERROR");
            throw new CVSWizardException(error, runner.getErrorText_());
        }
    }

    @Override
    public void doneCommitting(Map props) {
        final CVSConnectionNode connectionNode = CVSConnectionNodes.getConnectionListData().getConnectionNode(props.get(KEY_IMPORT_CONNECTION_NAME).toString());
        if (connectionNode == null) {
            return;
        }
        CVSConnectionModuleNameCache.removeNames(connectionNode.getConnection().getRoot());
        connectionNode.getConnection().setModuleFileData(null);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RevertNodeCommand.reload((Node)connectionNode);
            }
        });
    }

    static final String getConnectionRoot(String connection) {
        String root = CVSConnectionNodes.getConnectionListAPI().getConnectionRoot(connection);
        Assert.check((root != null ? 1 : 0) != 0);
        return root;
    }
}

