/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.wiz.framework;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.ReentrantWizard;
import oracle.bali.ewt.wizard.TitledWizardPage;
import oracle.bali.ewt.wizard.Wizard;
import oracle.bali.ewt.wizard.WizardAdapter;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardListener;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.WizardValidateListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.vcs.util.VCSOperatingSystem;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.control.CVSHintContainer;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizard;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardAbortException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardCancelException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardCommitWatcher;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardCommitter;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardPage;

public class CVSWizardRunner {
    private BaseWizard _wizard;
    private Map _props;
    private CVSWizardPage[] _pages;
    private Image _image;
    private CVSWizard _wizardSpec;
    private CVSWizardCommitter _committer;
    private JTree _summary;
    private WizardDialog _dialog;
    private WizardValidator _wizardValidator;

    private CVSWizardRunner() {
    }

    public static final Map runWizard(CVSWizard wizard, Context context) throws CVSWizardCancelException {
        return new CVSWizardRunner()._runWizard(wizard, context);
    }

    public static final void commitWizard(Map props, CVSWizardCommitter committer, Context context) throws CVSWizardAbortException, CVSWizardException, Exception {
        new CVSWizardRunner()._commitWizard(props, committer, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map _runWizard(CVSWizard wizard, Context context) throws CVSWizardCancelException {
        this._wizardSpec = wizard;
        this._wizardSpec.setContext(context);
        this.createWizard();
        Image image = this._image = wizard.getWizardImage() != null ? wizard.getWizardImage().getImage() : null;
        if (this._image != null) {
            this._wizard.setLogoImage(this._image);
            this._wizard.setHeaderGradientBackground(new Color[]{new Color(-1), new Color(-3219482)});
        }
        this.setCommitter(wizard.getCommitter(), context);
        this._props = wizard.getDefaultProperties();
        if (this._props == null) {
            this._props = new HashMap();
        }
        this.createPages();
        this._wizardValidator = new WizardValidator();
        this._wizard.addWizardListener((WizardListener)this._wizardValidator);
        this._wizardValidator.updateFinishablePage();
        this._dialog = new WizardReturnDialog(null, (Frame)Ide.getMainWindow(), true);
        this._dialog.setWizard(this._wizard);
        this.updateWizardTitle();
        try {
            if (!CVSDialogRunner.runDialog((JDialog)this._dialog)) {
                throw new CVSWizardCancelException();
            }
        }
        finally {
            for (int i = 0; i < this._pages.length; ++i) {
                this._pages[i].disposePage();
            }
        }
        this._committer.doneCommitting(this._props);
        this._wizardSpec.wizardFinished();
        HashMap results = this._props != null ? new HashMap(this._props) : null;
        this.resetFields();
        return results;
    }

    private void _commitWizard(Map props, CVSWizardCommitter committer, Context context) throws CVSWizardAbortException, CVSWizardException, Exception {
        this._props = props;
        this.setCommitter(committer, context);
        this.commitWizardImpl2();
        this._committer.doneCommitting(this._props);
        this.resetFields();
    }

    private void setCommitter(CVSWizardCommitter committer, Context context) {
        this._committer = committer;
        if (this._committer != null) {
            this._committer.setContext(context);
        }
    }

    private void updateWizardTitle() {
        if (this._wizard == null || this._dialog == null) {
            return;
        }
        WizardPage page = this._wizard.getSelectedPage();
        if (page == null) {
            return;
        }
        Object[] args = new Object[4];
        int i = 0;
        args[i++] = this._wizardSpec.getWizardTitle();
        args[i++] = Integer.toString(this.getSelectedRunnerPageIndex() + 1);
        args[i++] = Integer.toString(this.getRunnerPageCount());
        args[i++] = page.getLabel();
        String title = CVSArb.format(this.determineWizardTitleResource(), args);
        this._dialog.setTitle(title);
    }

    private String determineWizardTitleResource() {
        if (this.isReentrantWizard()) {
            return "WIZARD_TITLE_REENTRANT";
        }
        if (this.isSpecialPageSelected()) {
            return "WIZARD_TITLE_SPECIAL";
        }
        return "WIZARD_TITLE_NORMAL";
    }

    private void createWizard() {
        if (this.isSteppedWizard()) {
            this._wizard = new Wizard();
            this._wizard.setRoadmapVisible(true);
            return;
        }
        this._wizard = new ReentrantWizard();
        this._wizard.setRoadmapVisible(true);
        this.updateMustFinishWizard(false);
    }

    private void createPages() {
        this._pages = this._wizardSpec.getWizardPages();
        Assert.check((this._pages.length > 0 ? 1 : 0) != 0);
        Context context = this._wizardSpec.getContext();
        for (int i = 0; i < this._pages.length; ++i) {
            this._pages[i].setContext(context);
        }
        this.addContentPages();
        if (this.isSteppedWizard()) {
            this.addFinishPage();
        }
    }

    private void resetFields() {
        this._wizardValidator = null;
        this._wizard = null;
        this._props = null;
        this._pages = null;
        this._image = null;
        this._wizardSpec = null;
        this._committer = null;
        this._summary = null;
        this._dialog = null;
    }

    private void addContentPages() {
        for (int i = 0; i < this._pages.length; ++i) {
            WizardPage wp = new WizardPage((Component)this._pages[i].getPanel(), this._pages[i].getLabel());
            wp.setAccessibleDescription(this._pages[i].getAccessibleDescription());
            this._pages[i].setWizardPage(wp);
            this._pages[i].setWizard(this._wizard);
            this.populateWizardPage(this._pages[i]);
            Component c = this._pages[i].getFocusComponent();
            wp.setInitialFocus(c != null ? c : CVSUtil.findTraversableComponent(this._pages[i].getPanel()));
            this._wizard.addPage(wp);
            wp.addWizardValidateListener((WizardValidateListener)new WizardPageValidator(this._pages[i]));
            HelpSystem.getHelpSystem().registerTopic((JComponent)wp.getContent(), this._pages[i].getHelpTopic());
        }
    }

    private void addFinishPage() {
        this._summary = new JTree();
        JPanel finish = this.getFinishPanel(this._wizardSpec.getSummaryText(), this._summary);
        TitledWizardPage twp = new TitledWizardPage((Component)finish, null, CVSArb.get("WIZARD_SUMMARY_LABEL"), this._wizardSpec.getSummaryTitle());
        this._wizard.addPage((WizardPage)twp);
        HelpSystem.getHelpSystem().registerTopic((JComponent)twp.getContent(), this._wizardSpec.getSummaryHelpTopic());
    }

    private void populateSummaryTree() {
        if (this.isReentrantWizard()) {
            return;
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("ROOT");
        this._wizardSpec.populateSummaryTree(root, this._pages, this._props);
        DefaultTreeModel dtm = new DefaultTreeModel(root);
        dtm.setAsksAllowsChildren(true);
        this._summary.setModel(dtm);
        this._summary.setFont(new Font("Dialog", 0, 11));
        this._summary.setRootVisible(false);
        this._summary.setShowsRootHandles(true);
        for (int row = 0; row < this._summary.getRowCount(); ++row) {
            this._summary.expandRow(row);
        }
    }

    private JPanel getFinishPanel(String text, JTree summary) {
        JPanel panel = new JPanel();
        Insets i = new Insets(2, 2, 2, 2);
        LayoutBuilder builder = new LayoutBuilder();
        builder.add(Box.createVerticalStrut(LayoutBuilder.VERTICAL_GAP.height), i, 1, false, true);
        builder.nl();
        builder.add((Component)new CVSHintContainer(text, new JScrollPane(summary)), i, 1, true, true);
        builder.nl();
        builder.addToPanel((Container)panel);
        return panel;
    }

    private void handleException(WizardEvent e, CVSWizardException we) {
        if (e != null && e instanceof Cancelable) {
            ((Cancelable)e).cancel();
        }
        MessageDialog.error((Component)this._wizard, (Object)we.getMessage(), (String)we.getTitle(), null);
    }

    private boolean commitWizard() {
        try {
            this.commitWizardImpl2();
            return true;
        }
        catch (CVSWizardAbortException cVSWizardAbortException) {
        }
        catch (CVSWizardException we) {
            this.handleException(null, we);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitWizardImpl2() throws Exception {
        Component modalComponent = this.getCommitterModalComponent();
        this._committer.prepareCommit(this._props, modalComponent);
        String text = this._committer.getCommitText();
        String title = this._committer.getCommitTitle();
        if (text == null) {
            this.commitWizardImpl(null);
            return;
        }
        IndeterminateProgressMonitor monitor = null;
        if (!VCSOperatingSystem.isOSX() || Boolean.getBoolean("jdev.cvs.enableosxwizardprogress")) {
            monitor = new IndeterminateProgressMonitor(modalComponent, title != null ? title : IdeUtil.getProgramName(), (Object)text, "");
        }
        if (monitor != null) {
            monitor.setCancellable(this._committer.isCancellable());
        }
        try {
            if (monitor != null) {
                monitor.display();
            }
            this.commitWizardImpl(monitor);
        }
        finally {
            if (monitor != null) {
                monitor.close();
            }
        }
    }

    private void commitWizardImpl(IndeterminateProgressMonitor progress) throws Exception {
        this._committer.commitWizard(this._props, this.getCommitterModalComponent(), new CVSWizardCommitWatcher(progress));
    }

    private Component getCommitterModalComponent() {
        return this._dialog != null ? this._dialog : VCSWindowUtils.getCurrentWindow();
    }

    private void populateWizardPage(final CVSWizardPage page) {
        if (SwingUtilities.isEventDispatchThread()) {
            page.populatePage(new HashMap(this._props));
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CVSWizardRunner.this.populateWizardPage(page);
            }
        });
    }

    private void applyWizardPage(CVSWizardPage page, WizardEvent e) {
        try {
            page.validatePage();
            Object[] keys = page.getPropertyKeys();
            for (int i = 0; i < keys.length; ++i) {
                this._props.remove(keys[i]);
            }
            page.applyPage(this._props);
        }
        catch (CVSWizardException we) {
            this.handleException(e, we);
        }
    }

    private void updateCanMovePage(boolean move) {
        if (this.isReentrantWizard()) {
            return;
        }
        WizardPage page = this._wizard.getSelectedPage();
        if (page == null) {
            return;
        }
        page.setCanGoBack(move);
        page.setCanAdvance(move);
    }

    private void updateMustFinishWizard(boolean finish) {
        if (this.isReentrantWizard()) {
            return;
        }
        Wizard wizard = (Wizard)this._wizard;
        wizard.setMustFinish(finish);
    }

    private boolean isReentrantWizard() {
        return this._wizardSpec.isReentrantStyle();
    }

    private boolean isSteppedWizard() {
        return !this._wizardSpec.isReentrantStyle();
    }

    private boolean isRunnerPageSelected() {
        return this.getSelectedRunnerPageIndex() >= 0;
    }

    private boolean isSpecialPageSelected() {
        return !this.isRunnerPageSelected();
    }

    private boolean isSummaryPageSelected() {
        if (this.isReentrantWizard()) {
            return false;
        }
        return this._wizard.getCurrentPageIndex() == this._wizard.getPageCount() - 1;
    }

    private int getSelectedRunnerPageIndex() {
        int i = this._wizard.getCurrentPageIndex();
        if (this.isReentrantWizard()) {
            return i;
        }
        if (i >= 0 && i < this._wizard.getPageCount() - 1) {
            return i;
        }
        return -1;
    }

    private int getRunnerPageCount() {
        int i = this._wizard.getPageCount();
        return this.isReentrantWizard() ? i : i - 1;
    }

    private CVSWizardPage getRunnerPage(int i) {
        return this._pages[i];
    }

    private CVSWizardPage getSelectedRunnerPage() {
        int i = this.getSelectedRunnerPageIndex();
        return i >= 0 ? this._pages[i] : null;
    }

    private class WizardReturnDialog
    extends WizardDialog {
        private WizardReturnDialog(BaseWizard wizard, Frame parent, boolean modal) {
            super(wizard, parent, modal);
        }

        protected void dismissDialog(boolean cancelled) {
            if (cancelled) {
                super.dismissDialog(cancelled);
                return;
            }
            this.getWizard().setEnabled(false);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    final boolean committed = CVSWizardRunner.this.commitWizard();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (committed) {
                                WizardReturnDialog.this._dismissDialog();
                            } else {
                                WizardReturnDialog.this.getWizard().setEnabled(true);
                            }
                        }
                    });
                }
            };
            new Thread(r, "CVSWizardRunner").start();
        }

        private void _dismissDialog() {
            super.dismissDialog(false);
        }
    }

    private class WizardValidator
    extends WizardAdapter {
        private boolean _finish = false;

        private WizardValidator() {
        }

        public void wizardFinished(WizardEvent e) {
            if (!CVSWizardRunner.this.isRunnerPageSelected()) {
                return;
            }
            int n = CVSWizardRunner.this.getRunnerPageCount();
            for (int i = 0; i < n; ++i) {
                CVSWizardRunner.this.applyWizardPage(CVSWizardRunner.this.getRunnerPage(i), e);
            }
            CVSWizardRunner.this.applyWizardPage(CVSWizardRunner.this.getSelectedRunnerPage(), e);
        }

        public void wizardSelectionChanged(WizardEvent e) {
            if (CVSWizardRunner.this._wizard == null) {
                return;
            }
            CVSWizardRunner.this.updateCanMovePage(false);
            if (CVSWizardRunner.this.isRunnerPageSelected()) {
                CVSWizardRunner.this.populateWizardPage(CVSWizardRunner.this.getSelectedRunnerPage());
            }
            if (CVSWizardRunner.this.isSummaryPageSelected()) {
                CVSWizardRunner.this.populateSummaryTree();
            }
            this.updateFinishablePage();
            CVSWizardRunner.this.updateCanMovePage(true);
            CVSWizardRunner.this.updateWizardTitle();
        }

        private boolean isFinishablePage() {
            int i = CVSWizardRunner.this.getSelectedRunnerPageIndex();
            if (i == CVSWizardRunner.this.getRunnerPageCount() - 1) {
                return true;
            }
            int n = CVSWizardRunner.this._wizardSpec.getFinishablePageIndex();
            return n >= 0 && i >= n;
        }

        void updateFinishablePage() {
            if (!CVSWizardRunner.this.isSteppedWizard() || !CVSWizardRunner.this.isRunnerPageSelected()) {
                return;
            }
            this._finish = this._finish || this.isFinishablePage();
            CVSWizardRunner.this.updateMustFinishWizard(!this._finish);
        }
    }

    private class WizardPageValidator
    implements WizardValidateListener {
        private CVSWizardPage _page;

        private WizardPageValidator(CVSWizardPage page) {
            this._page = page;
        }

        public void wizardValidatePage(WizardEvent e) {
            CVSWizardRunner.this.applyWizardPage(this._page, e);
        }
    }
}

