/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.wiz.framework;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import oracle.ide.Ide;

public class CVSWizardException
extends Exception {
    private static final int MAX_DETAIL_LINES = 3;
    private String _title;

    public CVSWizardException(String message) {
        this(message, (String)null);
    }

    public CVSWizardException(String message, String detail) {
        super(CVSWizardException.buildMessage(message, detail));
    }

    public CVSWizardException(String message, String detail, String title) {
        this(message, detail);
        this._title = title;
    }

    public String getTitle() {
        return this._title != null ? this._title : Ide.getProgramName();
    }

    private static final String buildMessage(String message, String detail) {
        if (detail == null || detail.equals("")) {
            return message;
        }
        BufferedReader br = new BufferedReader(new StringReader(detail));
        ArrayList<String> l = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        sb.append('\n');
        sb.append("...");
        sb.append('\n');
        try {
            String line;
            while ((line = br.readLine()) != null) {
                l.add(line);
            }
        }
        catch (IOException ioe) {
            return message;
        }
        while (l.size() > 3) {
            l.remove(0);
        }
        for (int i = 0; i < l.size(); ++i) {
            if (i != 0) {
                sb.append('\n');
            }
            sb.append(l.get(i).toString());
        }
        return sb.toString();
    }
}

