/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.wiz.connect;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatter;
import oracle.ide.Ide;
import oracle.ide.net.URLFileSystem;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.jdeveloper.vcs.spi.VCSWaitRunnable;
import oracle.jdevimpl.vcs.cvs.CVSActiveClient;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSResourcePicker;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSClientConstants;
import oracle.jdevimpl.vcs.cvs.client.CVSMethodSpecifier;
import oracle.jdevimpl.vcs.cvs.client.CVSRootSpecifier;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.control.CVSHintContainer;
import oracle.jdevimpl.vcs.cvs.op.CVSOperationGenerateKeyPair;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.ui.CVSConnectConnectionPageUI;
import oracle.jdevimpl.vcs.cvs.ui.CVSConnectRshPanelUI;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectAccessMethod;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectModelKey;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectNameObservable;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectNamePage;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectRoot;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectRootObservable;
import oracle.jdevimpl.vcs.cvs.wiz.connect.CVSConnectRshDialog;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardException;
import oracle.jdevimpl.vcs.cvs.wiz.framework.CVSWizardPage;

public class CVSConnectConnectionPage
extends CVSWizardPage
implements CVSConnectModelKey,
CVSClientConstants,
Observer {
    public static final String METHOD_FIELD_PROXY = "proxy";
    public static final String METHOD_FIELD_PROXY_PORT1 = "proxyport";
    public static final String METHOD_FIELD_PROXY_PORT2 = "proxy_port";
    private JComponent _panel = null;
    private CVSConnectConnectionPageUI _ui = new CVSConnectConnectionPageUI();
    private final CVSConnectRshDialog _rshDialog = new CVSConnectRshDialog();
    private final Observable _rootobs;
    private CVSConnectNameObservable _nameobs;
    private transient CVSMethodSpecifier _method;
    private transient char[] _password;

    CVSConnectConnectionPage(CVSConnectNameObservable nameobs, Observable rootobs) {
        this._nameobs = nameobs;
        this._rootobs = rootobs;
        this._rootobs.addObserver(this);
        this.createPanel();
    }

    @Override
    public void update(Observable o, Object arg) {
        CVSRootString rootstr;
        CVSRootString cVSRootString = rootstr = arg != null ? (CVSRootString)arg : new CVSRootString("");
        if (!rootstr.hasKnownAccess()) {
            this._ui.getAccessMethodCombo().setSelectedItem(CVSConnectAccessMethod.ACCESS_OTHER);
            this._method = null;
            this._password = null;
        } else {
            this._ui.getAccessMethodCombo().setSelectedItem(CVSConnectRoot.getSupportedAccessMethodName(rootstr.getAccessMethod()));
            if (rootstr.supportsUserName()) {
                this._ui.getUserNameField().setText(rootstr.getUserName());
            }
            if (rootstr.supportsServerLocation()) {
                this._ui.getServerLocationField().setText(rootstr.getServerLocation());
            }
            if (rootstr.supportsPort()) {
                Integer port = rootstr.getIntegerPort();
                int i = 2401;
                if (port != null && port >= 0 && port <= 65535) {
                    i = port;
                }
                this._ui.getPortNumberSpinBox().setValue(new Integer(i));
            }
            if (rootstr.supportsRepository()) {
                this._ui.getRepositoryFileChooser().setPath(rootstr.getRepository());
            }
            this._method = rootstr.getRootSpecifier().getMethodSpecifier();
            if (rootstr.isAccessSsh2()) {
                String path = this._method.getFieldMap() != null ? (String)this._method.getFieldMap().get("key") : null;
                this._ui.getKeyCheckBox().setSelected(path != null);
                if (path != null) {
                    this._ui.getKeyFileChooser().setPath(path);
                }
            }
            this._password = rootstr.getPassword();
        }
        CVSConnectConnectionPage.updateUseProxySettingsCheckBox(this._method, this._ui.getRshPanel());
    }

    static void updateUseProxySettingsCheckBox(CVSMethodSpecifier method, CVSConnectRshPanelUI rshPanel) {
        boolean enabled = CVSConnectConnectionPage.isUseProxySettingsEnabled(method);
        rshPanel.getUseProxySettingsCheckBox().setEnabled(enabled);
        rshPanel.getUseProxySettingsCheckBox().setSelected(enabled && CVSConnectConnectionPage.isMethodMatchForProxySettings(method));
    }

    static final boolean isUseProxySettingsEnabled(CVSMethodSpecifier method) {
        if (method == null) {
            return false;
        }
        if (!method.getMethod().equals("pserver") && !method.getMethod().equals("ssh2")) {
            return false;
        }
        ProxyOptions proxyOptions = (ProxyOptions)Ide.getSettings().getData("proxy-options");
        String settingsProxyHost = proxyOptions.getProxyHost();
        String settingsProxyPort = proxyOptions.getProxyPort();
        if (settingsProxyHost == null || settingsProxyHost.equals("")) {
            return false;
        }
        return settingsProxyPort != null && !settingsProxyPort.equals("");
    }

    static final boolean isMethodMatchForProxySettings(CVSMethodSpecifier method) {
        if (!CVSConnectConnectionPage.isUseProxySettingsEnabled(method)) {
            return false;
        }
        ProxyOptions proxyOptions = ProxyOptions.getProxyOptions();
        String settingsProxyHost = proxyOptions.getProxyHost();
        String settingsProxyPort = proxyOptions.getProxyPort();
        Map accessFieldMap = method.getFieldMap();
        String methodProxyHost = CVSConnectConnectionPage.getFieldMapPServerProxy(accessFieldMap);
        String methodProxyPort = CVSConnectConnectionPage.getFieldMapPServerProxyPort(accessFieldMap);
        if (methodProxyHost == null || methodProxyPort == null) {
            return false;
        }
        return methodProxyHost.equals(settingsProxyHost) && methodProxyPort.equals(settingsProxyPort);
    }

    private static final String getFieldMapPServerProxy(Map fieldMap) {
        if (fieldMap == null) {
            return null;
        }
        return (String)fieldMap.get(METHOD_FIELD_PROXY);
    }

    private static final String getFieldMapPServerProxyPort(Map fieldMap) {
        if (fieldMap == null) {
            return null;
        }
        String proxyPort = null;
        if (proxyPort == null) {
            proxyPort = (String)fieldMap.get(METHOD_FIELD_PROXY_PORT1);
        }
        if (proxyPort == null) {
            proxyPort = (String)fieldMap.get(METHOD_FIELD_PROXY_PORT2);
        }
        return proxyPort;
    }

    private void createPanel() {
        this._ui.getGenerateKeyPairButton().setAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                VCSWaitRunnable r = new VCSWaitRunnable(CVSClient.getInstance().getExceptionHandler()){

                    protected void runImpl() throws Exception {
                        CVSOperationGenerateKeyPair command = new CVSOperationGenerateKeyPair();
                        if (command.doit() == 0 && command.getGeneratedPrivateKeyURL() != null) {
                            CVSConnectConnectionPage.this._ui.getKeyCheckBox().setSelected(true);
                            CVSConnectConnectionPage.this._ui.getKeyFileChooser().setURL(command.getGeneratedPrivateKeyURL());
                            CVSConnectConnectionPage.this.updateEnabledState();
                        }
                    }
                };
                new Thread((Runnable)r, "CVSConnectConnectionPage").start();
            }
        });
        CVSResourcePicker.getPicker(this.getClass()).start((Container)this._ui);
        this._ui.getPortNumberSpinBox().setModel(new SpinnerNumberModel(2401, 0, 65535, 1));
        this._ui.getPortNumberSpinBox().setEditor(new JSpinner.NumberEditor(this._ui.getPortNumberSpinBox(), "####"));
        this._ui.getAccessMethodLabel().setLabelFor(this._ui.getAccessMethodCombo());
        this._ui.getUserNameLabel().setLabelFor(this._ui.getUserNameField());
        this._ui.getServerLocationLabel().setLabelFor(this._ui.getServerLocationField());
        JComponent portNumberEditor = this._ui.getPortNumberSpinBox().getEditor();
        this._ui.getPortNumberLabel().setLabelFor(portNumberEditor instanceof JSpinner.DefaultEditor ? ((JSpinner.DefaultEditor)portNumberEditor).getTextField() : portNumberEditor);
        this._ui.getRepositoryLabel().setLabelFor(this._ui.getRepositoryFileChooser().getFocusComponent());
        ((DefaultFormatter)((JSpinner.DefaultEditor)this._ui.getPortNumberSpinBox().getEditor()).getTextField().getFormatter()).setAllowsInvalid(false);
        this._ui.getRshPanel().getRshConfigButton().addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent ae) {
                CVSConnectConnectionPage.this._rshDialog.showDialog(CVSConnectConnectionPage.this._panel);
            }
        });
        Collection accessOptions = CVSConnectAccessMethod.getAccessOptions();
        this._ui.getAccessMethodCombo().setModel(new DefaultComboBoxModel<Object>(accessOptions.toArray()));
        this._ui.getAccessMethodCombo().addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent ae) {
                CVSConnectConnectionPage.this.updateEnabledState();
                CVSConnectConnectionPage.this.createRootString();
                CVSConnectConnectionPage.updateUseProxySettingsCheckBox(CVSConnectConnectionPage.this._method, CVSConnectConnectionPage.this._ui.getRshPanel());
            }
        });
        this.updateEnabledState();
        this._ui.getAccessMethodCombo().setSelectedItem(CVSConnectAccessMethod.ACCESS_LOCAL);
        String hint = CVSArb.get("CONNECT_CONNECTION_PAGE_HINT");
        StringBuilder prototypeUserNameBuffer = new StringBuilder();
        for (int i = 0; i < 15; ++i) {
            prototypeUserNameBuffer.append('m');
        }
        this._ui.getUserNameField().setColumns(prototypeUserNameBuffer.length());
        this._ui.getUserNameField().setMinimumSize(new Dimension(SwingUtilities.computeStringWidth(this._ui.getUserNameField().getFontMetrics(this._ui.getUserNameField().getFont()), prototypeUserNameBuffer.toString()), this._ui.getUserNameField().getMinimumSize().height));
        this._ui.getKeyFileChooser().setChooseFolders(false);
        this._ui.getKeyFileChooser().setChooserParent(this._ui);
        this._ui.getKeyFileChooser().setDialogType(1);
        this._ui.getKeyFileChooser().setImplicitURL(CVSOperationGenerateKeyPair.DEFAULT_KEYFILE_URL);
        if (URLFileSystem.exists((URL)CVSOperationGenerateKeyPair.DEFAULT_KEYFILE_URL)) {
            this._ui.getKeyCheckBox().setSelected(true);
            this._ui.getKeyFileChooser().setURL(CVSOperationGenerateKeyPair.DEFAULT_KEYFILE_URL);
        }
        this._ui.getRepositoryFileChooser().setChooseFolders(true);
        this._ui.getRepositoryFileChooser().setDialogType(1);
        this._ui.getRepositoryFileChooser().setChooserParent(this._ui);
        if (!accessOptions.contains(CVSConnectAccessMethod.ACCESS_LOCAL) && !accessOptions.contains(CVSConnectAccessMethod.ACCESS_FORK_AS_LOCAL)) {
            this._ui.getRepositoryFileChooser().setBrowseVisible(false);
        }
        if (!accessOptions.contains(CVSConnectAccessMethod.ACCESS_SSH2)) {
            this._ui.getKeyFileChooser().setVisible(false);
            this._ui.getKeyCheckBox().setVisible(false);
            this._ui.getGenerateKeyPairButton().setVisible(false);
        }
        this._ui.getKeyCheckBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CVSConnectConnectionPage.this.updateEnabledState();
            }
        });
        this._ui.getRepositoryFileChooser().setBrowseMnemonic(CVSArb.get("CONNECT_CONNECTION_PAGE_BROWSE_MNEMONIC").charAt(0));
        this._ui.getKeyFileChooser().setBrowseMnemonic(CVSArb.get("CONNECT_CONNECTION_PAGE_BROWSE_MNEMONIC").charAt(0));
        this._panel = new CVSHintContainer(hint, this._ui);
    }

    @Override
    public String getAccessibleDescription() {
        return CVSArb.get("CONNECT_CONNECTION_PAGE_HINT");
    }

    @Override
    public String getHelpTopic() {
        return "f1_cvsconwconn_html";
    }

    @Override
    public JComponent getPanel() {
        return this._panel;
    }

    @Override
    public Component getFocusComponent() {
        return this._ui.getAccessMethodCombo();
    }

    @Override
    public String getLabel() {
        return CVSArb.get("CONNECT_CONNECTION_PAGE_LABEL");
    }

    @Override
    public Object[] getPropertyKeys() {
        ArrayList keys = new ArrayList();
        keys.addAll(this._rshDialog.getPropertyKeys());
        return keys.toArray();
    }

    @Override
    public void populatePage(Map props) {
        this._rshDialog.setProperties(props);
        Object value = props.get(KEY_CONNECTION_ROOT);
        if (value == null) {
            String userName = System.getProperty("user.name");
            String hostName = "";
            try {
                hostName = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            StringBuilder defaultRootBuffer = new StringBuilder();
            defaultRootBuffer.append(":pserver:");
            defaultRootBuffer.append(userName);
            defaultRootBuffer.append('@');
            defaultRootBuffer.append(hostName);
            defaultRootBuffer.append(":/");
            value = defaultRootBuffer.toString();
        }
        CVSRootString rootstr = new CVSRootString(value.toString());
        CVSConnectRootObservable rootobs = (CVSConnectRootObservable)this._rootobs;
        rootobs.setRoot(rootstr);
        rootobs.notifyObservers(rootstr);
    }

    @Override
    public void validatePage() throws CVSWizardException {
    }

    @Override
    public void applyPage(Map props) {
        CVSRootString rootstr = this.createRootString();
        Iterator itr = this._rshDialog.getPropertyKeys().iterator();
        while (itr.hasNext()) {
            props.remove(itr.next());
        }
        Object access = this._ui.getAccessMethodCombo().getSelectedItem();
        if (rootstr.isAccessExternal()) {
            props.putAll(this._rshDialog.getProperties());
        }
        if (access == null || access == CVSConnectAccessMethod.ACCESS_OTHER) {
            return;
        }
        CVSConnectRootObservable rootobs = (CVSConnectRootObservable)this._rootobs;
        CVSConnectNamePage.propagateCurrentRootToName(props, this._nameobs, rootobs, rootstr);
        if (rootobs.getRoot() == null || !rootobs.getRoot().equals(rootstr)) {
            rootobs.setRoot(rootstr);
            rootobs.notifyObservers(rootstr);
        }
        props.put(KEY_CONNECTION_ROOT, rootobs.getRoot().toString());
    }

    private CVSRootString createRootString() {
        CVSConnectRootObservable rootobs;
        boolean usePortColon;
        try {
            this._ui.getPortNumberSpinBox().commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Object access = this._ui.getAccessMethodCombo().getSelectedItem();
        String user = this._ui.getUserNameField().getText().trim();
        String server = this._ui.getServerLocationField().getText().trim();
        String port = Integer.toString((Integer)this._ui.getPortNumberSpinBox().getValue());
        String repos = this._ui.getRepositoryFileChooser().getPath().trim();
        server = this.validateServerLocation(server);
        if (!CVSConnectAccessMethod.requiresUserName(access)) {
            user = null;
        }
        if (!CVSConnectAccessMethod.requiresServerLocation(access)) {
            server = null;
        }
        if (!CVSConnectAccessMethod.requiresPort(access) || ((Number)this._ui.getPortNumberSpinBox().getValue()).intValue() == 2401) {
            port = null;
        }
        if (!CVSConnectAccessMethod.requiresRepository(access)) {
            repos = null;
        }
        this._method = this.createMethodSpec(access);
        if (CVSConnectConnectionPage.isUseProxySettingsEnabled(this._method)) {
            this._method = this._ui.getRshPanel().getUseProxySettingsCheckBox().isSelected() ? CVSConnectConnectionPage.addProxySettingsToMethod(this._method) : CVSConnectConnectionPage.removeProxySettingsFromMethod(this._method);
        }
        if (access == CVSConnectAccessMethod.ACCESS_LOCAL && repos != null) {
            repos = CVSUtil.removeTrailingFileSeparators(repos);
        }
        boolean bl = usePortColon = (rootobs = (CVSConnectRootObservable)this._rootobs).getRoot() != null && rootobs.getRoot().getUsePortColon();
        if (CVSActiveClient.isClientCVSNT()) {
            usePortColon = true;
        }
        return new CVSRootString(CVSRootSpecifier.createRootSpec(this._method, user, this._password, server, port, usePortColon, repos));
    }

    private CVSMethodSpecifier createMethodSpec(Object access) {
        LinkedHashMap<String, String> accessFieldMap;
        String method = CVSConnectRoot.getSupportedAccessMethodRoot(access);
        LinkedHashMap<String, String> linkedHashMap = accessFieldMap = this._method != null && this._method.getFieldMap() != null ? new LinkedHashMap<String, String>(this._method.getFieldMap()) : new LinkedHashMap<String, String>();
        if (access == CVSConnectAccessMethod.ACCESS_SSH2) {
            if (this._ui.getKeyCheckBox().isSelected() && !this._ui.getKeyFileChooser().isFieldEmpty()) {
                accessFieldMap.put("key", this._ui.getKeyFileChooser().getPath());
                return CVSMethodSpecifier.createMethodSpec(method, accessFieldMap, "#");
            }
            accessFieldMap.remove("key");
        }
        if (this._method == null || !method.equals(this._method.getMethod()) && access != CVSConnectAccessMethod.ACCESS_SSH2) {
            return CVSMethodSpecifier.createMethodSpec(method, null, null);
        }
        return CVSMethodSpecifier.createMethodSpec(method, accessFieldMap, this._method.getDelimiters());
    }

    static final CVSMethodSpecifier addProxySettingsToMethod(CVSMethodSpecifier method) {
        LinkedHashMap<String, String> accessFieldMap;
        ProxyOptions proxyOptions = (ProxyOptions)Ide.getSettings().getData("proxy-options");
        String settingsProxyHost = proxyOptions.getProxyHost();
        String settingsProxyPort = proxyOptions.getProxyPort();
        LinkedHashMap<String, String> linkedHashMap = accessFieldMap = method.getFieldMap() != null ? new LinkedHashMap<String, String>(method.getFieldMap()) : new LinkedHashMap();
        if (settingsProxyHost != null) {
            accessFieldMap.put(METHOD_FIELD_PROXY, settingsProxyHost);
            if (settingsProxyPort != null) {
                accessFieldMap.put(METHOD_FIELD_PROXY_PORT1, settingsProxyPort);
            }
        }
        return CVSMethodSpecifier.createMethodSpec(method.getMethod(), accessFieldMap, CVSActiveClient.isClientCVSNT() ? ";" : "#");
    }

    static final CVSMethodSpecifier removeProxySettingsFromMethod(CVSMethodSpecifier method) {
        ProxyOptions proxyOptions = ProxyOptions.getProxyOptions();
        String settingsProxyHost = proxyOptions.getProxyHost();
        String settingsProxyPort = proxyOptions.getProxyPort();
        LinkedHashMap accessFieldMap = method.getFieldMap() != null ? new LinkedHashMap(method.getFieldMap()) : new LinkedHashMap();
        String methodProxyHost = (String)accessFieldMap.get(METHOD_FIELD_PROXY);
        String methodProxyPort = (String)accessFieldMap.get(METHOD_FIELD_PROXY_PORT1);
        if (methodProxyHost != null && methodProxyHost.equals(settingsProxyHost)) {
            accessFieldMap.remove(METHOD_FIELD_PROXY);
            if (methodProxyPort != null && methodProxyPort.equals(settingsProxyPort)) {
                accessFieldMap.remove(METHOD_FIELD_PROXY_PORT1);
            }
        }
        return CVSMethodSpecifier.createMethodSpec(method.getMethod(), accessFieldMap, method.getDelimiters());
    }

    private final void updateEnabledState() {
        Object access = this._ui.getAccessMethodCombo().getSelectedItem();
        boolean requiresUserName = CVSConnectAccessMethod.requiresUserName(access);
        this._ui.getUserNameLabel().setEnabled(requiresUserName);
        this._ui.getUserNameField().setEnabled(requiresUserName);
        boolean requiresServerLocation = CVSConnectAccessMethod.requiresServerLocation(access);
        this._ui.getServerLocationLabel().setEnabled(requiresServerLocation);
        this._ui.getServerLocationField().setEnabled(requiresServerLocation);
        boolean requiresPort = CVSConnectAccessMethod.requiresPort(access);
        this._ui.getPortNumberLabel().setEnabled(requiresPort);
        this._ui.getPortNumberSpinBox().setEnabled(requiresPort);
        boolean requiresRepository = CVSConnectAccessMethod.requiresRepository(access);
        this._ui.getRepositoryLabel().setEnabled(requiresRepository);
        this._ui.getRepositoryFileChooser().setEnabled(requiresRepository);
        boolean accessIsLocal = access == CVSConnectAccessMethod.ACCESS_LOCAL || access == CVSConnectAccessMethod.ACCESS_FORK_AS_LOCAL;
        this._ui.getRepositoryFileChooser().setInsightEnabled(requiresRepository && accessIsLocal);
        this._ui.getRepositoryFileChooser().setBrowseEnabled(requiresRepository && accessIsLocal);
        this._ui.getRshPanel().getRshConfigButton().setEnabled(CVSConnectRoot.getSupportedAccessMethodRoot(access) == "ext");
        boolean accessIsSsh2 = access == CVSConnectAccessMethod.ACCESS_SSH2;
        this._ui.getKeyCheckBox().setEnabled(accessIsSsh2);
        this._ui.getKeyFileChooser().setEnabled(accessIsSsh2 && this._ui.getKeyCheckBox().isSelected());
        this._ui.getGenerateKeyPairButton().setEnabled(accessIsSsh2);
    }

    private final String validateServerLocation(String server) {
        int i;
        String value = server;
        int len = value.length();
        for (i = 0; i < len && value.charAt(i) == '.'; ++i) {
        }
        while (i < len && value.charAt(len - 1) == '.') {
            --len;
        }
        return i > 0 || len < value.length() ? value.substring(i, len) : value;
    }
}

