/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.util.log;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryProperty;
import oracle.jdeveloper.history.DefaultHistoryProperty;
import oracle.jdeveloper.history.HistoryFilter;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdeveloper.history.RestoreFromRevisionClass;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSRestoreFromRevisionClass;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.util.log.CVSLogReadWorker;

public final class CVSLogModel
extends HistoryProvider {
    static final int PROPERTY_DATE = 0;
    static final int PROPERTY_REVISION = 1;
    static final int PROPERTY_TAGS = 2;
    static final int PROPERTY_AUTHOR = 3;
    static final int PROPERTY_STATE = 4;
    static final int PROPERTY_LINES = 5;
    static final int PROPERTY_MESSAGE = 6;
    private static boolean _initialized;
    static final HistoryProperty[] PROPERTIES;
    private final HistoryFilter[] _predefinedFilters = new HistoryFilter[0];
    private CVSRestoreFromRevisionClass _restoreRevision = null;
    private HistoryFilter _typeFilter = new HistoryFilter(){

        public boolean accept(HistoryEntry entry) {
            return entry.getValue(PROPERTIES[3]) != null;
        }

        public String getShortLabel() {
            return CVSArb.get("LOG_FILTER_CVS_REVISIONS");
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeProperties() {
        Class<CVSLogModel> clazz = CVSLogModel.class;
        synchronized (CVSLogModel.class) {
            if (_initialized) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            _initialized = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            float dateWeight = SharedProperties.getDateProperty().getWeight();
            PROPERTIES[2].setWeight(dateWeight + 0.1f);
            PROPERTIES[3].setWeight(dateWeight + 0.2f);
            PROPERTIES[4].setWeight(dateWeight + 0.3f);
            PROPERTIES[5].setWeight(dateWeight + 0.4f);
            PROPERTIES[2].setDefault(false);
            PROPERTIES[4].setDefault(false);
            PROPERTIES[5].setDefault(false);
            PROPERTIES[3].setDefault(true);
            DefaultTableCellRenderer r = new DefaultTableCellRenderer();
            r.setText((String)SharedProperties.getDescriptionProperty().getPrototypeValue());
            SharedProperties.getDescriptionProperty().setAutoSizeMaximum(r.getPreferredSize().width);
            r.setText("start, release1, rel2");
            PROPERTIES[2].setAutoSizeMaximum(r.getPreferredSize().width);
            return;
        }
    }

    public HistoryProperty[] getProperties() {
        this.initializeProperties();
        return PROPERTIES;
    }

    public boolean isProviderFor(URL url) {
        if (!CVSClient.getInstance().isControlled(url)) {
            return false;
        }
        try {
            CVSClient.getInstance();
            return ((VCSStatus)CVSClient.getStatusCache().get(url)).isVersioned();
        }
        catch (Exception e) {
            return false;
        }
    }

    public HistoryEntry[] getEntries(URL url, HistoryFilter filter) {
        try {
            return new CVSLogReadWorker(url).getEntries();
        }
        catch (Exception e) {
            CVSClient.getInstance().getExceptionHandler().handleException(e);
            return new HistoryEntry[0];
        }
    }

    public CompareContributor getCompareContributor(HistoryEntry entry) {
        return null;
    }

    public HistoryFilter getTypeFilter() {
        return this._typeFilter;
    }

    public HistoryFilter[] getPredefinedFilters() {
        return this._predefinedFilters;
    }

    public RestoreFromRevisionClass getRestoreFromRevision() {
        if (this._restoreRevision == null) {
            this._restoreRevision = new CVSRestoreFromRevisionClass();
        }
        return this._restoreRevision;
    }

    static {
        PROPERTIES = new HistoryProperty[]{SharedProperties.getDateProperty(), SharedProperties.getRevisionProperty(), new DefaultHistoryProperty("TAGS", CVSArb.get("LOG_COLUMN_TAGS"), CVSArb.get("LOG_COLUMN_TAGS_DESC"), Collection.class, Arrays.asList("start", "release1", "rel2")), new DefaultHistoryProperty("AUTHOR", CVSArb.get("LOG_COLUMN_AUTHOR"), CVSArb.get("LOG_COLUMN_AUTHOR_DESC"), String.class, (Object)"sampleauthorname"), new DefaultHistoryProperty("STATE", CVSArb.get("LOG_COLUMN_STATE"), CVSArb.get("LOG_COLUMN_STATE_DESC"), String.class, (Object)"TODO"), new DefaultHistoryProperty("LINES", CVSArb.get("LOG_COLUMN_LINES"), CVSArb.get("LOG_COLUMN_LINES_DESC"), String.class, (Object)"+123 -431"), SharedProperties.getDescriptionProperty()};
    }
}

