/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.runner;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPasswordField;
import javax.swing.text.JTextComponent;
import oracle.ide.dialogs.SimpleInputDialog;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Log;
import oracle.jdeveloper.vcs.spi.VCSThreadPool;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSRootContext;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionData;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcess;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessListener;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessStreamMonitor;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerParameters;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerUtil;
import oracle.jdevimpl.vcs.util.RunnerOutputTask;
import oracle.jdevimpl.vcs.util.RunnerTimeoutTask;
import oracle.ocvs.OCVSMain;
import oracle.ocvs.OCVSProcessIO;
import oracle.ocvs.OCVSPrompter;
import oracle.ocvs.OCVSResponseRegistry;
import oracle.ocvs.OCVSRoot;
import oracle.ocvs.OCVSUsageException;

public class CVSInternalClientRunner
implements CVSRunner {
    private final CVSRunnerParameters _parameters = new CVSRunnerParameters();
    private String[] _cmdArray;
    private URL _dirUrl;
    private long _timeoutMillis;
    private boolean _isTimedOut;
    private Map<String, String> _envpMap;
    private final Collection _outMonitors = new ArrayList();
    private final Collection _errMonitors = new ArrayList();
    private CVSProcessListener _runProcessListener;
    private RunnerOutputTask _outTask;
    private RunnerOutputTask _errTask;
    private Thread _executionThread;
    private CVSProcess _runProcess;
    private ClientProcess _process;
    private Integer _exitCode;
    private OCVSPrompter _prompter;
    private boolean _encodeStandardOut;
    private String _charsetName;
    private VCSThreadPool _threadPool;
    private boolean _bufferOutputBinary;
    private static final Log LOG = new Log("vcs-cvs");

    public CVSInternalClientRunner() {
        CVSRunnerUtil.constructRunner(this);
        this._prompter = new Ssh2Prompter();
    }

    @Override
    public void setThreadPool_(VCSThreadPool threadPool) {
        this._threadPool = threadPool;
    }

    @Override
    public void setBufferOutputBinary_(boolean bufferOutputBinary) {
        this._bufferOutputBinary = bufferOutputBinary;
    }

    public void setPrompter(OCVSPrompter prompter) {
        this._prompter = prompter;
    }

    public void setEncodeStandardOut(boolean encodeStandardOut) {
        this._encodeStandardOut = encodeStandardOut;
    }

    public void setStandardOutEncoding(String charsetName) {
        this._charsetName = charsetName;
        this._encodeStandardOut = true;
    }

    @Override
    public CVSRunnerParameters getParameters() {
        return this._parameters;
    }

    @Override
    public void setCmdList_(Collection<String> cmdList) {
        this._cmdArray = cmdList.toArray(new String[0]);
    }

    @Override
    public void setCommand_(String command) {
        this._cmdArray = new String[]{command};
    }

    @Override
    public void setCmdArray_(String[] cmdArray) {
        this._cmdArray = cmdArray;
    }

    @Override
    public Collection<String> getCmdList_() {
        return Arrays.asList(this._cmdArray);
    }

    @Override
    public void setDirURL_(URL dirUrl) {
        this._dirUrl = dirUrl;
    }

    @Override
    public URL getDirURL_() {
        return this._dirUrl;
    }

    @Override
    public void setTimeout_(long timeoutMillis) {
        this._timeoutMillis = timeoutMillis;
    }

    @Override
    public long getTimeout_() {
        return this._timeoutMillis;
    }

    @Override
    public boolean isTimedOut_() {
        return this._isTimedOut;
    }

    @Override
    public void setEnvpMapInternal(Map<String, String> envpMap) {
        this._envpMap = envpMap;
    }

    @Override
    public void addOutputMonitor(CVSProcessStreamMonitor monitor) {
        this._outMonitors.add(monitor);
    }

    @Override
    public void addErrorMonitor(CVSProcessStreamMonitor monitor) {
        this._errMonitors.add(monitor);
    }

    @Override
    public void exec_() throws Exception {
        PrintStream out;
        this._exitCode = null;
        CVSRunnerUtil.preExecution(this);
        this._isTimedOut = false;
        this._process = new ClientProcess();
        this._runProcess = new CVSProcess(){

            @Override
            public Process getProcess() {
                return CVSInternalClientRunner.this._process;
            }

            @Override
            public void waitForRedirectOutput() {
            }

            @Override
            public void log(String message) {
                CVSInternalClientRunner.this._log(message);
            }
        };
        String charsetName = this._charsetName != null ? this._charsetName : this.determineExecutionContextEncoding();
        PrintStream err = new PrintStream(new PipedOutputStream((PipedInputStream)this._process.getErrorStream()));
        if (this._encodeStandardOut && charsetName != null) {
            LOG.trace("CVS: Encoding process standard out stream as " + charsetName);
            out = new PrintStream((OutputStream)new PipedOutputStream((PipedInputStream)this._process.getInputStream()), false, charsetName);
        } else {
            out = new PrintStream(new PipedOutputStream((PipedInputStream)this._process.getInputStream()));
        }
        OCVSProcessIO io = new OCVSProcessIO((InputStream)new PipedInputStream((PipedOutputStream)this._process.getOutputStream()), out, err);
        if (this._prompter != null) {
            io.setPrompter(this._prompter);
        }
        this._process.setIO(io);
        this._outTask = new OutputTask(this._runProcess, this._outMonitors, this._process.getInputStream());
        this._errTask = new OutputTask(this._runProcess, this._errMonitors, this._process.getErrorStream());
        if (this._bufferOutputBinary) {
            this._outTask.setBufferBytes(true);
        }
        RunnerTimeoutTask timeoutTask = null;
        if (this._timeoutMillis > 0L) {
            timeoutTask = new RunnerTimeoutTask((int)this._timeoutMillis){

                public final void doTimeout() {
                    CVSInternalClientRunner.this._doTimeout();
                }
            };
            this._outTask.setTimeoutTask(timeoutTask);
            this._errTask.setTimeoutTask(timeoutTask);
            if (this._prompter instanceof Ssh2Prompter) {
                ((Ssh2Prompter)this._prompter).setTimeoutTask(timeoutTask);
            }
        }
        String[] cmdArray = CVSRunnerUtil.addCommandParts(this, this._cmdArray, null);
        if (charsetName != null) {
            cmdArray = this.addNoConvertEOLOptionForCustomEncoding(cmdArray);
        }
        if (this._encodeStandardOut && charsetName != null) {
            cmdArray = this.addOutputEncodingOptionForCustomEncoding(cmdArray, charsetName);
        }
        CVSRunnerUtil.preExecSpi(this);
        HashMap<String, String> envpMap = this._envpMap != null ? new HashMap<String, String>(this._envpMap) : new HashMap();
        envpMap.put("CVS_SERVER", CVSClient.getInstance().getExecutablePath());
        Thread outThread = null;
        Thread errThread = null;
        try {
            if (this._threadPool != null) {
                this._threadPool.doTask((Runnable)this._outTask);
                this._threadPool.doTask((Runnable)this._errTask);
            } else {
                outThread = new Thread((Runnable)this._outTask, "CVSInternalClientRunner Stdout");
                errThread = new Thread((Runnable)this._errTask, "CVSInternalClientRunner Stderr");
                outThread.start();
                errThread.start();
            }
            if (timeoutTask != null) {
                if (this._threadPool != null) {
                    this._threadPool.doTask((Runnable)timeoutTask);
                } else {
                    new Thread((Runnable)timeoutTask, "CVSInternalClientRunner Timeout").start();
                }
            }
            this.logStartDirectory();
            this.logCommandString(cmdArray);
            this._executionThread = Thread.currentThread();
            this._exitCode = new Integer(OCVSMain.exec((OCVSProcessIO)io, (File)(this._dirUrl != null ? new File(URLFileSystem.getPlatformPathName((URL)this._dirUrl)) : null), (String[])OCVSMain.convertMapToEnvp(envpMap), (OCVSResponseRegistry)OCVSResponseRegistry.getInstance(), (String[])cmdArray));
            this._runProcessListener.processFinished(this._exitCode);
            CVSRunnerUtil.postExecution(this);
        }
        catch (OCVSUsageException ocvsue) {
            throw new CVSProcessException(CVSArb.format("ERROR_INTERNAL_CLIENT_USAGE", this.createCommandStringForLog(cmdArray)), ocvsue.getMessage());
        }
        finally {
            if (this._exitCode == null) {
                this._exitCode = new Integer(-1);
            }
            try {
                io._in.close();
            }
            catch (IOException ioe) {
                Assert.printStackTrace((Throwable)ioe);
            }
            io._out.close();
            if (io._out.checkError()) {
                this._outTask.setExitFlag();
            }
            io._err.close();
            if (io._err.checkError()) {
                this._errTask.setExitFlag();
            }
            try {
                if (this._threadPool != null) {
                    this._threadPool.join((Runnable)this._outTask);
                    this._threadPool.join((Runnable)this._errTask);
                } else {
                    outThread.join();
                    errThread.join();
                }
            }
            catch (InterruptedException ie) {
                Assert.printStackTrace((Throwable)ie);
            }
            this._process = null;
            this._runProcess = null;
            this._executionThread = null;
            CVSRunnerUtil.postExecutionFinal(this);
        }
    }

    @Override
    public CVSProcess getRunProcess() {
        return this._runProcess;
    }

    @Override
    public void setRunProcessListener(CVSProcessListener l) {
        this._runProcessListener = l;
    }

    @Override
    public Integer getExitCode_() {
        return this._exitCode;
    }

    @Override
    public String getOutputText_() {
        return this._outTask != null ? this._outTask.getOutput() : null;
    }

    @Override
    public String getErrorText_() {
        return CVSRunnerUtil.getErrorText(this, this._errTask != null ? this._errTask.getOutput() : null);
    }

    @Override
    public byte[] getOutputBytes_() {
        return this._outTask != null ? this._outTask.getOutputBytes() : null;
    }

    private String determineExecutionContextEncoding() {
        CVSRootContext rootContext = CVSRunnerUtil.getExecutionContext(this);
        if (rootContext == null) {
            return null;
        }
        CVSConnectionData connection = rootContext.getConnection();
        return connection != null ? connection.getEncoding() : null;
    }

    private String[] addNoConvertEOLOptionForCustomEncoding(String[] cmdArray) {
        String[] cmdArray0 = new String[cmdArray.length + 1];
        System.arraycopy(cmdArray, 0, cmdArray0, 1, cmdArray.length);
        cmdArray0[0] = "-E";
        return cmdArray0;
    }

    private String[] addOutputEncodingOptionForCustomEncoding(String[] cmdArray, String charsetName) {
        String[] cmdArray0 = new String[cmdArray.length + 2];
        System.arraycopy(cmdArray, 0, cmdArray0, 2, cmdArray.length);
        cmdArray0[0] = "-C";
        cmdArray0[1] = charsetName;
        return cmdArray0;
    }

    private void _doTimeout() {
        this._isTimedOut = true;
        this._outTask.setExitFlag();
        this._errTask.setExitFlag();
        ClientProcess process = this._process;
        if (process != null) {
            ((Process)process).destroy();
        }
    }

    private void _log(String message) {
        if (this._parameters.isQuiet()) {
            return;
        }
        CVSClient.getInstance().getLogWriter().printQuietly(message);
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        try {
            for (int sleepTimeMillis = 10; eventQueue.peekEvent() != null && sleepTimeMillis < 1000; sleepTimeMillis *= 2) {
                Thread.sleep(sleepTimeMillis);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void logStartDirectory() {
        this._log((this._dirUrl != null ? URLFileSystem.getPlatformPathName((URL)this._dirUrl) : "") + ">\n");
    }

    private void logCommandString(String[] cmdArray) {
        this._log(this.createCommandStringForLog(cmdArray) + '\n');
    }

    private String createCommandStringForLog(String[] cmdArray) {
        StringBuilder commandBuffer = new StringBuilder("$ <" + CVSArb.get("LOG_MESSAGE_INTERNAL_CVS") + ">");
        for (int i = 0; i < cmdArray.length; ++i) {
            if (commandBuffer.length() > 0) {
                commandBuffer.append(' ');
            }
            if (cmdArray[i].equals("") || cmdArray[i].indexOf(32) >= 0) {
                commandBuffer.append('\"');
                commandBuffer.append(cmdArray[i]);
                commandBuffer.append('\"');
                continue;
            }
            commandBuffer.append(cmdArray[i]);
        }
        return commandBuffer.toString();
    }

    private class ClientProcess
    extends Process {
        private final InputStream _errorStream = new PipedInputStream();
        private final InputStream _inputStream = new PipedInputStream();
        private final OutputStream _outputStream = new PipedOutputStream();
        private OCVSProcessIO _io;

        ClientProcess() {
        }

        void setIO(OCVSProcessIO io) {
            this._io = io;
        }

        @Override
        public void destroy() {
            Thread executionThread = CVSInternalClientRunner.this._executionThread;
            if (executionThread != null && this._io != null) {
                this._io.setCancelled(true);
            }
            if (executionThread != null) {
                CVSInternalClientRunner.this._executionThread.interrupt();
            }
        }

        @Override
        public int exitValue() {
            Integer exitCode = CVSInternalClientRunner.this._exitCode;
            if (exitCode == null) {
                throw new IllegalThreadStateException();
            }
            return exitCode;
        }

        @Override
        public InputStream getErrorStream() {
            return this._errorStream;
        }

        @Override
        public InputStream getInputStream() {
            return this._inputStream;
        }

        @Override
        public OutputStream getOutputStream() {
            return this._outputStream;
        }

        @Override
        public int waitFor() throws InterruptedException {
            Integer exitCode;
            while ((exitCode = CVSInternalClientRunner.this._exitCode) == null) {
                Thread.sleep(50L);
            }
            return exitCode;
        }
    }

    private class OutputTask
    extends RunnerOutputTask {
        private final CVSProcess _process;

        OutputTask(CVSProcess process, Collection monitors, InputStream in) {
            super(null, monitors, in);
            this._process = process;
        }

        protected void log(String message) {
            CVSInternalClientRunner.this._log(message);
        }

        protected void doLineUpdate(String s) throws Exception {
            Iterator itr = this.getMonitors().iterator();
            while (itr.hasNext()) {
                ((CVSProcessStreamMonitor)itr.next()).streamLine(s, this._process);
            }
        }

        protected void doPatternCheck(String s) throws Exception {
            for (CVSProcessStreamMonitor monitor : this.getMonitors()) {
                if (monitor.getPattern() == null || s.indexOf(monitor.getPattern()) < 0) continue;
                monitor.patternMatched(this._process);
            }
        }

        protected Integer getExitCode() {
            return CVSInternalClientRunner.this._exitCode;
        }

        protected void runExiting() {
            ClientProcess process = CVSInternalClientRunner.this._process;
            if (process != null) {
                ((Process)process).destroy();
            }
        }
    }

    public static class Ssh2Prompter
    extends OCVSPrompter {
        private RunnerTimeoutTask _timeoutTask;

        private void setTimeoutTask(RunnerTimeoutTask timeoutTask) {
            this._timeoutTask = timeoutTask;
        }

        public char[] promptPassword(OCVSRoot root, String message) {
            return null;
        }

        public boolean promptSsh2YesNo(String message) {
            try {
                this.suspendTimeoutTask();
                boolean bl = MessageDialog.confirm((Component)VCSWindowUtils.getCurrentWindow(), (Object)message, (String)CVSArb.get("SSH2_MESSAGE_TITLE"), null);
                return bl;
            }
            finally {
                this.resumeTimeoutTask();
            }
        }

        public char[] promptSsh2Passphrase(String message) {
            return this.promptSsh2PassphraseImpl(message, new SimplePasswordDialog(){

                protected boolean canOk() {
                    return true;
                }
            });
        }

        public char[] promptSsh2Password(String message) {
            return this.promptSsh2PassphraseImpl(message, new SimplePasswordDialog());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected char[] promptSsh2PassphraseImpl(String message, SimpleInputDialog inputDialog) {
            try {
                this.suspendTimeoutTask();
                char[] cArray = inputDialog.show(CVSArb.get("SSH2_MESSAGE_TITLE"), CVSArb.format("SSH2_PROMPT_TEMPLATE", message), null) ? inputDialog.getInputValue().toCharArray() : null;
                return cArray;
            }
            finally {
                this.resumeTimeoutTask();
            }
        }

        private void suspendTimeoutTask() {
            if (this._timeoutTask != null) {
                this._timeoutTask.suspend();
            }
        }

        private void resumeTimeoutTask() {
            if (this._timeoutTask != null) {
                this._timeoutTask.resume();
            }
        }

        private class SimplePasswordDialog
        extends SimpleInputDialog {
            private SimplePasswordDialog() {
            }

            protected JTextComponent createInputComponent() {
                return new JPasswordField("", 20);
            }
        }
    }
}

