/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.runner;

import java.net.URL;
import java.util.Collection;
import java.util.Map;
import oracle.ide.log.LogManager;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.RunProcessListener;
import oracle.ide.runner.SimpleProcess;
import oracle.jdeveloper.vcs.migrate.VCSShellRunner;
import oracle.jdeveloper.vcs.migrate.VCSStreamMonitor;
import oracle.jdeveloper.vcs.spi.VCSThreadPool;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcess;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessListener;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessStreamMonitor;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerParameters;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerUtil;

public class CVSExternalClientRunner
extends VCSShellRunner
implements CVSRunner {
    private final CVSRunnerParameters _parameters = new CVSRunnerParameters();
    private CVSProcess _runProcess;

    public CVSExternalClientRunner() {
        CVSRunnerUtil.constructRunner(this);
        this.getSimpleProcess().setAddToProcessesFolder(false);
        this.getSimpleProcess().setShowStartStatus(false);
    }

    @Override
    public CVSRunnerParameters getParameters() {
        return this._parameters;
    }

    @Override
    public void setEnvpMapInternal(Map<String, String> envpMap) {
        super.setEnvpMap(envpMap);
    }

    @Override
    public void addOutputMonitor(CVSProcessStreamMonitor monitor) {
        super.addOutputMonitor((VCSStreamMonitor)new StreamMonitorAdapter(monitor));
    }

    @Override
    public void addErrorMonitor(CVSProcessStreamMonitor monitor) {
        super.addErrorMonitor((VCSStreamMonitor)new StreamMonitorAdapter(monitor));
    }

    public void exec() throws Exception {
        boolean quiet = this._parameters.isQuiet();
        this.getSimpleProcess().setUseLogPage(!quiet);
        this.getSimpleProcess().setUseLogPageQuietly(true);
        this.getSimpleProcess().setLogPage(quiet ? null : LogManager.getLogManager().getMsgPage());
        this.getSimpleProcess().setAddToTerminateMenu(!quiet);
        CVSRunnerUtil.preExecution(this);
        try {
            super.execAndWait();
            CVSRunnerUtil.postExecution(this);
        }
        finally {
            this._runProcess = null;
            CVSRunnerUtil.postExecutionFinal(this);
        }
    }

    @Override
    public CVSProcess getRunProcess() {
        return this._runProcess;
    }

    @Override
    public void setRunProcessListener(CVSProcessListener l) {
        RunProcessListenerAdapter rpl = l != null ? new RunProcessListenerAdapter(l) : null;
        this.getSimpleProcess().setRunProcessListener((RunProcessListener)rpl);
    }

    public String getErrorText() {
        return CVSRunnerUtil.getErrorText(this, super.getErrorText());
    }

    protected String[] createCommandSpi(String[] cmdarray) {
        return CVSRunnerUtil.createCommandSpi(this, cmdarray);
    }

    protected void preExecSpi() throws Exception {
        CVSRunnerUtil.preExecSpi(this);
    }

    protected void setSimpleProcess(SimpleProcess simpleProcess) {
        super.setSimpleProcess(simpleProcess);
        this._runProcess = new RunProcessAdapter(simpleProcess.getRunProcess());
    }

    public int execAndWait() throws Exception {
        throw new UnsupportedOperationException();
    }

    public void setEnvpArray(String[] envp_array) {
        throw new UnsupportedOperationException();
    }

    public void setEnvpMap(Map envp_map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setThreadPool_(VCSThreadPool threadPool) {
        this.setThreadPool(threadPool);
    }

    @Override
    public void setBufferOutputBinary_(boolean bufferOutputBinary) {
        this.setBufferOutputBinary(bufferOutputBinary);
    }

    @Override
    public void setCmdList_(Collection<String> cmdList) {
        this.setCmdList(cmdList);
    }

    @Override
    public void setCommand_(String command) {
        this.setCommand(command);
    }

    @Override
    public void setCmdArray_(String[] cmdArray) {
        this.setCmdArray(cmdArray);
    }

    @Override
    public Collection<String> getCmdList_() {
        return this.getCmdList();
    }

    @Override
    public void setDirURL_(URL dirUrl) {
        this.setDirURL(dirUrl);
    }

    @Override
    public URL getDirURL_() {
        return this.getDirURL();
    }

    @Override
    public void setTimeout_(long timeoutMillis) {
        this.setTimeout(timeoutMillis);
    }

    @Override
    public long getTimeout_() {
        return this.getTimeout();
    }

    @Override
    public boolean isTimedOut_() {
        return this.isTimedOut();
    }

    @Override
    public void exec_() throws Exception {
        this.exec();
    }

    @Override
    public Integer getExitCode_() {
        return this.getExitCode();
    }

    @Override
    public String getOutputText_() {
        return this.getOutputText();
    }

    @Override
    public String getErrorText_() {
        return this.getErrorText();
    }

    @Override
    public byte[] getOutputBytes_() {
        return this.getOutputBytes();
    }

    private class RunProcessListenerAdapter
    implements RunProcessListener {
        private final CVSProcessListener _processListener;

        RunProcessListenerAdapter(CVSProcessListener processListener) {
            this._processListener = processListener;
        }

        public void processFinished(int exitCode) {
            this._processListener.processFinished(exitCode);
        }
    }

    private class RunProcessAdapter
    implements CVSProcess {
        private final RunProcess _process;

        RunProcessAdapter(RunProcess process) {
            this._process = process;
        }

        @Override
        public Process getProcess() {
            return this._process.getStarter().getProcess();
        }

        @Override
        public void waitForRedirectOutput() {
            this._process.waitForRedirectOutput();
        }

        @Override
        public void log(String message) {
            this._process.log((Object)message);
        }
    }

    private class StreamMonitorAdapter
    extends VCSStreamMonitor {
        private final CVSProcessStreamMonitor _monitor;

        StreamMonitorAdapter(CVSProcessStreamMonitor monitor) {
            this._monitor = monitor;
        }

        public String getPattern() {
            return this._monitor.getPattern();
        }

        protected void patternMatched(RunProcess process) throws Exception {
            this._monitor.patternMatched(CVSExternalClientRunner.this._runProcess);
        }

        protected void streamLine(String line, RunProcess process) throws Exception {
            this._monitor.streamLine(line, CVSExternalClientRunner.this._runProcess);
        }
    }
}

