/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.options.builder;

import java.awt.Component;
import java.awt.Insets;
import java.net.URL;
import java.util.Map;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagCategory;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagChooser;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagField2;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionArgument;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionBuilder;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionException;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionLayoutBuilder;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionResources;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionStructure;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

public class CVSCommonUseRevisionOrDateBuilder
extends CVSOptionBuilder {
    private CVSTagField2 _tagField;

    public CVSCommonUseRevisionOrDateBuilder() {
        super(CVSOptionId.COMMON_USE_REVISION_OR_DATE);
    }

    protected CVSCommonUseRevisionOrDateBuilder(CVSOptionId optionId) {
        super(optionId);
    }

    @Override
    public Object clone() {
        return new CVSCommonUseRevisionOrDateBuilder();
    }

    @Override
    public boolean isSingleBoolean() {
        return false;
    }

    @Override
    protected void populate(URL[] contextUrls, Map<String, String> contextProperties) {
        String cvsroot = contextProperties != null ? contextProperties.get("cvsroot") : null;
        String rcspath = contextProperties != null ? contextProperties.get("rcspath") : null;
        CVSTagChooser tagChooser = cvsroot != null && rcspath != null ? new CVSTagChooser(new CVSTagCategory[]{CVSTagCategory.HEAD, CVSTagCategory.BASE, CVSTagCategory.BRANCH, CVSTagCategory.VERSION, CVSTagCategory.DATE}, new CVSRootString(cvsroot), rcspath, CVSTagChooser.ViewMode.TREE) : new CVSTagChooser(new CVSTagCategory[]{CVSTagCategory.HEAD, CVSTagCategory.BASE, CVSTagCategory.BRANCH, CVSTagCategory.VERSION, CVSTagCategory.DATE}, contextUrls, CVSTagChooser.ViewMode.TREE);
        this._tagField.start(tagChooser);
    }

    @Override
    protected void dispose() {
        this._tagField.stop();
    }

    @Override
    protected void createComponents(CVSOptionResources resources) {
        super.createComponents(resources);
        this._tagField = new CVSTagField2();
    }

    @Override
    protected void attachListeners(CVSOptionStructure structure) {
        super.attachListeners(structure);
        this.attachSlaveComponent(this._tagField);
    }

    @Override
    protected void buildLayoutImpl(CVSOptionLayoutBuilder layoutBuilder, Insets i) {
        layoutBuilder.add(this._tagField, i, 1, false, false);
    }

    @Override
    protected void setValuesImpl(Map customizerOptions) {
        String revisionName = (String)customizerOptions.get((Object)CVSOptionArgument.REVISION_NAME);
        if (revisionName != null) {
            this._tagField.getTextField().setText(revisionName);
        }
    }

    @Override
    protected void validateValuesImpl() throws CVSOptionException {
        if (this._tagField.getNameOrTagValue() != null && CVSUtil.hasWhitespace(this._tagField.getNameOrTagValue())) {
            throw new CVSOptionException(CVSArb.get("ERROR_REVISION_NAME_WHITESPACE"));
        }
    }

    @Override
    protected void commitValuesImpl(Map customizerOptions) {
        if (this._tagField.getNameOrTagValue() != null) {
            customizerOptions.put(CVSOptionArgument.REVISION_NAME, this._tagField.getNameOrTagValue());
        }
        if (this._tagField.getDateValueISO8601() != null) {
            customizerOptions.put(CVSOptionArgument.REVISION_DATE, this._tagField.getDateValueISO8601());
        }
    }

    @Override
    public Component getFocusComponent() {
        return this.getBooleanState() ? this._tagField.getTextField() : super.getFocusComponent();
    }
}

