/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.spi.VCSCommandState;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizerAdapter;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSComponents;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagCategory;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagChooser;
import oracle.jdevimpl.vcs.cvs.op.CVSAbstractBranchOperation;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionException;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSMessageDialog;

public class CVSOperationSwitchBranch
extends CVSAbstractBranchOperation {
    public CVSOperationSwitchBranch() {
        super(CVSCommandConstants.OPERATION_SWITCH_BRANCH_CMD_ID);
    }

    protected CVSOperationSwitchBranch(int cmdId) {
        super(cmdId);
    }

    @Override
    protected int doitImpl2(Locatable[] locatables, URL[] urls, Collection nodes, Node[] affectedNodes, URL[] browserUrls) throws Exception {
        final OptionsCustomizerImpl customizer = new OptionsCustomizerImpl(browserUrls);
        final JEWTDialog dialog = this.createOperationDialog(nodes, (VCSOptionsCustomizer)customizer);
        dialog.setOKButtonEnabled(false);
        customizer.getBranchChooser().addBusyStateListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                CVSOperationSwitchBranch.this.updateDialogOKEnabled(dialog, customizer.getBranchChooser());
            }
        });
        customizer.getBranchChooser().addSelectionListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                CVSOperationSwitchBranch.this.updateDialogOKEnabled(dialog, customizer.getBranchChooser());
            }
        });
        this.addVetoableChangeListener(dialog, nodes, affectedNodes, (VCSOptionsCustomizer)customizer);
        dialog.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                customizer.getBranchChooser().start();
                dialog.removeComponentListener((ComponentListener)this);
            }
        });
        boolean dialogSuccessful = CVSDialogRunner.runDialog((JDialog)dialog);
        return !dialogSuccessful ? 1 : 0;
    }

    protected JEWTDialog createOperationDialog(Collection nodes, VCSOptionsCustomizer customizer) {
        return VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)CVSArb.get("SWITCH_BRANCH_CAPTION"), (String)CVSArb.get("SWITCH_BRANCH_LONG_PROMPT"), (Component)CVSComponents.createFileListerComponent(nodes), (Component)customizer.getComponent(), (String)"f1_cvsswitchrevision_html", (Component)customizer.getInitialFocusComponent());
    }

    @Override
    protected boolean doCommitOperationImpl(Component dialog, Map optionsMap, VCSCommandState state) throws Exception {
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        CVSAbstractBranchOperation.CreateBranchInvokable directoryInvokable = new CVSAbstractBranchOperation.CreateBranchInvokable(state.getInvokableState(), runner, CVSArb.get("ERROR_SWITCH_BRANCH_FAILED"));
        CVSAbstractBranchOperation.ChangesOutputMonitor changesOutputMonitor = new CVSAbstractBranchOperation.ChangesOutputMonitor();
        runner.addOutputMonitor(changesOutputMonitor);
        runner.getParameters().setQuiet(true);
        runner.setCmdArray_(new String[]{"-nq", "update", "-A"});
        if (!directoryInvokable.runInvokable()) {
            return false;
        }
        if (changesOutputMonitor.getChanges().length() > 0 && !CVSMessageDialog.confirm(dialog, CVSArb.get("CONFIRM_BRANCH_CLEAN_UPDATE"), CVSArb.get("CONFIRM_BRANCH_CLEAN_UPDATE_TITLE"), null, true)) {
            return false;
        }
        this.deleteEntriesDotArchive(state.getInvokableState().getURLs());
        runner.getParameters().setQuiet(false);
        state.getInvokableState().reset();
        directoryInvokable.setProgressMonitor(this.createProgressMonitor(dialog));
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("update");
        cmd.add("-Pd");
        if (optionsMap.containsKey((Object)OptionsCustomizerImpl.Option.BRANCH_NAME)) {
            cmd.add("-r");
            cmd.add((String)optionsMap.get((Object)OptionsCustomizerImpl.Option.BRANCH_NAME));
        } else {
            cmd.add("-D");
            cmd.add((String)optionsMap.get((Object)OptionsCustomizerImpl.Option.DATE));
        }
        cmd.add("-C");
        runner.setCmdList_(cmd);
        return directoryInvokable.runInvokable();
    }

    protected DeterminateProgressMonitor createProgressMonitor(Component parent) {
        return new DeterminateProgressMonitor(parent, CVSArb.get("SWITCH_BRANCH_PROGRESS_TITLE"), (Object)CVSArb.get("SWITCH_BRANCH_WATCHER_DESCRIPTION"), "", 0, -1);
    }

    private static class OptionsCustomizerImpl
    extends VCSOptionsCustomizerAdapter {
        private final CVSTagChooser _branchChooser;

        OptionsCustomizerImpl(URL[] urls) {
            this._branchChooser = new CVSTagChooser(new CVSTagCategory[]{CVSTagCategory.HEAD, CVSTagCategory.BRANCH, CVSTagCategory.VERSION, CVSTagCategory.BASE, CVSTagCategory.DATE}, urls, CVSTagChooser.ViewMode.TREE);
            JLabel branchLabel = new JLabel();
            LayoutBuilder layoutBuilder = new LayoutBuilder();
            Insets insets = new Insets(2, 2, 2, 2);
            layoutBuilder.add((Component)branchLabel, insets, 1, false, true);
            layoutBuilder.nl();
            layoutBuilder.add(this._branchChooser.getGUI(), insets, 1, false, true);
            layoutBuilder.nl();
            JPanel panel = new JPanel();
            layoutBuilder.addToPanel((Container)panel);
            ResourceUtils.resLabel((JLabel)branchLabel, (Component)this._branchChooser.getInitialFocusComponent(), (String)CVSArb.get("BRANCH_VERSION_OR_DATE"));
            this._component = panel;
        }

        public Component getComponent() {
            return this._component;
        }

        public void setOptions(Map options) {
        }

        public Map getOptions() {
            HashMap<Option, String> options = new HashMap<Option, String>();
            if (this._branchChooser.getTagValue() != null) {
                options.put(Option.BRANCH_NAME, this._branchChooser.getTagValue());
            }
            if (this._branchChooser.getDateValueISO8601() != null) {
                options.put(Option.DATE, this._branchChooser.getDateValueISO8601());
            }
            return options;
        }

        public void validateOptions() throws VCSException {
            if (this._branchChooser.getTagValue() == null && this._branchChooser.getDateValueISO8601() == null) {
                throw new CVSOptionException(CVSArb.get("NO_TAG_BRANCH_OR_DATE"));
            }
        }

        CVSTagChooser getBranchChooser() {
            return this._branchChooser;
        }

        public Component getInitialFocusComponent() {
            return this._branchChooser.getInitialFocusComponent();
        }

        static enum Option {
            BRANCH_NAME,
            DATE;

        }
    }
}

