/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.spi.VCSCommandState;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizerAdapter;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSComponents;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagCategory;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagChooser;
import oracle.jdevimpl.vcs.cvs.op.CVSAbstractBranchOperation;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionException;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSMessageDialog;

public class CVSOperationCreateBranch
extends CVSAbstractBranchOperation {
    public CVSOperationCreateBranch() {
        super(CVSCommandConstants.OPERATION_CREATE_BRANCH_CMD_ID);
    }

    @Override
    protected int doitImpl2(Locatable[] locatables, URL[] urls, Collection nodes, Node[] affectedNodes, URL[] browserUrls) throws Exception {
        final OptionsCustomizerImpl customizer = new OptionsCustomizerImpl();
        final CVSTagChooser branchChooser = new CVSTagChooser(new CVSTagCategory[]{CVSTagCategory.BRANCH}, browserUrls, CVSTagChooser.ViewMode.LIST);
        Box detail = Box.createVerticalBox();
        JLabel existingBranchesLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)existingBranchesLabel, (Component)branchChooser.getInitialFocusComponent(), (String)CVSArb.get("EXISTING_BRANCHES"));
        detail.add(existingBranchesLabel);
        detail.add(Box.createVerticalStrut(4));
        detail.add(branchChooser.getGUI());
        final JEWTDialog dialog = VCSComponents.createOperationDetailDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)CVSArb.get("CREATE_BRANCH_CAPTION"), (String)CVSArb.get("CREATE_BRANCH_LONG_PROMPT"), (Component)CVSComponents.createFileListerComponent(nodes), (Component)customizer.getComponent(), (String)"f1_cvsbranch_html", (Component)customizer.getInitialFocusComponent(), (Component)detail);
        dialog.setOKButtonEnabled(false);
        DocumentAdapter documentListener = new DocumentAdapter(){

            @Override
            protected void update(DocumentEvent de) {
                CVSOperationCreateBranch.this.updateDialogOKEnabled(dialog, customizer);
            }
        };
        customizer.getBranchNameTextField().getDocument().addDocumentListener(documentListener);
        customizer.getBaseTagNameTextField().getDocument().addDocumentListener(documentListener);
        this.addVetoableChangeListener(dialog, nodes, affectedNodes, (VCSOptionsCustomizer)customizer);
        dialog.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                branchChooser.start();
                dialog.removeComponentListener((ComponentListener)this);
            }
        });
        boolean dialogSuccessful = CVSDialogRunner.runDialog((JDialog)dialog);
        return !dialogSuccessful ? 1 : 0;
    }

    private void updateDialogOKEnabled(JEWTDialog dialog, OptionsCustomizerImpl customizer) {
        dialog.setOKButtonEnabled(!customizer.getBranchNameTextField().getText().equals("") && !customizer.getBaseTagNameTextField().getText().equals(""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doCommitOperationImpl(Component dialog, Map optionsMap, VCSCommandState state) throws Exception {
        try (DeterminateProgressMonitor progressMonitor = new DeterminateProgressMonitor(dialog, CVSArb.get("CREATE_BRANCH_PROGRESS_TITLE"));){
            CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
            CVSAbstractBranchOperation.CreateBranchInvokable directoryInvokable = new CVSAbstractBranchOperation.CreateBranchInvokable(state.getInvokableState(), runner, CVSArb.get("ERROR_CREATE_BRANCH_FAILED"));
            Boolean fromTrunk = (Boolean)optionsMap.get((Object)OptionsCustomizerImpl.Option.FROM_TRUNK);
            progressMonitor.setMaximum(fromTrunk != false ? 5 : 4);
            progressMonitor.setMillisToDecideToPopup(0);
            progressMonitor.setMillisToPopup(0);
            progressMonitor.setMinimum(0);
            progressMonitor.setCancellable(false);
            progressMonitor.setProgress(0);
            if (fromTrunk.booleanValue()) {
                CVSAbstractBranchOperation.ChangesOutputMonitor changesOutputMonitor = new CVSAbstractBranchOperation.ChangesOutputMonitor();
                runner.addOutputMonitor(changesOutputMonitor);
                runner.getParameters().setQuiet(true);
                runner.setCmdArray_(new String[]{"-nq", "update", "-A"});
                if (!directoryInvokable.runInvokable()) {
                    boolean bl = false;
                    return bl;
                }
                if (changesOutputMonitor.getChanges().length() > 0 && !CVSMessageDialog.confirm(dialog, CVSArb.get("CONFIRM_BRANCH_CLEAN_UPDATE"), CVSArb.get("CONFIRM_BRANCH_CLEAN_UPDATE_TITLE"), null, true)) {
                    boolean bl = false;
                    return bl;
                }
                this.deleteEntriesDotArchive(state.getInvokableState().getURLs());
                runner.getParameters().setQuiet(false);
                progressMonitor.getPanel().setMessage(CVSArb.get("PROGRESS_ANALYZING_TRUNK"));
                progressMonitor.incProgress();
                state.getInvokableState().reset();
                runner.setCmdArray_(new String[]{"update", "-AC"});
                if (!directoryInvokable.runInvokable()) {
                    boolean bl = false;
                    return bl;
                }
            } else {
                this.deleteEntriesDotArchive(state.getInvokableState().getURLs());
            }
            String baseTagName = (String)optionsMap.get((Object)OptionsCustomizerImpl.Option.BASE_TAG_NAME);
            progressMonitor.getPanel().setMessage(CVSArb.format("PROGRESS_CREATING_BASE_TAG", baseTagName));
            progressMonitor.incProgress();
            state.getInvokableState().reset();
            runner.setCmdArray_(new String[]{"tag", baseTagName});
            if (!directoryInvokable.runInvokable()) {
                boolean bl = false;
                return bl;
            }
            String branchName = (String)optionsMap.get((Object)OptionsCustomizerImpl.Option.BRANCH_NAME);
            progressMonitor.getPanel().setMessage(CVSArb.format("PROGRESS_CREATING_BRANCH", branchName));
            progressMonitor.incProgress();
            state.getInvokableState().reset();
            runner.setCmdArray_(new String[]{"tag", "-r", baseTagName, "-b", branchName});
            if (!directoryInvokable.runInvokable()) {
                boolean bl = false;
                return bl;
            }
            progressMonitor.getPanel().setMessage(CVSArb.get("PROGRESS_JOINING_BRANCH"));
            progressMonitor.incProgress();
            state.getInvokableState().reset();
            runner.setCmdArray_(new String[]{"update", "-r", branchName});
            if (!directoryInvokable.runInvokable()) {
                boolean bl = false;
                return bl;
            }
            progressMonitor.incProgress();
            boolean bl = true;
            return bl;
        }
    }

    private static class OptionsCustomizerImpl
    extends VCSOptionsCustomizerAdapter {
        private final JTextField _branchNameTextField = new JTextField();
        private final JTextField _baseTagNameTextField = new JTextField();
        private final JRadioButton _trunkRadioButton = new JRadioButton();
        private final JRadioButton _workingCopyRadioButton = new JRadioButton();

        private OptionsCustomizerImpl() {
            JLabel branchNameLabel = new JLabel();
            JLabel baseTagNameLabel = new JLabel();
            JLabel sourceLabel = new JLabel();
            LayoutBuilder layoutBuilder = new LayoutBuilder();
            Insets insets = new Insets(2, 2, 2, 2);
            layoutBuilder.add((Component)branchNameLabel, insets, 2, false, true);
            layoutBuilder.nl();
            layoutBuilder.add((Component)this._branchNameTextField, insets, 2, false, true);
            layoutBuilder.nl();
            layoutBuilder.add((Component)baseTagNameLabel, insets, 2, false, true);
            layoutBuilder.nl();
            layoutBuilder.add((Component)this._baseTagNameTextField, insets, 2, false, true);
            layoutBuilder.nl();
            layoutBuilder.add((Component)sourceLabel, insets, 2, false, true);
            layoutBuilder.nl();
            layoutBuilder.addHGap();
            layoutBuilder.add((Component)this._trunkRadioButton, insets, 1, false, true);
            layoutBuilder.nl();
            layoutBuilder.addHGap();
            layoutBuilder.add((Component)this._workingCopyRadioButton, insets, 1, false, true);
            layoutBuilder.nl();
            JPanel panel = new JPanel();
            layoutBuilder.addToPanel((Container)panel);
            ResourceUtils.resLabel((JLabel)branchNameLabel, (Component)this._branchNameTextField, (String)CVSArb.get("BRANCH_NAME"));
            ResourceUtils.resLabel((JLabel)baseTagNameLabel, (Component)this._baseTagNameTextField, (String)CVSArb.get("BASE_TAG_NAME"));
            ResourceUtils.resLabel((JLabel)sourceLabel, (Component)sourceLabel, (String)CVSArb.get("BRANCH_SOURCE"));
            ResourceUtils.resButton((AbstractButton)this._trunkRadioButton, (String)CVSArb.get("TRUNK"));
            ResourceUtils.resButton((AbstractButton)this._workingCopyRadioButton, (String)CVSArb.get("REVISIONS_IN_WORKING_COPY"));
            ButtonGroup bg = new ButtonGroup();
            bg.add(this._trunkRadioButton);
            bg.add(this._workingCopyRadioButton);
            this._trunkRadioButton.setSelected(true);
            this._branchNameTextField.getDocument().addDocumentListener(new DocumentAdapter(){

                @Override
                protected void update(DocumentEvent de) {
                    String s = _branchNameTextField.getText();
                    _baseTagNameTextField.setText(!s.equals("") ? s + "_BASE" : "");
                }
            });
            this._component = panel;
        }

        JTextField getBranchNameTextField() {
            return this._branchNameTextField;
        }

        JTextField getBaseTagNameTextField() {
            return this._baseTagNameTextField;
        }

        public Component getComponent() {
            return this._component;
        }

        public void setOptions(Map options) {
            this._branchNameTextField.setText(options.containsKey((Object)Option.BRANCH_NAME) ? (String)options.get((Object)Option.BRANCH_NAME) : "");
            this._baseTagNameTextField.setText(options.containsKey((Object)Option.BASE_TAG_NAME) ? (String)options.get((Object)Option.BASE_TAG_NAME) : "");
            boolean fromTrunk = options.containsKey((Object)Option.FROM_TRUNK) && (Boolean)options.get((Object)Option.FROM_TRUNK) != false;
            this._trunkRadioButton.setSelected(fromTrunk);
            this._workingCopyRadioButton.setSelected(!fromTrunk);
        }

        public Map getOptions() {
            HashMap<Option, Object> options = new HashMap<Option, Object>();
            options.put(Option.BRANCH_NAME, this._branchNameTextField.getText().trim());
            options.put(Option.BASE_TAG_NAME, this._baseTagNameTextField.getText().trim());
            options.put(Option.FROM_TRUNK, this._trunkRadioButton.isSelected());
            return options;
        }

        public void validateOptions() throws VCSException {
            this.validate(StringUtils.stripMnemonic((String)CVSArb.get("BRANCH_NAME")), this._branchNameTextField.getText());
            this.validate(StringUtils.stripMnemonic((String)CVSArb.get("BASE_TAG_NAME")), this._baseTagNameTextField.getText());
            if (this._branchNameTextField.getText().equals(this._baseTagNameTextField.getText())) {
                throw new CVSOptionException(CVSArb.format("TAG_NAME_SAME_AS_BRANCH", StringUtils.stripMnemonic((String)CVSArb.get("BASE_TAG_NAME"))));
            }
        }

        private void validate(String localName, String s) throws VCSException {
            if (s.equals("")) {
                throw new CVSOptionException(CVSArb.format("BRANCH_NAME_NAME_EMPTY", localName));
            }
            if (!s.matches("^\\p{Alpha}.*")) {
                throw new CVSOptionException(CVSArb.format("BRANCH_NAME_STARTS_WITH_LETTER", localName));
            }
            if (s.replaceAll("[ \\t$,\\.:;@|]", "").length() < s.length()) {
                throw new CVSOptionException(CVSArb.format("BRANCH_NAME_ILLEGAL_CHARACTERS", localName));
            }
        }

        public Component getInitialFocusComponent() {
            return this._branchNameTextField;
        }

        static enum Option {
            BRANCH_NAME,
            BASE_TAG_NAME,
            FROM_TRUNK;

        }
    }

    private static abstract class DocumentAdapter
    implements DocumentListener {
        private DocumentAdapter() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }

        protected abstract void update(DocumentEvent var1);
    }
}

