/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.op;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.ProductInformation;
import oracle.ide.config.Preferences;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessageUtil;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.changeset.ChangeSetManager;
import oracle.jdeveloper.vcs.spi.VCSCommandState;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSDialogCommitter;
import oracle.jdeveloper.vcs.spi.VCSDirectoryInvokableState;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.spi.VCSValidationException;
import oracle.jdeveloper.vcs.spi.VCSWaitRunnable;
import oracle.jdeveloper.vcs.util.VCSBufferUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSNavigableUtils;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdeveloper.vcs.vop.DisplayProperty;
import oracle.jdeveloper.vcs.vop.MutableVersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationPanel;
import oracle.jdevimpl.vcs.cvs.CVSAbstractCommand;
import oracle.jdevimpl.vcs.cvs.CVSChangeListWindow;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSCommandOptionsPrefs;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSFileSystemAPI;
import oracle.jdevimpl.vcs.cvs.CVSIgnorePatternList;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.error.CVSOperationException;
import oracle.jdevimpl.vcs.cvs.error.CVSProcessException;
import oracle.jdevimpl.vcs.cvs.op.CVSOperationAdd;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionArgument;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionCategory;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionDirector;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionId;
import oracle.jdevimpl.vcs.cvs.options.CVSOptionsCustomizer;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;
import oracle.jdevimpl.vcs.cvs.util.CVSDialogRunner;
import oracle.jdevimpl.vcs.cvs.util.CVSDirectoryInvokable;
import oracle.jdevimpl.vcs.cvs.util.CVSListFilesUtil;
import oracle.jdevimpl.vcs.vop.ClientDisplayProperty;

public class CVSOperationCommit
extends CVSAbstractCommand {
    private static final String PREFIX_TEMP_COMMENTS = ".jdevcvs_cmt";
    private static final String SKIP_AUTO_ADD_FILES_PERSISTENCE_KEY = "CVS.AutoAddFilesOnCommitConfirm";

    public CVSOperationCommit() {
        super(CVSCommandConstants.OPERATION_COMMIT_CMD_ID, VCSCommandStyle.MULTI);
    }

    protected CVSOperationCommit(int cmdId) {
        super(cmdId, VCSCommandStyle.MULTI);
    }

    protected Locatable[] getLocatablesToCommit() throws Exception {
        return this.getContextLocatables();
    }

    protected boolean isOpenSessionCommitSelection(Locatable[] locatables) {
        return super.isOpenSessionSelection(locatables);
    }

    protected VCSStatusFilter getStatusFilter() {
        return this.createStatusFilter(new VCSStatus[]{CVSFileStatus.STATUS_CONFLICTS, CVSFileStatus.STATUS_LOCALLY_CHANGED, CVSFileStatus.STATUS_ADDED, CVSFileStatus.STATUS_REMOVED, CVSFileStatus.STATUS_SANDBOX});
    }

    protected boolean isAvailableImpl() throws Exception {
        Locatable[] locatables = this.getLocatablesToCommit();
        if (!this.isOpenSessionCommitSelection(locatables)) {
            return false;
        }
        return this.isAvailableImpl(locatables);
    }

    protected boolean isAvailableImpl(Locatable locatable) throws Exception {
        if (!super.isAvailableImpl(locatable)) {
            return false;
        }
        return this.isAvailableImpl(locatable, locatable.getURL());
    }

    protected boolean isAvailableImpl(URL url) throws Exception {
        return true;
    }

    private boolean isAvailableImpl(Locatable locatable, URL url) throws Exception {
        VCSStatus status = (VCSStatus)this.getStatusCacheBridge().get(url);
        if (status != CVSFileStatus.STATUS_REMOVED && !URLFileSystem.exists((URL)url)) {
            return false;
        }
        if (locatable instanceof Node && status.isVersioned() && ((Node)locatable).isDirty()) {
            return true;
        }
        return this.getStatusFilter().accept(status);
    }

    protected int doitImpl() throws Exception {
        final Locatable[] locatables = this.getLocatablesToCommit();
        final Node[] affectedNodes = CVSUtil.getCachedBaseURLNodes(VCSModelUtils.convertNodesToURLs((Locatable[])locatables));
        if (!CVSUtil.saveDirtyNodes(Arrays.asList(affectedNodes))) {
            return 1;
        }
        Runnable callback = new Runnable(){

            @Override
            public void run() {
                try {
                    CVSOperationCommit.this._doitImpl(locatables, affectedNodes);
                }
                catch (Exception e) {
                    CVSOperationCommit.this.getExceptionHandler().handleException(e);
                }
            }
        };
        return this.autoAddFilesOnCommit(VCSModelUtils.convertNodesToURLs((Locatable[])locatables), callback);
    }

    private int _doitImpl(Locatable[] locatables, Node[] affectedNodes) throws Exception {
        Collection nodesPreCoalesce = this.getFilteredSelection(locatables);
        Collection nodes = this.coalesceNodesForCommit(nodesPreCoalesce);
        if (nodes.size() <= 0) {
            this.noOp();
            return 9;
        }
        Map timestampMap = VCSBufferUtils.storeTimestamps(Arrays.asList(affectedNodes));
        VCSDirectoryInvokableState invokableState = new VCSDirectoryInvokableState(VCSModelUtils.convertNodesToURLs((Collection)nodes));
        VCSCommandState state = new VCSCommandState(invokableState, timestampMap);
        if (this.getContext().getView() instanceof CVSChangeListWindow && (this.isActionLocal() && !((CVSChangeListWindow)this.getContext().getView()).isUsingCommitDialog() || this.getContext().getBoolean("CVSClient.localActionSource"))) {
            this.getContext().setBoolean("CVSClient.localActionSource", true);
            VCSOptionsCustomizer customizer = CVSClient.getInstance().getChangeListOptionsCustomizer();
            return this.commitSilently(nodes, affectedNodes, state, customizer);
        }
        CVSOptionsCustomizer dynamicCustomizer = this.createOptionsCustomizer(nodes.toArray(new Locatable[0]));
        VCSCommentsCustomizer customizer = new VCSCommentsCustomizer("oracle.jdeveloper.cvs", (VCSOptionsCustomizer)dynamicCustomizer);
        return this.commit(nodes, affectedNodes, state, (VCSOptionsCustomizer)customizer, dynamicCustomizer);
    }

    protected Collection coalesceNodesForCommit(Collection nodes) {
        return this.coalesceNodesForFolderOperation(nodes);
    }

    protected void noOpImpl() throws VCSValidationException {
        throw new VCSValidationException(CVSArb.get("ERROR_COMMIT_FILTERED_TITLE"), CVSArb.format("ERROR_COMMIT_FILTERED", ProductInformation.getProductInformation().getShortName()));
    }

    private int commitSilently(Collection nodes, final Node[] affectedNodes, final VCSCommandState state, VCSOptionsCustomizer customizer) {
        VCSWaitRunnable r = new VCSWaitRunnable(this.getExceptionHandler(), customizer){

            protected final void runImpl() throws Exception {
                CVSOperationCommit.this.doCommitOperationImpl((Component)Ide.getMainWindow(), this.getOptions(), state);
            }

            protected final void runPostOperationAWT() throws Exception {
                CVSOperationCommit.this.postCommit(state, affectedNodes);
            }
        };
        Thread t = new Thread((Runnable)r, "CVSOperationCommit");
        t.start();
        return 0;
    }

    private int commit(Collection nodes, Node[] affectedNodes, final VCSCommandState state, VCSOptionsCustomizer customizer, CVSOptionsCustomizer dynamicCustomizer) throws Exception {
        Map options;
        String comments;
        VCSCommentsCustomizer commentsCustomizer = (VCSCommentsCustomizer)customizer;
        commentsCustomizer.setRecentCommentsModel(CVSClient.getInstance().getRecentCommentsModel());
        commentsCustomizer.setShowTemplatesAndCommentsCombo(true);
        commentsCustomizer.setSystemTemplate(CVSUtil.readCommentsTemplate(nodes));
        commentsCustomizer.setTemplatesSettingsPath(VCSNavigableUtils.getSystemNavigablePath((String)CVSArb.get("CVS_SHORT_NAME"), (String[])new String[]{VCSCommentsCustomizer.COMMENT_TEMPLATES_NAVIGABLE_LABEL}));
        commentsCustomizer.setContextURLs(VCSModelUtils.convertNodesToURLs((Collection)nodes));
        if (this.getContext().getView() instanceof CVSChangeListWindow && this.isActionLocal() && (comments = (String)(options = CVSClient.getInstance().getChangeListOptionsCustomizer().getOptions()).get("setting_comments")) != null && !comments.equals("")) {
            customizer.setOptions(options);
        }
        final JEWTDialog dialog = VCSComponents.createOperationDialog((Component)VCSWindowUtils.getCurrentWindow(), (String)CVSArb.get("COMMIT_CAPTION"), (String)CVSArb.get("COMMIT_LONG_PROMPT"), (Component)this.createFileListerComponent(nodes), (Component)customizer.getComponent(), (String)"f1_cvscommit_html", (Component)customizer.getInitialFocusComponent());
        dialog.addVetoableChangeListener((VetoableChangeListener)new VCSDialogCommitter(customizer){

            protected final boolean doCommitOperation(Map options) throws Exception {
                return CVSOperationCommit.this.doCommitOperationImpl((Component)dialog, options, state);
            }
        });
        boolean dialogSuccessful = CVSDialogRunner.runDialog((JDialog)dialog);
        if (dynamicCustomizer != null) {
            dynamicCustomizer.dispose();
        }
        this.postCommit(state, affectedNodes);
        return !dialogSuccessful ? 1 : 0;
    }

    private void postCommit(VCSCommandState state, Node[] affectedNodes) throws Exception {
        Collection processedUrls = state.getInvokableState().getProcessedURLs();
        URL[] processedUrlArray = processedUrls.toArray(new URL[0]);
        this.fireFileStructureChanged(processedUrlArray);
        CVSClient.getInstance();
        CVSClient.getStatusCache().clear(processedUrlArray, Depth.INFINITY);
        if (processedUrls.size() > 0) {
            VCSBufferUtils.reloadBuffers((Map)state.getTimestampMap());
        }
        this.fireSomeFilesDeleted(processedUrlArray);
        ChangeSetManager.getChangeSetManager().fireChangesCommitted("oracle.jdeveloper.cvs", processedUrlArray, true);
    }

    private CVSOptionsCustomizer createOptionsCustomizer(Locatable[] contextLocatables) {
        CVSOptionDirector optionDirector = new CVSOptionDirector(contextLocatables);
        optionDirector.registerCategoryOptions(CVSOptionCategory.BASIC, new CVSOptionId[]{CVSOptionId.COMMIT_FORCE_COMMIT, CVSOptionId.COMMON_LOCAL_FOLDER_ONLY});
        optionDirector.registerCategoryOptions(CVSOptionCategory.ADVANCED, new CVSOptionId[]{CVSOptionId.COMMON_USE_REVISION, CVSOptionId.COMMON_NO_MODULE_PROGRAMS});
        if (!CVSClient.getInstance().isAdvancedModeSet()) {
            optionDirector.deregisterCategoryOptions(CVSOptionCategory.ADVANCED);
        }
        CVSOptionsCustomizer optionsCustomizer = new CVSOptionsCustomizer(optionDirector.constructOptionComponents());
        HashMap defaultOptionsValues = new HashMap();
        optionsCustomizer.setDefaultOptionValues(defaultOptionsValues);
        optionsCustomizer.disableUnsupportedComponents("commit", CVSOptionId.COMMIT_FORCE_COMMIT);
        return optionsCustomizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCommitOperationImpl(Component dialog, Map optionsMap, VCSCommandState state) throws Exception {
        if (optionsMap != null) {
            optionsMap = new HashMap(optionsMap);
        }
        DeterminateProgressMonitor monitor = new DeterminateProgressMonitor(dialog, CVSArb.get("COMMIT_PROGRESS_TITLE"), (Object)CVSArb.get("COMMIT_WATCHER_DESCRIPTION"), "", 0, -1);
        String s = (String)optionsMap.get("setting_comments");
        if (s == null || s.equals("")) {
            s = CVSArb.get("COMMIT_NO_COMMENTS_TEXT");
        }
        URL commentFile = URLFactory.newFileURL((File)File.createTempFile(PREFIX_TEMP_COMMENTS, null));
        CVSUtil.writeFileBytes(commentFile, s.getBytes("UTF-8"));
        ArrayList<String> opts = new ArrayList<String>();
        opts.add("-F");
        opts.add(URLFileSystem.getPlatformPathName((URL)commentFile));
        final CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.setCommand_("commit");
        runner.getParameters().setQuiet(false);
        if (optionsMap != null) {
            optionsMap.keySet().retainAll(Arrays.asList(new Object[]{CVSOptionId.COMMIT_FORCE_COMMIT, CVSOptionId.COMMON_USE_REVISION, CVSOptionId.COMMON_LOCAL_FOLDER_ONLY, CVSOptionId.COMMON_NO_MODULE_PROGRAMS, CVSOptionArgument.REVISION_NAME}));
            runner.getParameters().setBuilderOptions(optionsMap);
        }
        runner.getParameters().setOptions(opts);
        state.setInvokableState(this.coalesceStateForFolderOperation(optionsMap, state.getInvokableState()));
        CVSDirectoryInvokable invokable = new CVSDirectoryInvokable(state.getInvokableState()){

            @Override
            protected final boolean doInvocation2(URL parent, URL[] invokeUrls) throws Exception {
                String[] filenames = VCSFileSystemUtils.getURLFileNames((URL[])invokeUrls);
                runner.setDirURL_(parent);
                runner.getParameters().setFiles(Arrays.asList(filenames));
                CVSOperationCommit.this.doInvocationImpl(runner);
                return true;
            }
        };
        invokable.setProgressMonitor(monitor);
        try {
            Object object = CVSChangeListWindow.getIncomingChangesMutexLock();
            synchronized (object) {
                block16: {
                    if (invokable.runInvokable()) break block16;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        catch (UpToDateCheckFailedException utdcfe) {
            if (EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CVSOperationCommit.this.upToDateCheckFailed();
                    }
                });
            } else {
                final Thread commitThread = Thread.currentThread();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            commitThread.join();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CVSOperationCommit.this.upToDateCheckFailed();
                            }
                        });
                    }
                };
                Thread t = new Thread(r, "CVSOperationCommit UpToDateCheck");
                t.start();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (commentFile != null) {
                URLFileSystem.delete((URL)commentFile);
            }
        }
        return true;
    }

    private void upToDateCheckFailed() {
        if (!MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)CVSArb.get("UP_TO_DATE_CHECK_FAILED"), (String)CVSArb.get("UP_TO_DATE_CHECK_FAILED_TITLE"), null)) {
            return;
        }
        try {
            this.getContext().setBoolean("CVSClient.updateFromCommit", true);
            IdeAction.get((int)CVSCommandConstants.OPERATION_UPDATE_CMD_ID).performAction(this.getContext());
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    private void doInvocationImpl(CVSRunner runner) throws Exception {
        runner.exec_();
        if (runner.getExitCode_() != null && runner.getExitCode_() == 0) {
            return;
        }
        if (runner.getErrorText_() != null && runner.getErrorText_().indexOf("Up-to-date check failed") >= 0) {
            throw new UpToDateCheckFailedException();
        }
        throw new CVSProcessException(CVSArb.get("ERROR_COMMIT_FAILED"), runner.getErrorText_());
    }

    private Component createFileListerComponent(Collection nodes) throws Exception {
        ClientDisplayProperty statusProperty = new ClientDisplayProperty(CVSArb.get("DISPLAY_PROPERTY_STATUS"), (Object)"an example outgoing status string", String.class);
        MutableVersionOperationModel opModel = VCSComponents.createFileListerModel((Collection)nodes, (DisplayProperty[])new DisplayProperty[]{statusProperty});
        URL[] urls = VCSModelUtils.convertNodesToURLs((Collection)nodes);
        CVSClient.getInstance();
        VCSStatus[] statuses = (VCSStatus[])CVSClient.getStatusCache().get(urls);
        int i = 0;
        for (Object o : nodes) {
            String statusText = statuses[i] instanceof CVSFileStatus ? ((CVSFileStatus)statuses[i]).getLabel() : null;
            opModel.setProperty(i, (DisplayProperty)statusProperty, (Object)statusText);
            ++i;
        }
        VersionOperationPanel panel = new VersionOperationPanel();
        panel.installModel((VersionOperationModel)opModel);
        return panel;
    }

    protected Collection<URL> collectAutoAddFilesURLs(URL[] urls) throws Exception {
        ArrayList<URL> urls0 = new ArrayList<URL>();
        for (int i = 0; i < urls.length; ++i) {
            if (URLFileSystem.isDirectoryPath((URL)urls[i])) {
                urls0.addAll(CVSListFilesUtil.listFiles(urls[i], 5));
                continue;
            }
            urls0.add(urls[i]);
        }
        return urls0;
    }

    private int autoAddFilesOnCommit(URL[] urls, Runnable callback) throws Exception {
        URL[] confirmedUrls;
        Boolean automaticallyAddFiles = CVSCommandOptionsPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).getAutoAddOnCommit();
        if (automaticallyAddFiles != null && !automaticallyAddFiles.booleanValue()) {
            callback.run();
            return 0;
        }
        ArrayList<URL> candidateUrls = new ArrayList<URL>(this.collectAutoAddFilesURLs(urls));
        CVSIgnorePatternList.filterIgnored(candidateUrls);
        CVSClient.getInstance();
        VCSStatus[] statuses = (VCSStatus[])CVSClient.getStatusCache().get(candidateUrls.toArray(new URL[0]));
        Iterator itr = candidateUrls.iterator();
        Iterator<VCSStatus> itr2 = Arrays.asList(statuses).iterator();
        while (itr.hasNext()) {
            itr.next();
            if (itr2.next() == CVSFileStatus.STATUS_UNADDED) continue;
            itr.remove();
        }
        if (candidateUrls.size() <= 0) {
            callback.run();
            return 0;
        }
        if (MessageDialog.getPersistence().isHidden(SKIP_AUTO_ADD_FILES_PERSISTENCE_KEY)) {
            confirmedUrls = candidateUrls.toArray(new URL[0]);
        } else {
            confirmedUrls = this.autoAddFilesOnCommitConfirm(urls, candidateUrls);
            if (confirmedUrls == null) {
                return 1;
            }
        }
        if (!CVSOperationAdd.registerUnrecognizedFileTypesUI(confirmedUrls)) {
            return 1;
        }
        return this._autoAddFilesOnCommit(confirmedUrls, callback);
    }

    private URL[] autoAddFilesOnCommitConfirm(URL[] urls, Collection candidateUrls) {
        String title = CVSArb.get("AUTO_ADD_FILES_TITLE");
        URL[] confirmedUrls = null;
        JCheckBox optionalCheckBox = new JCheckBox();
        if (candidateUrls.size() == 1) {
            URL[] uRLArray;
            URL url = (URL)candidateUrls.iterator().next();
            String message = CVSArb.format("AUTO_ADD_FILES_SINGLE", URLFileSystem.getPlatformPathName((URL)((URL)candidateUrls.iterator().next())));
            int result = MessageDialog.confirmOrCancel((Component)VCSWindowUtils.getCurrentWindow(), (Object)MessageUtil.createOptionalMessage((Object)message, (JCheckBox)optionalCheckBox), (String)title, null, (boolean)false);
            if (result == -1) {
                return null;
            }
            if (result == 1) {
                URL[] uRLArray2 = new URL[1];
                uRLArray = uRLArray2;
                uRLArray2[0] = url;
            } else {
                uRLArray = new URL[]{};
            }
            confirmedUrls = uRLArray;
        } else {
            String messageSubstring = null;
            Element[] selection = this.getContext().getSelection();
            if (messageSubstring == null && selection != null && selection.length == 1 && selection[0] instanceof Project) {
                messageSubstring = CVSArb.get("AUTO_ADD_FILES_MULTI_PROJECT_SUBST");
            }
            if (messageSubstring == null && urls.length == 1 && URLFileSystem.isDirectory((URL)urls[0])) {
                messageSubstring = CVSArb.format("AUTO_ADD_FILES_MULTI_DIR_SUBST", URLFileSystem.getFileName((URL)urls[0]));
            }
            if (messageSubstring == null) {
                messageSubstring = CVSArb.get("AUTO_ADD_FILES_MULTI_NONSPEC_SUBST");
            }
            String message = CVSArb.format("AUTO_ADD_FILES_MULTI", messageSubstring);
            CheckBoxListModel listModel = VCSComponents.createCheckBoxListModel((Object[])VCSModelUtils.findOrCreateNodes((URL[])candidateUrls.toArray(new URL[0])), (boolean)true);
            AutoAddFilesPanel autoAddFilesPanel = new AutoAddFilesPanel(listModel, message);
            if (AutoAddFilesPanel.showDialog(VCSWindowUtils.getCurrentWindow(), title, MessageUtil.createOptionalMessage((Object)((Object)autoAddFilesPanel), (JCheckBox)optionalCheckBox), "f1_cvsaddfilestocvs_html") == 1) {
                return null;
            }
            List selectionList = listModel.getSelectionList();
            confirmedUrls = selectionList != null ? VCSModelUtils.convertNodesToURLs((Collection)selectionList) : new URL[]{};
        }
        MessageDialog.getPersistence().setHidden(SKIP_AUTO_ADD_FILES_PERSISTENCE_KEY, optionalCheckBox.isSelected());
        return confirmedUrls;
    }

    private int _autoAddFilesOnCommit(final URL[] confirmedUrls, final Runnable callback) {
        VCSWaitRunnable r = new VCSWaitRunnable(this.getExceptionHandler(), null){

            protected final void runImpl() throws Exception {
                for (int i = 0; i < confirmedUrls.length; ++i) {
                    URL parentDirectoryUrl = URLFileSystem.getParent((URL)confirmedUrls[i]);
                    if (!CVSOperationAdd.ensureVersionedDir(parentDirectoryUrl, null)) {
                        throw new CVSOperationException(CVSArb.format("ERROR_AUTO_ADD_ON_COMMIT", URLFileSystem.getPlatformPathName((URL)parentDirectoryUrl)));
                    }
                    if (CVSFileSystemAPI.executeAddRegularFile(confirmedUrls[i])) continue;
                    throw new CVSOperationException(CVSArb.format("ERROR_AUTO_ADD_ON_COMMIT", URLFileSystem.getPlatformPathName((URL)confirmedUrls[i])));
                }
            }

            protected final void runPostOperationAWT() throws Exception {
                callback.run();
            }
        };
        Thread t = new Thread((Runnable)r, "CVSOperationCommit AutoAddFiles");
        t.start();
        return 0;
    }

    private static class AutoAddFilesPanel
    extends SelectFilesPanel {
        public static final int OK_BUTTON = 0;
        public static final int CANCEL_BUTTON = 1;
        public static final int DLG_MAX_WIDTH = 800;
        public static final int DLG_MAX_HEIGHT = 600;
        public static final int DLG_MIN_WIDTH = 400;
        public static final int DLG_MIN_HEIGHT = 300;

        AutoAddFilesPanel(CheckBoxListModel listModel, String prompt) {
            super(listModel, true, prompt);
        }

        public static final int showDialog(Component parent, String title, Component pnl, String helpTopic) {
            int displayButtons = 3;
            if (helpTopic != null) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)pnl, helpTopic);
                displayButtons += 4;
            }
            JEWTDialog dialog = AutoAddFilesPanel.newDialog(parent, title, pnl, displayButtons);
            dialog.setDefaultButton(1);
            return CVSDialogRunner.runDialog((JDialog)dialog) ? 0 : 1;
        }

        private static JEWTDialog newDialog(Component parent, String title, Component pnl, int buttons) {
            JEWTDialog dlg = JEWTDialog.createDialog((Component)parent, (String)title, (int)buttons);
            dlg.setMinimumSize(400, 300);
            dlg.setMaximumInitialSize(800, 600);
            dlg.setContent(pnl);
            dlg.setResizable(true);
            return dlg;
        }
    }

    private class UpToDateCheckFailedException
    extends Exception {
        UpToDateCheckFailedException() {
        }
    }
}

