/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav.cmd;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStreamReader;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.Encodings;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionMenuHandler;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.nav.cmd.CVSAbstractConnectionCmd;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

public class CVSSetConnectionEncodingCmd
extends CVSAbstractConnectionCmd {
    private final JLabel _fileContentsLabel = new JLabel();
    private final JRadioButton _platformDefaultEncodingRadioButton = new JRadioButton();
    private final JRadioButton _ideGlobalEncodingRadioButton = new JRadioButton();
    private final JRadioButton _otherEncodingRadioButton = new JRadioButton();
    private final JComboBox _otherEncodingComboBox = new JComboBox();
    private final JLabel _loadingEncodingsLabel = new JLabel();
    private JEWTDialog _dialog;
    private boolean _encodingsLoaded;

    public CVSSetConnectionEncodingCmd() {
        super(CVSConnectionMenuHandler.CVS_SET_ENCODING_CMD_ID);
    }

    @Override
    public int doitImpl() throws Exception {
        CVSConnectionNode[] connectionNodes = CVSSetConnectionEncodingCmd.getContextConnectionNodes(this.getContext());
        if (connectionNodes.length <= 0) {
            return -1;
        }
        String charsetName = connectionNodes[0].getConnection().getEncoding();
        this._loadingEncodingsLabel.setFont(this._loadingEncodingsLabel.getFont().deriveFont((float)this._fileContentsLabel.getFont().getSize() - 1.0f));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._platformDefaultEncodingRadioButton);
        bg.add(this._ideGlobalEncodingRadioButton);
        bg.add(this._otherEncodingRadioButton);
        if (charsetName == null) {
            this._platformDefaultEncodingRadioButton.setSelected(true);
        } else if (charsetName.equals(IdeUtil.getIdeEncoding())) {
            this._ideGlobalEncodingRadioButton.setSelected(true);
        } else {
            this._otherEncodingRadioButton.setSelected(true);
        }
        this._otherEncodingComboBox.setPreferredSize(new Dimension(200, this._otherEncodingComboBox.getPreferredSize().height));
        JPanel panel = new JPanel();
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        Insets insets = new Insets(2, 2, 2, 2);
        layoutBuilder.add((Component)this._fileContentsLabel, insets, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._platformDefaultEncodingRadioButton, insets, 2, false, false);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._ideGlobalEncodingRadioButton, insets, 2, false, false);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._otherEncodingRadioButton, insets, 1, false, false);
        layoutBuilder.add((Component)this._otherEncodingComboBox, insets, 1, false, false);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add(Box.createHorizontalGlue(), insets, 1, false, false);
        layoutBuilder.add((Component)this._loadingEncodingsLabel, insets, 1, false, false);
        layoutBuilder.nl();
        ResourceUtils.resLabel((JLabel)this._fileContentsLabel, (Component)this._fileContentsLabel, (String)CVSArb.get("ENCODING_FILE_CONTENTS"));
        ResourceUtils.resButton((AbstractButton)this._platformDefaultEncodingRadioButton, (String)CVSArb.get("ENCODING_PLATFORM_DEFAULT"));
        ResourceUtils.resButton((AbstractButton)this._ideGlobalEncodingRadioButton, (String)CVSArb.get("ENCODING_IDE_GLOBAL"));
        ResourceUtils.resButton((AbstractButton)this._otherEncodingRadioButton, (String)CVSArb.get("ENCODING_OTHER"));
        layoutBuilder.addToPanel((Container)panel);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_cvssetencoding_html");
        this._dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)this._platformDefaultEncodingRadioButton, (String)CVSArb.get("ENCODING_TITLE"), (int)7);
        this._otherEncodingRadioButton.setEnabled(false);
        this._otherEncodingComboBox.setEnabled(false);
        this._dialog.setOKButtonEnabled(false);
        final boolean[] exit = new boolean[1];
        Thread encodingsEnabler = new Thread("CVSSetConnectionEncodingCmd"){
            private boolean _firstUpdate;
            {
                super(x0);
                this._firstUpdate = true;
            }

            @Override
            public void run() {
                while (true) {
                    if (Boolean.TRUE.equals(CVSSetConnectionEncodingCmd.this._otherEncodingComboBox.getClientProperty("encodings-loaded"))) {
                        if (exit[0]) break;
                        CVSSetConnectionEncodingCmd.this._encodingsLoaded = true;
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CVSSetConnectionEncodingCmd.this.updateEnabledStates();
                            }
                        });
                        break;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        Assert.printStackTrace((Throwable)ie);
                    }
                    if (!this._firstUpdate) continue;
                    this._firstUpdate = false;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CVSSetConnectionEncodingCmd.this.updateEnabledStates();
                        }
                    });
                }
            }
        };
        Encodings.loadEncodings((JComboBox)this._otherEncodingComboBox, (boolean)true, (String)(charsetName != null ? charsetName : new InputStreamReader(System.in).getEncoding().intern()));
        encodingsEnabler.start();
        this._updateEnabledStates();
        this._loadingEncodingsLabel.setText(" ");
        ActionListener updateEnabledStatesActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                CVSSetConnectionEncodingCmd.this.updateEnabledStates();
            }
        };
        this._platformDefaultEncodingRadioButton.addActionListener(updateEnabledStatesActionListener);
        this._ideGlobalEncodingRadioButton.addActionListener(updateEnabledStatesActionListener);
        this._otherEncodingRadioButton.addActionListener(updateEnabledStatesActionListener);
        if (!this._dialog.runDialog()) {
            exit[0] = true;
            return 1;
        }
        if (this._platformDefaultEncodingRadioButton.isSelected()) {
            charsetName = null;
        }
        if (this._ideGlobalEncodingRadioButton.isSelected()) {
            charsetName = "ide-encoding";
        }
        if (this._otherEncodingRadioButton.isSelected()) {
            charsetName = this._otherEncodingComboBox.getSelectedItem().toString();
        }
        connectionNodes[0].getConnection().setEncoding(charsetName);
        CVSConnectionNodes.saveConnectionList();
        return 0;
    }

    private void updateEnabledStates() {
        this._updateEnabledStates();
        if (this._encodingsLoaded) {
            this._loadingEncodingsLabel.setText(" ");
        } else {
            ResourceUtils.resLabel((JLabel)this._loadingEncodingsLabel, (Component)this._loadingEncodingsLabel, (String)CVSArb.get("ENCODING_LOADING_ENCODINGS"));
        }
    }

    private void _updateEnabledStates() {
        this._otherEncodingRadioButton.setEnabled(this._encodingsLoaded);
        this._otherEncodingComboBox.setEnabled(this._encodingsLoaded && this._otherEncodingRadioButton.isSelected());
        this._dialog.setOKButtonEnabled(this._encodingsLoaded);
    }
}

