/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav.cmd;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import oracle.ide.Ide;
import oracle.ide.dialogs.SimpleInputDialog;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFileData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionMenuHandler;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionModuleNameCache;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNode;
import oracle.jdevimpl.vcs.cvs.nav.cmd.CVSAbstractConnectionCmd;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;

public class CVSOpenDirectoryCmd
extends CVSAbstractConnectionCmd {
    public CVSOpenDirectoryCmd() {
        super(CVSConnectionMenuHandler.CVS_OPEN_DIRECTORY_CMD_ID);
    }

    @Override
    public int doitImpl() throws Exception {
        CVSConnectionNode node = this.getContextConnectionNode();
        if (node == null) {
            return -1;
        }
        if (!node.ensureConnectionLogin()) {
            return 1;
        }
        final String directoryName = this.obtainDirectoryNameFromUser();
        if (directoryName == null) {
            return 1;
        }
        IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    CVSOpenDirectoryCmd.this._doitImpl(directoryName);
                }
                catch (Exception e) {
                    CVSClient.getInstance().getExceptionHandler().handleException(e);
                }
            }
        });
        return 0;
    }

    private int _doitImpl(String directoryName) throws Exception {
        TNode nodeTNode;
        TreeExplorer navigatorTreeExplorer;
        TNode directoryTNode;
        CVSConnectionNode node = this.getContextConnectionNode();
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.getParameters().setKeepCachedFiles(true);
        runner.getParameters().setQuiet(true);
        runner.setCmdArray_(new String[]{"-nq", "rdiff", "-l", "-s", "-rHEAD", directoryName});
        runner.getParameters().setRoot(node.getConnection().getRoot());
        try {
            runner.exec_();
            if (runner.getExitCode_() == null) {
                return -1;
            }
            if (runner.getExitCode_() != 0) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)CVSArb.format("ERROR_OPEN_DIR_NO_SUCH_MODULE", directoryName), (String)CVSArb.get("ERROR_OPEN_DIR_NO_SUCH_MODULE_TITLE"), null);
                return -1;
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            return -1;
        }
        if (!node.isOpen()) {
            node.open();
            if (!node.isOpen()) {
                return 1;
            }
        }
        Node directoryNode = null;
        Iterator itr = node.getChildren();
        while (itr.hasNext()) {
            Node c = (Node)itr.next();
            CVSConnectionFileData data = (CVSConnectionFileData)c.getData();
            if (!data.getFileName().equals(directoryName)) continue;
            directoryNode = c;
            break;
        }
        if (directoryNode != null) {
            node.remove((Element)directoryNode);
            UpdateMessage.fireChildRemoved((Subject)node, (Element)directoryNode);
        } else {
            directoryNode = node.createDirectoryNode(directoryName);
        }
        node.add((Element)directoryNode);
        UpdateMessage.fireChildAdded((Subject)node, (Element)directoryNode);
        if (this.context.getView() instanceof NavigatorWindow && (directoryTNode = navigatorTreeExplorer.searchTNodeBreadthFirst((Element)directoryNode, (nodeTNode = (navigatorTreeExplorer = ((NavigatorWindow)this.context.getView()).getTreeExplorer()).searchTNodeBreadthFirst((Element)node, navigatorTreeExplorer.getRoot())) != null ? nodeTNode : navigatorTreeExplorer.getRoot())) != null) {
            navigatorTreeExplorer.setSelected(directoryTNode);
        }
        this.putModuleNameCacheName(node.getConnection().getRoot(), directoryName);
        node.updateModuleFileData();
        return 0;
    }

    private String obtainDirectoryNameFromUser() {
        SimpleInputDialog dialog = new SimpleInputDialog(){

            protected boolean validate(String input) {
                if (!(input = input.trim()).equals("") && input.indexOf(47) < 0 && input.indexOf(92) < 0) {
                    return true;
                }
                MessageDialog.error((Component)this.getDialog(), (Object)CVSArb.format("ERROR_OPEN_DIR_INVALID_MODULE_NAME", input), (String)CVSArb.get("ERROR_OPEN_DIR_INVALID_MODULE_NAME_TITLE"), null);
                return false;
            }
        };
        if (!dialog.show(CVSArb.get("OPEN_DIR_ENTER_NAME_DIALOG_TITLE"), CVSArb.get("OPEN_DIR_ENTER_NAME_DIALOG_LABEL"), "f1_cvsopenmodule_html")) {
            return null;
        }
        return dialog.getInputValue().trim();
    }

    private void putModuleNameCacheName(String root, String directoryName) {
        String[] cachedDirectoryNames = CVSConnectionModuleNameCache.getNames(root);
        if (cachedDirectoryNames != null) {
            ArrayList<String> cachedDirectoryNames0 = new ArrayList<String>(Arrays.asList(cachedDirectoryNames));
            if (!cachedDirectoryNames0.contains(directoryName)) {
                cachedDirectoryNames0.add(directoryName);
            }
            cachedDirectoryNames = cachedDirectoryNames0.toArray(new String[0]);
        } else {
            cachedDirectoryNames = new String[]{directoryName};
        }
        CVSConnectionModuleNameCache.putNames(root, cachedDirectoryNames);
    }
}

