/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.model.Element;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDirectoryData;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionRootNode;

class CVSConnectionNodeCache {
    static final String ROOT_PATH = ".";
    private final CVSConnectionNode _connectionNode;
    private final Map _cacheMap;
    private final CVSConnectionRootNode _rootNode;

    CVSConnectionNodeCache(CVSConnectionNode connectionNode) {
        this._connectionNode = connectionNode;
        this._cacheMap = new HashMap();
        CVSConnectionDirectoryData rootData = new CVSConnectionDirectoryData(ROOT_PATH);
        this._rootNode = new CVSConnectionRootNode(this, rootData);
    }

    CVSConnectionRootNode getRootNode() {
        return this._rootNode;
    }

    CVSConnectionNode getConnectionNode() {
        return this._connectionNode;
    }

    Element find(String path) {
        return (Element)this._cacheMap.get(path);
    }

    Iterator iterator() {
        return Collections.unmodifiableSet(new HashSet(this._cacheMap.keySet())).iterator();
    }

    void cache(String path, Element node) {
        this._cacheMap.put(path, node);
    }

    void uncache(String path) {
        this._cacheMap.remove(path);
    }
}

