/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.nav;

import java.awt.Component;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.view.View;
import oracle.jdeveloper.vcs.nav.ConnectionNodeDecorator;
import oracle.jdeveloper.vcs.nav.ConnectionProvider;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.login.CVSLogin;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionCommandConstants;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionDirectoryNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionElement;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionFilterableContainer;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListAPI;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionListNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionModuleNameCache;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionModuleNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNode;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodeUtils;
import oracle.jdevimpl.vcs.cvs.nav.cmd.CVSDeleteConnectionCmd;
import oracle.jdevimpl.vcs.cvs.nav.cmd.CVSEditConnectionCmd;
import oracle.jdevimpl.vcs.cvs.resource.Resource;
import oracle.jdevimpl.vcs.util.ActionUtil;

public class CVSConnectionMenuHandler
implements Controller,
ContextMenuListener,
CVSConnectionCommandConstants,
CVSCommandConstants {
    private static boolean _commandsAvailable = true;

    CVSConnectionMenuHandler() {
        this.getAction(CVS_NEW_CONNECTION_CMD_ID, "oracle.jdevimpl.vcs.cvs.nav.cmd.CVSNewConnectionCmd", "NEW_CONNECTION_CMD");
        this.getAction(CVS_CONN_IMPORT_ID, "oracle.jdevimpl.vcs.cvs.nav.cmd.CVSImportConnectionsCmd", "CONN_IMPORT_CMD");
        this.getAction(CVS_CONN_EXPORT_ID, "oracle.jdevimpl.vcs.cvs.nav.cmd.CVSExportConnectionsCmd", "CONN_EXPORT_CMD");
        this.getAction(CVS_OPEN_CONNECTION_CMD_ID, "oracle.jdevimpl.vcs.cvs.nav.cmd.CVSOpenConnectionCmd", "OPEN_CONNECTION_CMD");
        this.getAction(CVS_CLOSE_CONNECTION_CMD_ID, "oracle.jdevimpl.vcs.cvs.nav.cmd.CVSCloseConnectionCmd", "CLOSE_CONNECTION_CMD");
        this.getAction(CVS_OPEN_DIRECTORY_CMD_ID, "oracle.jdevimpl.vcs.cvs.nav.cmd.CVSOpenDirectoryCmd", "OPEN_DIRECTORY_CMD");
        this.getAction(CVS_COPY_CVSROOT_CMD_ID, "oracle.jdevimpl.vcs.cvs.nav.cmd.CVSCopyCvsRootCmd", "COPY_CVSROOT_CMD");
        this.getAction(CVS_SET_ENCODING_CMD_ID, "oracle.jdevimpl.vcs.cvs.nav.cmd.CVSSetConnectionEncodingCmd", "CVS_SET_ENCODING_CMD");
        this.registerChainedControllers();
    }

    private void chainMeTo(int cmdId) {
        IdeAction action = IdeAction.find((int)cmdId);
        if (action != null) {
            action.addController((Controller)this);
        }
    }

    void registerChainedControllers() {
        this.chainMeTo(51);
        this.chainMeTo(20);
        this.chainMeTo(56);
        this.chainMeTo(57);
    }

    public boolean update(IdeAction action, Context context) {
        try {
            CVSConnectionNode connectionNode;
            if (context == null) {
                return false;
            }
            if (!ConnectionProvider.isVersioningConnectionView((View)context.getView())) {
                return false;
            }
            int cmdId = action.getCommandId();
            Element e = context.getElement();
            if (e instanceof CVSConnectionElement) {
                CVSClient client = CVSClient.getInstance();
                client.verifyClientState();
                if (!client.isClientAvailable()) {
                    action.setEnabled(false);
                    return true;
                }
            }
            if ((connectionNode = CVSConnectionNodeUtils.getContextConnectionNode(context)) != null && !CVSConnectionListAPI.isSupportedConnection(connectionNode.getConnection()) && cmdId != 20 && cmdId != CVSConnectionCommandConstants.CVS_COPY_CVSROOT_CMD_ID && cmdId != 56) {
                action.setEnabled(false);
                return true;
            }
            CVSConnectionDirectoryNode directoryNode = CVSConnectionNodeUtils.getContextDirectoryNode(context);
            if (cmdId == CVS_OPEN_CONNECTION_CMD_ID) {
                action.setEnabled(connectionNode != null && !connectionNode.isOpen());
                return true;
            }
            if (cmdId == CVS_CLOSE_CONNECTION_CMD_ID) {
                action.setEnabled(connectionNode != null && connectionNode.isOpen());
                return true;
            }
            if (cmdId == CVS_OPEN_DIRECTORY_CMD_ID) {
                action.setEnabled(connectionNode != null);
                return true;
            }
            if (cmdId == CVS_CONN_EXPORT_ID) {
                action.setEnabled(e instanceof CVSConnectionListNode && ((CVSConnectionListNode)e).hasConnection());
                return true;
            }
            if (cmdId == CVS_SET_ENCODING_CMD_ID) {
                action.setEnabled(connectionNode != null);
                return true;
            }
            if (cmdId == 51 && e instanceof CVSConnectionElement) {
                action.setEnabled(connectionNode != null && connectionNode.isOpen() || directoryNode != null && directoryNode.isOpen());
                return true;
            }
            if (cmdId == 56 && CVSConnectionNodeUtils.getContextConnectionNode(context) != null) {
                action.setEnabled(connectionNode != null && connectionNode.getConnection().isEditable());
                return true;
            }
            if (cmdId == 20 && e instanceof CVSConnectionElement) {
                action.setEnabled(connectionNode != null);
                return true;
            }
            if (cmdId == 57 && e instanceof CVSConnectionElement) {
                action.setEnabled(false);
                return true;
            }
        }
        catch (Exception ex) {
            CVSClient.getInstance().getExceptionHandler().handleException(ex, (Component)Ide.getMainWindow());
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (!ConnectionProvider.isVersioningConnectionView((View)context.getView())) {
            return false;
        }
        int cmdId = action.getCommandId();
        CVSConnectionNode connectionNode = CVSConnectionNodeUtils.getContextConnectionNode(context);
        CVSConnectionDirectoryNode directoryNode = CVSConnectionNodeUtils.getContextDirectoryNode(context);
        try {
            if (cmdId == CVS_OPEN_CONNECTION_CMD_ID || cmdId == CVS_CLOSE_CONNECTION_CMD_ID || cmdId == CVS_OPEN_DIRECTORY_CMD_ID || cmdId == CVS_SET_ENCODING_CMD_ID) {
                MetaClass mClass = new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.jdeveloper.cvs"), action.getCommand());
                Command command = CommandProcessor.createCommandFromMeta((MetaClass)mClass, (Context)context);
                CommandProcessor.getInstance().invoke(command);
                return true;
            }
            if (cmdId == 51) {
                CVSConnectionFilterableContainer n;
                if (connectionNode != null) {
                    CVSConnectionModuleNameCache.removeNames(connectionNode.getConnection().getRoot());
                    connectionNode.getConnection().setModuleFileData(null);
                }
                CVSConnectionFilterableContainer cVSConnectionFilterableContainer = n = connectionNode != null ? connectionNode : directoryNode;
                if (n != null) {
                    RevertNodeCommand.reload((Node)n);
                    return true;
                }
            } else if (cmdId == 56) {
                if (connectionNode != null) {
                    CVSEditConnectionCmd command = new CVSEditConnectionCmd();
                    command.setContext(context);
                    CommandProcessor.getInstance().invoke((Command)command);
                    return true;
                }
            } else if (cmdId == 20 && connectionNode != null) {
                CVSDeleteConnectionCmd command = new CVSDeleteConnectionCmd();
                command.setContext(context);
                CommandProcessor.getInstance().invoke((Command)command);
                return true;
            }
        }
        catch (Exception e) {
            CVSClient.getInstance().getExceptionHandler().handleException(e, (Component)Ide.getMainWindow());
            return true;
        }
        return false;
    }

    public boolean handleDefaultAction(Context context) {
        Element e = context.getElement();
        if (e == null || context == null) {
            return false;
        }
        if (e instanceof CVSConnectionListNode) {
            CVSClient.getInstance().getController().handleEvent(IdeAction.find((int)CVS_NEW_CONNECTION_CMD_ID), context);
            return true;
        }
        if (e instanceof CVSConnectionNode) {
            if (!((CVSConnectionNode)e).getConnection().isEditable()) {
                return true;
            }
            IdeAction action = IdeAction.find((int)56);
            try {
                action.performAction(context);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public void menuWillHide(ContextMenu popup) {
    }

    private static final JMenuItem createMenuItem(ContextMenu popup, int cmdId, float weight) {
        return popup.createMenuItem((ToggleAction)IdeAction.find((int)cmdId), weight);
    }

    private static final void addMenuItem(ContextMenu popup, int cmdId, float weight, float section) {
        popup.add((Component)CVSConnectionMenuHandler.createMenuItem(popup, cmdId, weight), section);
    }

    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        if (context == null) {
            return;
        }
        Element e = context.getElement();
        if (e == null) {
            return;
        }
        if (!_commandsAvailable) {
            return;
        }
        Controller clientController = CVSClient.getInstance().getController();
        if (e instanceof CVSConnectionListNode) {
            this.update(IdeAction.find((int)CVS_NEW_CONNECTION_CMD_ID), context);
            CVSConnectionMenuHandler.addMenuItem(popup, CVS_NEW_CONNECTION_CMD_ID, 1.0f, 1.0f);
            this.update(IdeAction.find((int)CVS_CONN_EXPORT_ID), context);
            this.update(IdeAction.find((int)CVS_CONN_IMPORT_ID), context);
            CVSConnectionMenuHandler.addMenuItem(popup, CVS_CONN_EXPORT_ID, 1.0f, MenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
            CVSConnectionMenuHandler.addMenuItem(popup, CVS_CONN_IMPORT_ID, 2.0f, MenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
            return;
        }
        CVSConnectionNode node = CVSConnectionNodeUtils.getContextConnectionNode(context);
        if (node != null || e instanceof CVSConnectionDirectoryNode || e instanceof CVSConnectionModuleNode) {
            clientController.update(IdeAction.find((int)OPERATION_CHECKOUT_CMD_ID), context);
            CVSConnectionMenuHandler.addMenuItem(popup, OPERATION_CHECKOUT_CMD_ID, 1.0f, MenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
        }
        if (node != null && CVSClient.getInstance().isUsingInternalClient() && CVSConnectionListAPI.isSupportedConnection(((CVSConnectionNode)e).getConnection())) {
            CVSConnectionMenuHandler.addMenuItem(popup, CVS_SET_ENCODING_CMD_ID, MenuConstants.WEIGHT_EDIT_PROPERTIES - 0.1f, MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
        }
        if (e instanceof CVSConnectionDirectoryNode) {
            this.update(IdeAction.find((int)51), context);
            CVSConnectionMenuHandler.addMenuItem(popup, 51, MenuConstants.WEIGHT_VIEW_REFRESH, MenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
            return;
        }
        if (node == null) {
            return;
        }
        CVSRootString root = new CVSRootString(node.getConnection().getRoot());
        this.update(IdeAction.find((int)CVS_OPEN_DIRECTORY_CMD_ID), context);
        CVSConnectionMenuHandler.addMenuItem(popup, CVS_OPEN_DIRECTORY_CMD_ID, 1.0f, MenuConstants.SECTION_CONNECTION_WINDOW_CNXN_CTXT);
        if (CVSLogin.hasMethod(root)) {
            clientController.update(IdeAction.find((int)OPERATION_LOGIN_CMD_ID), context);
            clientController.update(IdeAction.find((int)OPERATION_LOGOUT_CMD_ID), context);
            CVSConnectionMenuHandler.addMenuItem(popup, OPERATION_LOGIN_CMD_ID, 0.1f, MenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
            CVSConnectionMenuHandler.addMenuItem(popup, OPERATION_LOGOUT_CMD_ID, 0.2f, MenuConstants.SECTION_ADDITIONAL_CTXT_MENU);
        }
        if (!(e instanceof ConnectionNodeDecorator)) {
            this.update(IdeAction.find((int)20), context);
        }
        this.update(IdeAction.find((int)51), context);
        if (!(e instanceof ConnectionNodeDecorator)) {
            CVSConnectionMenuHandler.addMenuItem(popup, 20, MenuConstants.WEIGHT_EDIT_DELETE, MenuConstants.SECTION_CONNECTION_WINDOW_CNXN_CTXT);
        }
        CVSConnectionMenuHandler.addMenuItem(popup, 51, MenuConstants.WEIGHT_VIEW_REFRESH, MenuConstants.SECTION_CONNECTION_WINDOW_FILTER_CTXT);
        this.update(IdeAction.find((int)CVS_OPEN_CONNECTION_CMD_ID), context);
        this.update(IdeAction.find((int)CVS_CLOSE_CONNECTION_CMD_ID), context);
        CVSConnectionMenuHandler.addMenuItem(popup, CVS_OPEN_CONNECTION_CMD_ID, 2.0f, MenuConstants.SECTION_CONNECTION_WINDOW_CNXN_CTXT);
        CVSConnectionMenuHandler.addMenuItem(popup, CVS_CLOSE_CONNECTION_CMD_ID, 3.0f, MenuConstants.SECTION_CONNECTION_WINDOW_CNXN_CTXT);
        this.update(IdeAction.find((int)56), context);
        CVSConnectionMenuHandler.addMenuItem(popup, 56, MenuConstants.WEIGHT_EDIT_PROPERTIES, MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
        CVSConnectionMenuHandler.addMenuItem(popup, CVSConnectionCommandConstants.CVS_COPY_CVSROOT_CMD_ID, 1.0f, MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU - 0.1f);
    }

    public static final void setCommandsAvailable(boolean available) {
        _commandsAvailable = available;
    }

    private IdeAction getAction(int cmdId, String command, String baseRes) {
        Class<Resource> resourceClass = Resource.class;
        return ActionUtil.getAction(resourceClass, (int)cmdId, (MetaClass)new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader("oracle.jdeveloper.cvs"), command), (String)baseRes);
    }
}

