/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.login;

import java.awt.Component;
import java.awt.EventQueue;
import java.net.URL;
import java.util.Map;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSLoginCache;
import oracle.jdevimpl.vcs.cvs.client.CVSRootString;
import oracle.jdevimpl.vcs.cvs.login.CVSLogin;
import oracle.jdevimpl.vcs.cvs.login.CVSLoginMethod;
import oracle.jdevimpl.vcs.cvs.login.CVSLoginUtils;

public abstract class CVSAbstractMethod
implements CVSLoginMethod {
    @Override
    public void doLogin(URL dir) throws VCSException {
        this.doLogin(CVSLoginUtils.getSandboxRoot(dir));
    }

    @Override
    public void doLogin(CVSRootString root) throws VCSException {
        this.doLogin(root, null);
    }

    @Override
    public void doLogin(CVSRootString root, Component parent) throws VCSException {
        this.doLogin(root, parent, null, CVSClient.getInstance().getExceptionHandler());
    }

    @Override
    public void doLogin(final CVSRootString root, Component parent, Map connectionModel, VCSExceptionHandler exceptionHandler) throws VCSException {
        this.doLoginSpi(root, parent, connectionModel, exceptionHandler);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CVSLogin.fireLoginPerformed(this, root);
            }
        });
    }

    @Override
    public void doLogout(URL dir) throws VCSException {
        this.doLogout(CVSLoginUtils.getSandboxRoot(dir));
    }

    @Override
    public void doLogout(final CVSRootString root) throws VCSException {
        this.doLogoutSpi(root);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CVSLogin.fireLogoutPerformed(this, root);
            }
        });
    }

    @Override
    public void doLogoutAll() {
        this.doLogoutAllSpi();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CVSLogin.fireLogoutPerformed(this, null);
            }
        });
    }

    @Override
    public boolean isLoggedIn(URL dir) {
        try {
            return this.isLoggedIn(CVSLoginUtils.getSandboxRoot(dir));
        }
        catch (VCSException ce) {
            return false;
        }
    }

    @Override
    public boolean isLoggedIn(CVSRootString root) {
        return CVSLoginCache.getInstance().isLoggedIn(root);
    }

    @Override
    public boolean isLoggedInImpl(CVSRootString root) {
        return this.isLoggedInSpi(root);
    }

    @Override
    public char[] getLoginPassword(CVSRootString root) throws Exception {
        return this.getLoginPasswordSpi(root);
    }

    @Override
    public void clearCachedObjects() {
        this.clearCachedObjectsSpi();
    }

    protected abstract void doLoginSpi(CVSRootString var1, Component var2, Map var3, VCSExceptionHandler var4) throws VCSException;

    protected abstract void doLogoutSpi(CVSRootString var1) throws VCSException;

    protected void doLogoutAllSpi() {
    }

    protected char[] getLoginPasswordSpi(CVSRootString root) throws Exception {
        return null;
    }

    protected abstract boolean isLoggedInSpi(CVSRootString var1);

    protected void clearCachedObjectsSpi() {
    }
}

