/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.control.tagchooser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.javatools.controls.completionfield.CompletionTextField;
import oracle.javatools.controls.completionfield.FieldInsightProvider;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.SwingUtils;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagChooser;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagListView;
import oracle.jdevimpl.vcs.cvs.control.tagchooser.CVSTagNode;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

public class CVSTagField2
extends Box {
    private final CompletionTextField _textField = new CompletionTextField();
    private final JButton _popupButton;
    private CVSTagChooser _chooser;
    private Window _popup;

    public CVSTagField2() {
        super(0);
        this._textField.setColumns(15);
        this._textField.getPopupHandler().registerInsightProvider((FieldInsightProvider)new FieldInsightProviderImpl());
        this._textField.getPopupHandler().setAlignWithField(true);
        this._textField.getPopupHandler().setVisibleRowCount(8);
        this._popupButton = new JButton(OracleIcons.getIcon((String)"find.png"));
        this._popupButton.getAccessibleContext().setAccessibleName(CVSArb.get("FIND_TAGS_ACCESSIBLE_TEXT"));
        this._popupButton.setToolTipText(CVSArb.get("FIND_TAGS_ACCESSIBLE_TEXT"));
        this._popupButton.setPreferredSize(new Dimension(this._textField.getPreferredSize().height, this._textField.getPreferredSize().height));
        this._popupButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (CVSTagField2.this._chooser == null) {
                    return;
                }
                final JEWTDialog dialog = new JEWTDialog(SwingUtils.getAncestorDialog((Component)CVSTagField2.this), CVSArb.get("TAGS_CHOOSER_TITLE"));
                dialog.setButtonMask(3);
                dialog.setContent(CVSTagField2.this._chooser.getGUI());
                dialog.setResizable(true);
                CVSTagField2.this._chooser.addBusyStateListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent ce) {
                        this.updateDialogOKEnabled(dialog, CVSTagField2.this._chooser);
                    }
                });
                CVSTagField2.this._chooser.addSelectionListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent ce) {
                        this.updateDialogOKEnabled(dialog, CVSTagField2.this._chooser);
                    }
                });
                if (!dialog.runDialog()) {
                    return;
                }
                String tag = CVSTagField2.this._chooser.getTagValue();
                String internalDate = CVSTagField2.this._chooser.getDateValueISO8601();
                if (tag != null) {
                    CVSTagField2.this._textField.setText(tag);
                }
                if (tag == null && internalDate != null) {
                    CVSTagField2.this._textField.setText(CVSTagChooser.internalToExternalDate(internalDate));
                }
            }

            protected void updateDialogOKEnabled(JEWTDialog dialog, CVSTagChooser branchChooser) {
                dialog.setOKButtonEnabled(!branchChooser.isBusy() && (branchChooser.getTagValue() != null || branchChooser.getDateValueISO8601() != null));
            }
        });
        this.add((Component)this._textField);
        this.add(Box.createHorizontalStrut(2));
        this.add(this._popupButton);
        this.setFocusable(false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._textField.setEnabled(enabled);
        this._popupButton.setEnabled(enabled);
        if (!enabled) {
            this.hidePopup();
        }
    }

    public JTextField getTextField() {
        return this._textField;
    }

    private void hidePopup() {
        if (this._popup == null) {
            return;
        }
        this._popup.setVisible(false);
        this._popup = null;
    }

    public void start(CVSTagChooser chooser) {
        if (this._chooser != null) {
            this.stop();
        }
        this._chooser = chooser;
        this._chooser.start();
    }

    public void stop() {
        if (this._chooser.isStarted()) {
            this._chooser.stop();
        }
    }

    public String getNameOrTagValue() {
        String date = this.getDateValueISO8601();
        return date != null ? null : this._textField.getText();
    }

    public String getDateValueISO8601() {
        String text = this._textField.getText();
        for (String internalDate : this._chooser.getAvailableDatesISO8601()) {
            if (!CVSTagChooser.internalToExternalDate(internalDate).equals(text)) continue;
            return internalDate;
        }
        return null;
    }

    private class FieldInsightProviderImpl
    implements FieldInsightProvider {
        private FieldInsightProviderImpl() {
        }

        public ListCellRenderer getCellRenderer() {
            return new CVSTagListView.ListCellRendererImpl();
        }

        public boolean handlesInsight(Document doc, int pos) {
            return this.getInsightData(doc, pos).length > 0;
        }

        public Object[] getInsightData(Document doc, int pos) {
            if (CVSTagField2.this._chooser == null) {
                return new Object[0];
            }
            try {
                String s = doc.getText(0, pos);
                ArrayList<CVSTagNode> matches = new ArrayList<CVSTagNode>(CVSTagField2.this._chooser.getModel());
                Iterator itr = matches.iterator();
                while (itr.hasNext()) {
                    CVSTagNode node = (CVSTagNode)itr.next();
                    if (node.getTag() != null && node.getTag().getName().startsWith(s) || node.getDate() != null && CVSTagChooser.internalToExternalDate(node.getDate()).startsWith(s)) continue;
                    itr.remove();
                }
                return matches.toArray();
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                return new Object[0];
            }
        }

        public void completeInsight(Document doc, int pos, Object insightObject) {
            CVSTagNode node = (CVSTagNode)insightObject;
            String s = node.getTag() != null ? node.getTag().getName() : CVSTagChooser.internalToExternalDate(node.getDate());
            s = s.substring(pos);
            try {
                doc.remove(pos, doc.getLength() - pos);
                doc.insertString(doc.getLength(), s, null);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }

        public boolean isAutoPopupChar(char c) {
            return true;
        }
    }
}

