/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.control;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdevimpl.vcs.cvs.CVSResourcePicker;

public class CVSListEditor
extends JPanel {
    private JList m_list;
    private ListSelectionListener m_listener = new ListSelectionListener(){

        @Override
        public final void valueChanged(ListSelectionEvent e) {
            CVSListEditor.this.updateValue();
            CVSListEditor.this.updateRemoveEnablement();
        }
    };
    private JTextField m_editorField;
    private JButton m_addButton;
    private JButton m_removeButton;
    private EntryValidator m_validator;

    public CVSListEditor() {
        Insets i = new Insets(2, 2, 2, 2);
        LayoutBuilder builder = new LayoutBuilder();
        this.m_editorField = new JTextField();
        this.m_editorField.setName("EditorField");
        this.m_addButton = new JButton();
        this.m_addButton.setName("AddButton");
        this.m_removeButton = new JButton();
        this.m_removeButton.setName("RemoveButton");
        JComponent c = this.m_editorField;
        builder.add((Component)c, i, 1, false, true);
        c = this.m_addButton;
        builder.add((Component)c, i, 1, false, false);
        c = this.m_removeButton;
        builder.add((Component)c, i, 1, false, false);
        builder.nl();
        builder.addToPanel((Container)this);
        this.setName("CVSListEditor");
        CVSResourcePicker.getPicker(this).start((Container)this);
        this.m_addButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                CVSListEditor.this.addItem();
                CVSListEditor.this.updateEnablement();
            }
        });
        this.m_removeButton.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                CVSListEditor.this.removeItem();
                CVSListEditor.this.updateEnablement();
            }
        });
        this.m_editorField.addKeyListener(new KeyAdapter(){

            @Override
            public final void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    CVSListEditor.this.addItem();
                    e.consume();
                }
                CVSListEditor.this.updateAddEnablement();
            }

            @Override
            public final void keyReleased(KeyEvent e) {
                CVSListEditor.this.updateAddEnablement();
            }

            @Override
            public final void keyTyped(KeyEvent e) {
                CVSListEditor.this.updateAddEnablement();
            }
        });
        this.updateEnablement();
    }

    public void setList(JList list) {
        if (this.m_list != null) {
            this.m_list.removeListSelectionListener(this.m_listener);
        }
        this.m_list = list;
        if (this.m_list != null) {
            if (!(this.m_list.getModel() instanceof DefaultListModel)) {
                this.m_list.setModel(new DefaultListModel());
            }
            this.m_list.setSelectionMode(2);
            this.m_list.addListSelectionListener(this.m_listener);
        }
    }

    public void setListData(Object[] data) {
        if (this.m_list == null) {
            return;
        }
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        for (int i = 0; i < data.length; ++i) {
            model.addElement(data[i]);
        }
        this.m_list.setModel(model);
    }

    public List getList() {
        if (this.m_list == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.m_list.getModel().getSize(); ++i) {
            list.add(this.m_list.getModel().getElementAt(i));
        }
        return list;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_editorField.setEnabled(enabled);
        this.updateEnablement();
    }

    @Override
    public void requestFocus() {
        this.m_editorField.requestFocus();
    }

    public DefaultListModel getModel() {
        if (this.m_list == null) {
            return null;
        }
        return (DefaultListModel)this.m_list.getModel();
    }

    public void setValidation(String re, Component comp, String error) {
        this.setValidation(re, comp, error, "");
    }

    public void setValidation(String re, Component comp, String error, String title) {
        this.m_validator = new EntryValidator(Pattern.compile(re), comp, error, title);
    }

    private final void updateValue() {
        if (this.m_list == null) {
            return;
        }
        Object[] items = this.m_list.getSelectedValues();
        if (items == null || items.length != 1) {
            this.m_editorField.setText("");
            return;
        }
        this.m_editorField.setText(items[0].toString());
    }

    private final void addItem() {
        if (this.m_list == null) {
            return;
        }
        String value = this.m_editorField.getText();
        if (value.equals("") || this.getModel().contains(value)) {
            return;
        }
        if (this.m_validator != null && this.m_validator.getRE() != null && !this.m_validator.getRE().matcher(value).find()) {
            if (this.m_validator.getError() == null) {
                return;
            }
            Component comp = this.m_validator.getComponent();
            if (comp == null) {
                comp = this;
            }
            MessageDialog.information((Component)comp, (Object)this.m_validator.getError(), (String)this.m_validator.getTitle(), null);
            return;
        }
        this.getModel().addElement(this.m_editorField.getText());
        this.m_editorField.setText("");
    }

    private final void removeItem() {
        if (this.m_list == null) {
            return;
        }
        Object[] items = this.m_list.getSelectedValues();
        for (int i = 0; i < items.length; ++i) {
            this.getModel().removeElement(items[i]);
        }
        this.m_editorField.setText("");
        this.m_removeButton.setEnabled(true);
        if (this.m_list.getModel().getSize() == 0) {
            this.m_list.clearSelection();
            return;
        }
        this.m_list.setSelectedIndex(0);
        this.m_list.ensureIndexIsVisible(0);
    }

    private final void updateEnablement() {
        this.updateAddEnablement();
        this.updateRemoveEnablement();
    }

    private final void updateAddEnablement() {
        if (!this.isEnabled()) {
            this.m_addButton.setEnabled(false);
            return;
        }
        this.m_addButton.setEnabled(!this.m_editorField.getText().equals(""));
    }

    private final void updateRemoveEnablement() {
        if (!this.isEnabled()) {
            this.m_removeButton.setEnabled(false);
            return;
        }
        this.m_removeButton.setEnabled(this.m_list != null && this.m_list.getSelectedValue() != null);
    }

    private final class EntryValidator {
        private Pattern m_re;
        private Component m_component;
        private String m_error;
        private String m_errorTitle;

        private EntryValidator(Pattern re, Component comp, String error) {
            this(re, comp, error, "");
        }

        private EntryValidator(Pattern re, Component comp, String error, String title) {
            this.m_re = re;
            this.m_component = comp;
            this.m_error = error;
            this.m_errorTitle = title;
        }

        private String getTitle() {
            return this.m_errorTitle;
        }

        private Pattern getRE() {
            return this.m_re;
        }

        private Component getComponent() {
            return this.m_component;
        }

        private String getError() {
            return this.m_error;
        }
    }
}

