/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs.client;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CVSMethodSpecifier {
    private final String _methodSpec;
    private String _method;
    private Map _fieldMap;
    private String _delimiters;

    private CVSMethodSpecifier(String methodSpec, String method, Map fieldMap, String delimiters) {
        this._methodSpec = methodSpec;
        this._method = method;
        this._fieldMap = fieldMap;
        this._delimiters = delimiters;
    }

    public String getMethod() {
        return this._method;
    }

    public Map getFieldMap() {
        return this._fieldMap;
    }

    public String getDelimiters() {
        return this._delimiters;
    }

    public boolean equals(Object other) {
        return other instanceof CVSMethodSpecifier && ((CVSMethodSpecifier)other)._methodSpec.equals(this._methodSpec);
    }

    public String toString() {
        return this._methodSpec;
    }

    public static final CVSMethodSpecifier parseMethodSpec(String methodSpec) {
        Pattern pattern = Pattern.compile("(\\w+)([#;].*)");
        Matcher matcher = pattern.matcher(methodSpec);
        if (!matcher.matches()) {
            return new CVSMethodSpecifier(methodSpec, methodSpec, null, null);
        }
        String method = matcher.group(1);
        StringBuilder delimitersBuffer = new StringBuilder();
        LinkedHashMap<String, String> fieldMap = new LinkedHashMap<String, String>();
        pattern = Pattern.compile("^'([^']+)'$");
        StringTokenizer tokenizer = new StringTokenizer(matcher.group(2), "#;", true);
        while (tokenizer.hasMoreTokens()) {
            delimitersBuffer.append(tokenizer.nextToken().charAt(0));
            if (!tokenizer.hasMoreTokens()) break;
            String s = tokenizer.nextToken();
            int i = s.indexOf(61);
            if (i <= 0) continue;
            String keyword = s.substring(0, i);
            String value = i < s.length() - 1 ? s.substring(i + 1) : "";
            matcher = pattern.matcher(value);
            if (matcher.matches()) {
                value = matcher.group(1);
            }
            fieldMap.put(keyword.toLowerCase(), value);
        }
        String delimiters = delimitersBuffer.toString();
        return new CVSMethodSpecifier(methodSpec, method, fieldMap, delimiters);
    }

    public static final CVSMethodSpecifier createMethodSpec(String method, Map fieldMap, String delimiters) {
        if (fieldMap == null || delimiters == null) {
            return new CVSMethodSpecifier(method, method, null, null);
        }
        StringBuilder methodSpecBuffer = new StringBuilder();
        methodSpecBuffer.append(method);
        Pattern pattern = Pattern.compile("^'([^']+)'$");
        int i = 0;
        for (String keyword : fieldMap.keySet()) {
            Matcher matcher;
            String value = (String)fieldMap.get(keyword);
            char delim = i < delimiters.length() ? delimiters.charAt(i++) : delimiters.charAt(delimiters.length() - 1);
            methodSpecBuffer.append(delim);
            methodSpecBuffer.append(keyword.toLowerCase());
            methodSpecBuffer.append('=');
            if (value.matches(".*[:/].*") && !(matcher = pattern.matcher(value)).matches()) {
                value = '\'' + value + '\'';
            }
            methodSpecBuffer.append(value);
        }
        String methodSpec = methodSpecBuffer.toString();
        return new CVSMethodSpecifier(methodSpec, method, fieldMap, delimiters);
    }
}

