/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.history.HistoryEntry;
import oracle.jdeveloper.history.RestoreFromRevisionClass;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.changeset.ChangeSetManager;
import oracle.jdeveloper.vcs.spi.VCSFileEventSender;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSRestorable;
import oracle.jdevimpl.vcs.cvs.util.log.CVSLogReadWorker;
import oracle.jdevimpl.vcs.cvs.util.revision.CVSRevisionInfo;
import oracle.jdevimpl.vcs.cvs.util.revision.CVSRevisionUtils;

public class CVSRestoreFromRevisionClass
extends RestoreFromRevisionClass {
    private Map<URL, String> _rstFiles = new HashMap<URL, String>();
    private Integer _restoreSpan;

    public boolean canRestore(URL[] urls, String revision, HistoryEntry entry) throws Exception {
        this._rstFiles.clear();
        for (URL url : urls) {
            if (url.equals(((CVSRestorable)entry).getOwner())) {
                this._rstFiles.put(url, revision);
                continue;
            }
            Date date = (Date)entry.getValue(SharedProperties.getDateProperty());
            String correctRev = this.getRevision(url, date);
            if (correctRev == null) {
                return false;
            }
            this._rstFiles.put(url, correctRev);
        }
        return true;
    }

    public boolean restore(URL[] urls, String revision, HistoryEntry entry) throws Exception {
        if (this._rstFiles.isEmpty()) {
            this.canRestore(urls, revision, entry);
            if (this._rstFiles.isEmpty()) {
                return false;
            }
        }
        for (URL url : this._rstFiles.keySet()) {
            CVSRevisionInfo info;
            try {
                info = CVSRevisionUtils.downloadContents(url, this._rstFiles.get(url), null, true);
            }
            catch (IllegalStateException e) {
                return false;
            }
            if (info.getContents().length == 0) {
                return false;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(info.getContents());
            URLFileSystem.copy((InputStream)is, (URL)url);
        }
        this.clearCache(urls);
        return true;
    }

    private void clearCache(URL[] urls) {
        VCSFileEventSender.fireFileStructureChanged((URL[])urls);
        CVSClient.getInstance();
        CVSClient.getStatusCache().clear(urls, Depth.INFINITY);
        ChangeSetManager.getChangeSetManager().fireChangesCommitted("oracle.jdeveloper.cvs", urls, true);
    }

    private String getRevision(URL url, Date date) throws Exception {
        HistoryEntry[] entries;
        CVSLogReadWorker worker = new CVSLogReadWorker(url);
        for (HistoryEntry entry : entries = worker.getEntries()) {
            Date enDate = (Date)entry.getValue(SharedProperties.getDateProperty());
            if (date.getTime() - (long)this.getTimeSpan() > enDate.getTime() || date.getTime() + (long)this.getTimeSpan() < enDate.getTime()) continue;
            return ((RevisionIdentifier)entry.getValue(SharedProperties.getRevisionProperty())).getLabel();
        }
        return null;
    }

    private int getTimeSpan() {
        if (this._restoreSpan == null) {
            String cvsSpan = System.getProperty("vcs-cvs.restore.millseconds", "1000");
            try {
                this._restoreSpan = new Integer(cvsSpan);
            }
            catch (Exception ex) {
                this._restoreSpan = new Integer(1000);
            }
        }
        return this._restoreSpan;
    }
}

