/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.spi.VCSQuickDiffReferenceProvider;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSEntriesCache;
import oracle.jdevimpl.vcs.cvs.client.CVSEntry;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.util.revision.CVSRevisionInfo;
import oracle.jdevimpl.vcs.cvs.util.revision.CVSRevisionUtils;

class CVSQuickDiffReferenceProvider
extends VCSQuickDiffReferenceProvider {
    private static final String ID = "BaseCVSRevision";

    CVSQuickDiffReferenceProvider() {
        super(CVSClient.getExtension());
    }

    public String getID() {
        return ID;
    }

    public String getName() {
        return CVSArb.get("BASE_CVS_REVISION");
    }

    public InputStream openInputStream(URL url) throws IOException {
        if (!URLFileSystem.exists((URL)url)) {
            return null;
        }
        CVSEntry entry = CVSEntriesCache.findEntry(CVSEntriesCache.getInstance().getEntriesMap(URLFileSystem.getParent((URL)url)), url);
        if (entry == null || entry.getRevision() == null) {
            return null;
        }
        try {
            CVSRevisionInfo info = CVSRevisionUtils.downloadContents(url, entry.getRevision(), null, true);
            return info != null && info.getContents() != null ? new ByteArrayInputStream(info.getContents()) : null;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

