/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import oracle.ide.util.Assert;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.vcs.util.VCSOperatingSystem;
import oracle.jdevimpl.vcs.cvs.CVSClientInfo;
import oracle.jdevimpl.vcs.cvs.CVSClientVerification;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;

public class CVSPrefs
extends HashStructureAdapter {
    private static final String DATA_KEY = "oracle.jdevimpl.vcs.cvs.CVSPrefs";
    static final String CVS_EXTERNAL_CLIENT = "cvsExternalClient";
    private static Boolean DEFAULT_CVS_EXTERNAL_CLIENT = null;
    static final String CVS_PATH = "cvsPath";
    static final String DEFAULT_CVS_PATH = "cvs";
    private static final String OVERLAY_SCHEME = "overlayScheme";
    private static final String DEFAULT_OVERLAY_SCHEME = CVSFileStatus.Scheme.JDEVELOPER.name();
    private static final String RUN_IN_EDIT_MODE = "runInEditMode";
    private static final boolean DEFAULT_RUN_IN_EDIT_MODE = false;

    private CVSPrefs(HashStructure hash) {
        super(hash);
    }

    public static CVSPrefs getInstance(PropertyStorage prefs) {
        return new CVSPrefs(CVSPrefs.findOrCreate((PropertyStorage)prefs, (String)DATA_KEY));
    }

    public boolean getCVSExternalClient() {
        CVSPrefs.computeDefaultExternalClient();
        return this._hash.getBoolean(CVS_EXTERNAL_CLIENT, DEFAULT_CVS_EXTERNAL_CLIENT.booleanValue());
    }

    public void setCVSExternalClient(boolean cvsExternalClient) {
        this._hash.putBoolean(CVS_EXTERNAL_CLIENT, cvsExternalClient);
    }

    private static synchronized void computeDefaultExternalClient() {
        if (DEFAULT_CVS_EXTERNAL_CLIENT == null) {
            DEFAULT_CVS_EXTERNAL_CLIENT = false;
            CVSClientInfo clientInfo = null;
            try {
                clientInfo = CVSClientVerification.verifyExecutableVersion(DEFAULT_CVS_PATH);
                DEFAULT_CVS_EXTERNAL_CLIENT = clientInfo != null && (clientInfo.isCVSNT() || !VCSOperatingSystem.isWindows());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (DEFAULT_CVS_EXTERNAL_CLIENT == Boolean.FALSE) {
                Assert.printHeader((String)"  CVS: internal client");
            } else {
                Assert.printHeader((String)("  CVS: " + clientInfo.getVersionInfoString()));
            }
        }
    }

    public String getCVSPath() {
        return this._hash.getString(CVS_PATH, DEFAULT_CVS_PATH);
    }

    public void setCVSPath(String cvsPath) {
        this._hash.putString(CVS_PATH, cvsPath);
    }

    public String getOverlayScheme() {
        return this._hash.getString(OVERLAY_SCHEME, DEFAULT_OVERLAY_SCHEME);
    }

    public void setOverlayScheme(String overlayScheme) {
        this._hash.putString(OVERLAY_SCHEME, overlayScheme);
    }

    public boolean getRunInEditMode() {
        return this._hash.getBoolean(RUN_IN_EDIT_MODE, false);
    }

    public void setRunInEditMode(boolean runInEditMode) {
        this._hash.putBoolean(RUN_IN_EDIT_MODE, runInEditMode);
    }
}

