/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import oracle.ide.config.FileTypesRecognizer;
import oracle.ide.model.ContentType;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.cache.Depth;
import oracle.jdeveloper.vcs.util.VCSProcessUtils;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSInternalClientSupport;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcess;
import oracle.jdevimpl.vcs.cvs.runner.CVSProcessStreamMonitor;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunner;
import oracle.jdevimpl.vcs.cvs.runner.CVSRunnerFactory;

public class CVSFileSystemAPI {
    private CVSFileSystemAPI() {
    }

    public static final boolean executeRemoveDirectory(URL dirUrl) throws Exception {
        try {
            boolean bl = CVSFileSystemAPI.executeRemoveImpl(dirUrl, null);
            return bl;
        }
        finally {
            CVSFileSystemAPI.directoryFileStateChanged(dirUrl);
        }
    }

    public static final boolean executeRemoveRegularFile(URL regularFileUrl) throws Exception {
        boolean bl;
        File regularFile = new File(URLFileSystem.getPlatformPathName((URL)regularFileUrl));
        if (regularFile.exists() && !regularFile.delete()) {
            return false;
        }
        try {
            bl = CVSFileSystemAPI.executeRemoveImpl(URLFileSystem.getParent((URL)regularFileUrl), URLFileSystem.getFileName((URL)regularFileUrl));
        }
        catch (Throwable throwable) {
            CVSFileSystemAPI.regularFileStateChanged(regularFileUrl);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CVSClient.invokePendingChanges();
                }
            });
            throw throwable;
        }
        CVSFileSystemAPI.regularFileStateChanged(regularFileUrl);
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
        return bl;
    }

    public static final boolean executeRemoveImpl(URL dirUrl, String fileName) throws Exception {
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.setDirURL_(dirUrl);
        runner.setCommand_("remove");
        runner.getParameters().setFile(fileName);
        runner.getParameters().setQuiet(false);
        runner.exec_();
        return runner.getExitCode_() != null && runner.getExitCode_() == 0;
    }

    public static final boolean executeCommitDirectory(URL dirUrl) throws Exception {
        try {
            boolean bl = CVSFileSystemAPI.executeCommitImpl(dirUrl, null);
            return bl;
        }
        finally {
            CVSFileSystemAPI.directoryFileStateChanged(dirUrl);
        }
    }

    public static final boolean executeCommitRegularFile(URL regularFileUrl) throws Exception {
        try {
            boolean bl = CVSFileSystemAPI.executeCommitImpl(URLFileSystem.getParent((URL)regularFileUrl), URLFileSystem.getFileName((URL)regularFileUrl));
            return bl;
        }
        finally {
            CVSFileSystemAPI.regularFileStateChanged(regularFileUrl);
        }
    }

    public static final boolean executeCommitImpl(URL dirUrl, String fileName) throws Exception {
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.setDirURL_(dirUrl);
        runner.setCommand_("commit");
        runner.getParameters().setOptions(Arrays.asList("-m", "*** empty log message ***"));
        runner.getParameters().setFile(fileName);
        runner.getParameters().setQuiet(false);
        runner.exec_();
        return runner.getExitCode_() != null && runner.getExitCode_() == 0;
    }

    public static final boolean executeReleaseDirectory(URL dirUrl) throws Exception {
        try {
            boolean bl = CVSFileSystemAPI.executeReleaseImpl(dirUrl, ".");
            return bl;
        }
        finally {
            CVSFileSystemAPI.directoryFileStateChanged(dirUrl);
        }
    }

    public static final boolean executeReleaseImpl(URL dirUrl, String fileName) throws Exception {
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.setDirURL_(dirUrl);
        runner.setCommand_("release");
        runner.getParameters().setOptions(Collections.singleton("-d"));
        runner.getParameters().setFile(fileName);
        runner.getParameters().setQuiet(false);
        runner.addOutputMonitor(new CVSProcessStreamMonitor("Are you sure"){

            @Override
            protected final void patternMatched(CVSProcess process) throws IOException {
                CVSFileSystemAPI.sendProcessInputData(process, "y");
            }
        });
        runner.exec_();
        return runner.getExitCode_() != null && runner.getExitCode_() == 0;
    }

    public static final boolean executeAddDirectory(URL url) throws Exception {
        try {
            boolean bl = CVSFileSystemAPI.executeAddImpl(URLFileSystem.getParent((URL)url), URLFileSystem.getFileName((URL)url), null);
            return bl;
        }
        finally {
            CVSFileSystemAPI.directoryFileStateChanged(url);
        }
    }

    public static final boolean executeAddRegularFile(URL url) throws Exception {
        boolean bl;
        try {
            bl = CVSFileSystemAPI.executeAddImpl(URLFileSystem.getParent((URL)url), URLFileSystem.getFileName((URL)url), FileTypesRecognizer.getNonNullContentTypeForExtension((String)URLFileSystem.getSuffix((URL)url)));
        }
        catch (Throwable throwable) {
            CVSFileSystemAPI.regularFileStateChanged(url);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CVSClient.invokePendingChanges();
                }
            });
            throw throwable;
        }
        CVSFileSystemAPI.regularFileStateChanged(url);
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
        return bl;
    }

    public static final boolean executeAddImpl(URL dirUrl, String fileName, ContentType contentType) throws Exception {
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        Collection<Object> options = Collections.EMPTY_SET;
        if (contentType == ContentType.BINARY) {
            options = Arrays.asList("-k", "b");
        }
        if (contentType == ContentType.TEXT) {
            String kOption = CVSUtil.getKeywordSubtitutionOption();
            options = kOption != null ? Collections.singleton("-k" + kOption) : Collections.EMPTY_SET;
        }
        runner.setDirURL_(dirUrl);
        runner.setCommand_("add");
        runner.getParameters().setOptions(options);
        runner.getParameters().setFile(fileName);
        runner.getParameters().setQuiet(false);
        runner.exec_();
        return runner.getExitCode_() != null && runner.getExitCode_() == 0;
    }

    public static final boolean executeEditRegularFile(URL regularFileUrl) throws Exception {
        try {
            boolean bl = CVSFileSystemAPI.executeEditImpl(URLFileSystem.getParent((URL)regularFileUrl), URLFileSystem.getFileName((URL)regularFileUrl));
            return bl;
        }
        finally {
            CVSFileSystemAPI.regularFileStateChanged(regularFileUrl);
        }
    }

    public static final boolean executeEditImpl(URL dirUrl, String fileName) throws Exception {
        if (CVSClient.getInstance().isUsingInternalClient() && !CVSInternalClientSupport.isSupportedCommand("edit")) {
            return false;
        }
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.setDirURL_(dirUrl);
        runner.setCommand_("edit");
        runner.getParameters().setFile(fileName);
        runner.getParameters().setQuiet(false);
        runner.exec_();
        return runner.getExitCode_() != null && runner.getExitCode_() == 0;
    }

    public static final boolean executeUneditRegularFile(URL regularFileUrl) throws Exception {
        try {
            boolean bl = CVSFileSystemAPI.executeUneditImpl(URLFileSystem.getParent((URL)regularFileUrl), URLFileSystem.getFileName((URL)regularFileUrl));
            return bl;
        }
        finally {
            CVSFileSystemAPI.regularFileStateChanged(regularFileUrl);
        }
    }

    public static final boolean executeUneditImpl(URL dirUrl, String fileName) throws Exception {
        CVSRunner runner = CVSRunnerFactory.getInstance().createRunner();
        runner.setDirURL_(dirUrl);
        runner.setCommand_("unedit");
        runner.getParameters().setOptions(Collections.singleton("-l"));
        runner.getParameters().setFile(fileName);
        runner.getParameters().setQuiet(false);
        runner.addOutputMonitor(new CVSProcessStreamMonitor("revert changes?"){

            @Override
            protected final void patternMatched(CVSProcess process) throws Exception {
                CVSFileSystemAPI.sendProcessInputData(process, "y");
            }
        });
        runner.exec_();
        return runner.getExitCode_() != null && runner.getExitCode_() == 0;
    }

    private static final void directoryFileStateChanged(URL dirUrl) {
        CVSUtil.clearPerformanceCaches();
        CVSClient.getInstance();
        CVSClient.getStatusCache().clear(new URL[]{dirUrl}, Depth.INFINITY);
    }

    private static final void regularFileStateChanged(URL regularFileUrl) {
        CVSUtil.clearPerformanceCaches();
        CVSClient.getInstance();
        CVSClient.getStatusCache().clear(regularFileUrl);
    }

    private static final void sendProcessInputData(CVSProcess process, String inputData) throws IOException {
        process.waitForRedirectOutput();
        VCSProcessUtils.sendInputData((Process)process.getProcess(), (String)inputData);
        process.log(inputData + '\n');
    }
}

