/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import oracle.ide.config.Preferences;
import oracle.ide.controls.SortedComboBoxModel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.spi.VCSPreferencesTraversable;
import oracle.jdevimpl.vcs.cvs.CVSClient;
import oracle.jdevimpl.vcs.cvs.CVSCommandOptionsPrefs;
import oracle.jdevimpl.vcs.cvs.CVSGlobalOptionId;
import oracle.jdevimpl.vcs.cvs.CVSInternalClientSupport;
import oracle.jdevimpl.vcs.cvs.CVSKeywordSubtitutionMode;
import oracle.jdevimpl.vcs.cvs.CVSPrefs;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;

public class CVSCommandOptionsTraversable
extends VCSPreferencesTraversable<CVSCommandOptionsPrefs> {
    private Component _component;
    private JLabel _globalOptionsLabel;
    private JLabel _onCommitLabel;
    private JCheckBox _runQuietlyCheckBox;
    private JCheckBox _doNotLogCommandsCheckBox;
    private JCheckBox _encryptCheckBox;
    private JCheckBox _setCompressionLevelCheckBox;
    private JSlider _compressionLevelSlider;
    private JLabel _keywordSubstitutionLabel;
    private JComboBox _keywordSubstitutionComboBox;
    private boolean _encryptionWarningFlag;
    private JCheckBox _useCommentTemplatesCheckBox;
    private JCheckBox _renameOnRemoveCheckBox;
    private JCheckBox _autoAddOnCommitCheckBox;
    private JCheckBox _showAdvancedControlsCheckBox;
    private boolean _externalClientSelected;

    public CVSCommandOptionsTraversable() {
        this.setHelpID("f1_cvspreferencescommands_html");
    }

    protected CVSCommandOptionsPrefs getPreferences(PropertyStorage prefs) {
        return CVSCommandOptionsPrefs.getInstance(prefs);
    }

    public void onEntry(TraversableContext dataContext) {
        this._externalClientSelected = CVSPrefs.getInstance(dataContext.getPropertyStorage()).getCVSExternalClient();
        super.onEntry(dataContext);
        this.updateSlaveComponentsEnabled();
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        super.onExit(dataContext);
    }

    protected Component getPage() {
        if (this._component == null) {
            this._component = this.createComponent();
        }
        return this._component;
    }

    protected void loadPreferences(CVSCommandOptionsPrefs prefs) {
        CVSKeywordSubtitutionMode keywordSubstitutionValue;
        this._showAdvancedControlsCheckBox.setSelected(prefs.getAdvancedMode());
        if (this.isGlobalSupported(CVSGlobalOptionId.Q_BE_QUIET)) {
            this._runQuietlyCheckBox.setSelected(prefs.getGlobalOptionQ());
        }
        if (this.isGlobalSupported(CVSGlobalOptionId.L_NO_HISTORY_LOGGING)) {
            this._doNotLogCommandsCheckBox.setSelected(prefs.getGlobalOptionL());
        }
        if (this.isGlobalSupported(CVSGlobalOptionId.X_ENCRYPT)) {
            this._encryptCheckBox.setSelected(prefs.getGlobalOptionX());
        }
        if (this.isGlobalSupported(CVSGlobalOptionId.Z_GZIP_LEVEL)) {
            this._setCompressionLevelCheckBox.setSelected(prefs.getGlobalOptionZ());
        }
        if (this.isGlobalSupported(CVSGlobalOptionId.Z_GZIP_LEVEL)) {
            this._compressionLevelSlider.setValue(prefs.getGlobalOptionZLevel());
        }
        if ((keywordSubstitutionValue = CVSKeywordSubtitutionMode.valueOf(prefs.getKeywordSubstitutionMode())) != null) {
            this._keywordSubstitutionComboBox.setSelectedItem((Object)keywordSubstitutionValue);
        }
        this.updateSlaveComponentsEnabled();
        this._useCommentTemplatesCheckBox.setSelected(prefs.getUseCommentTemplates());
        this._renameOnRemoveCheckBox.setSelected(prefs.getRenameOnRemove());
        this._autoAddOnCommitCheckBox.setSelected(prefs.getAutoAddOnCommit());
    }

    protected void savePreferences(CVSCommandOptionsPrefs prefs) {
        prefs.setAdvancedMode(this._showAdvancedControlsCheckBox.isSelected());
        prefs.setGlobalOptionQ(this.isGlobalSupported(CVSGlobalOptionId.Q_BE_QUIET) && this._runQuietlyCheckBox.isSelected());
        prefs.setGlobalOptionL(this.isGlobalSupported(CVSGlobalOptionId.L_NO_HISTORY_LOGGING) && this._doNotLogCommandsCheckBox.isSelected());
        prefs.setGlobalOptionX(this.isGlobalSupported(CVSGlobalOptionId.X_ENCRYPT) && this._encryptCheckBox.isSelected());
        prefs.setGlobalOptionZ(this.isGlobalSupported(CVSGlobalOptionId.Z_SET_GZIP_LEVEL) && this._setCompressionLevelCheckBox.isSelected());
        prefs.setGlobalOptionZLevel(this._compressionLevelSlider.getValue());
        prefs.setKeywordSubstitutionMode(((CVSKeywordSubtitutionMode)((Object)this._keywordSubstitutionComboBox.getSelectedItem())).name());
        prefs.setUseCommentTemplates(this._useCommentTemplatesCheckBox.isSelected());
        prefs.setRenameOnRemove(this._renameOnRemoveCheckBox.isSelected());
        prefs.setAutoAddOnCommit(this._autoAddOnCommitCheckBox.isSelected());
    }

    protected void validatePreferences() throws TraversalException {
    }

    public static final Map createGlobalOptionsMap(CVSClient client) {
        CVSCommandOptionsPrefs prefs = CVSCommandOptionsPrefs.getInstance((PropertyStorage)Preferences.getPreferences());
        HashMap<CVSGlobalOptionId, Comparable<Boolean>> globalOptionsMap = new HashMap<CVSGlobalOptionId, Comparable<Boolean>>();
        globalOptionsMap.put(CVSGlobalOptionId.L_NO_HISTORY_LOGGING, Boolean.valueOf(prefs.getGlobalOptionL()));
        globalOptionsMap.put(CVSGlobalOptionId.Q_BE_QUIET, Boolean.valueOf(prefs.getGlobalOptionQ()));
        globalOptionsMap.put(CVSGlobalOptionId.X_ENCRYPT, Boolean.valueOf(prefs.getGlobalOptionX()));
        globalOptionsMap.put(CVSGlobalOptionId.Z_SET_GZIP_LEVEL, Boolean.valueOf(prefs.getGlobalOptionZ()));
        globalOptionsMap.put(CVSGlobalOptionId.Z_GZIP_LEVEL, Integer.valueOf(prefs.getGlobalOptionZLevel()));
        globalOptionsMap.put(CVSGlobalOptionId.R_MAKE_NEW_FILES_READ_ONLY, Boolean.valueOf(client.isPreferenceReadOnlyModeSet()));
        return globalOptionsMap;
    }

    private Component createComponent() {
        boolean sliderMin = true;
        int sliderMax = 9;
        this._globalOptionsLabel = new JLabel();
        this._onCommitLabel = new JLabel();
        this._runQuietlyCheckBox = new JCheckBox();
        this._doNotLogCommandsCheckBox = new JCheckBox();
        this._encryptCheckBox = new JCheckBox();
        this._setCompressionLevelCheckBox = new JCheckBox();
        this._compressionLevelSlider = new JSlider(1, 9, 9);
        this._keywordSubstitutionLabel = new JLabel();
        this._keywordSubstitutionComboBox = new JComboBox();
        this._useCommentTemplatesCheckBox = new JCheckBox();
        this._renameOnRemoveCheckBox = new JCheckBox();
        this._autoAddOnCommitCheckBox = new JCheckBox();
        this._showAdvancedControlsCheckBox = new JCheckBox();
        JPanel panel = new JPanel();
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        Insets i = new Insets(2, 2, 2, 2);
        layoutBuilder.add((Component)this._showAdvancedControlsCheckBox, i, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap();
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._globalOptionsLabel, i, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._runQuietlyCheckBox, i, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._doNotLogCommandsCheckBox, i, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._encryptCheckBox, i, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._setCompressionLevelCheckBox, i, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._compressionLevelSlider, i, 1, false, false);
        layoutBuilder.addHFiller();
        layoutBuilder.nl();
        layoutBuilder.addVGap();
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._keywordSubstitutionLabel, i, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._keywordSubstitutionComboBox, i, 2, false, false);
        layoutBuilder.addHFiller();
        layoutBuilder.nl();
        layoutBuilder.addVGap();
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._onCommitLabel, i, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._useCommentTemplatesCheckBox, i, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._autoAddOnCommitCheckBox, i, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addVGap();
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._renameOnRemoveCheckBox, i, 4, false, true);
        layoutBuilder.nl();
        layoutBuilder.addToPanel((Container)panel);
        Hashtable<Integer, JLabel> tableLabels = new Hashtable<Integer, JLabel>(2);
        tableLabels.put(new Integer(1), new JLabel(CVSArb.get("MINIMUM")));
        tableLabels.put(new Integer(9), new JLabel(CVSArb.get("MAXIMUM")));
        this._compressionLevelSlider.setPaintLabels(true);
        this._compressionLevelSlider.setPaintTicks(true);
        this._compressionLevelSlider.setMajorTickSpacing(8);
        this._compressionLevelSlider.setMinorTickSpacing(1);
        this._compressionLevelSlider.setSnapToTicks(true);
        this._compressionLevelSlider.setLabelTable(tableLabels);
        SortedComboBoxModel keywordSubstitutionComboBoxModel = new SortedComboBoxModel();
        keywordSubstitutionComboBoxModel.setComparator(new Comparator(){

            public final int compare(Object o1, Object o2) {
                o1 = CVSCommandOptionsTraversable.this.convertKeywordSubstitutionToRenderedValue(o1);
                o2 = CVSCommandOptionsTraversable.this.convertKeywordSubstitutionToRenderedValue(o2);
                return o1.toString().compareTo(o2.toString());
            }
        });
        keywordSubstitutionComboBoxModel.addElement((Object)CVSKeywordSubtitutionMode.AUTOMATIC);
        keywordSubstitutionComboBoxModel.addElement((Object)CVSKeywordSubtitutionMode.KEYWORD_ONLY);
        keywordSubstitutionComboBoxModel.addElement((Object)CVSKeywordSubtitutionMode.KEYWORD_VALUE);
        keywordSubstitutionComboBoxModel.addElement((Object)CVSKeywordSubtitutionMode.KEYWORD_VALUE_LOCKER);
        keywordSubstitutionComboBoxModel.addElement((Object)CVSKeywordSubtitutionMode.OLD_CONTENTS);
        keywordSubstitutionComboBoxModel.addElement((Object)CVSKeywordSubtitutionMode.VALUE_ONLY);
        this._keywordSubstitutionComboBox.setModel(keywordSubstitutionComboBoxModel);
        this._keywordSubstitutionComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public final Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                value = CVSCommandOptionsTraversable.this.convertKeywordSubstitutionToRenderedValue(value);
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        this._keywordSubstitutionComboBox.setSelectedItem((Object)CVSKeywordSubtitutionMode.AUTOMATIC);
        ResourceUtils.resLabel((JLabel)this._globalOptionsLabel, (Component)this._globalOptionsLabel, (String)CVSArb.get("GLOBAL_OPTIONS"));
        ResourceUtils.resLabel((JLabel)this._onCommitLabel, (Component)this._onCommitLabel, (String)CVSArb.get("ON_COMMIT"));
        ResourceUtils.resButton((AbstractButton)this._runQuietlyCheckBox, (String)CVSArb.get("RUN_QUIETLY"));
        ResourceUtils.resButton((AbstractButton)this._doNotLogCommandsCheckBox, (String)CVSArb.get("DO_NOT_LOG_COMMANDS"));
        ResourceUtils.resButton((AbstractButton)this._encryptCheckBox, (String)CVSArb.get("ENCRYPT"));
        ResourceUtils.resButton((AbstractButton)this._setCompressionLevelCheckBox, (String)CVSArb.get("SET_COMPRESSION_LEVEL"));
        ResourceUtils.resButton((AbstractButton)this._useCommentTemplatesCheckBox, (String)CVSArb.get("USE_COMMENT_TEMPLATES"));
        ResourceUtils.resButton((AbstractButton)this._renameOnRemoveCheckBox, (String)CVSArb.get("RENAME_ON_REMOVE"));
        ResourceUtils.resButton((AbstractButton)this._autoAddOnCommitCheckBox, (String)CVSArb.get("AUTOMATICALLY_ADD_FILES"));
        ResourceUtils.resButton((AbstractButton)this._showAdvancedControlsCheckBox, (String)CVSArb.get("COMMANDS_SHOW_ADVANCED_CONTROLS"));
        ResourceUtils.resLabel((JLabel)this._keywordSubstitutionLabel, (Component)this._keywordSubstitutionComboBox, (String)CVSArb.get("KEYWORD_SUBSTITUTION"));
        this._encryptCheckBox.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                if (!CVSCommandOptionsTraversable.this._encryptCheckBox.isSelected()) {
                    return;
                }
                if (CVSCommandOptionsTraversable.this._encryptionWarningFlag) {
                    return;
                }
                MessageDialog.information((Component)CVSCommandOptionsTraversable.this._component, (Object)CVSArb.get("ENCYPTION_WARNING"), (String)CVSArb.get("ENCYPTION_WARNING_TITLE"), null);
                CVSCommandOptionsTraversable.this._encryptionWarningFlag = true;
            }
        });
        this._setCompressionLevelCheckBox.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                CVSCommandOptionsTraversable.this.updateSlaveComponentsEnabled();
            }
        });
        this.updateSlaveComponentsEnabled();
        this._showAdvancedControlsCheckBox.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                if (CVSCommandOptionsTraversable.this._showAdvancedControlsCheckBox.isSelected() && !MessageDialog.optionalConfirm((String)"CVS.AdvancedControlsModeConfirm", null, (Object)CVSArb.get("ADVANCED_CONTROLS"), (String)CVSArb.get("ADVANCED_CONTROLS_TITLE"), null)) {
                    CVSCommandOptionsTraversable.this._showAdvancedControlsCheckBox.setSelected(false);
                }
            }
        });
        return panel;
    }

    private String convertKeywordSubstitutionToRenderedValue(Object o) {
        if (o == null) {
            return null;
        }
        if (o == CVSKeywordSubtitutionMode.AUTOMATIC) {
            o = CVSArb.get("AUTOMATIC");
        }
        if (o == CVSKeywordSubtitutionMode.KEYWORD_ONLY) {
            o = CVSArb.get("KEYWORD_ONLY");
        }
        if (o == CVSKeywordSubtitutionMode.KEYWORD_VALUE) {
            o = CVSArb.get("KEYWORD_VALUE");
        }
        if (o == CVSKeywordSubtitutionMode.KEYWORD_VALUE_LOCKER) {
            o = CVSArb.get("KEYWORD_VALUE_LOCKER");
        }
        if (o == CVSKeywordSubtitutionMode.OLD_CONTENTS) {
            o = CVSArb.get("OLD_CONTENTS");
        }
        if (o == CVSKeywordSubtitutionMode.VALUE_ONLY) {
            o = CVSArb.get("VALUE_ONLY");
        }
        return o.toString();
    }

    private void updateSlaveComponentsEnabled() {
        this.updateGlobalOptionComponentEnabled(this._runQuietlyCheckBox, CVSGlobalOptionId.Q_BE_QUIET);
        this.updateGlobalOptionComponentEnabled(this._doNotLogCommandsCheckBox, CVSGlobalOptionId.L_NO_HISTORY_LOGGING);
        this.updateGlobalOptionComponentEnabled(this._encryptCheckBox, CVSGlobalOptionId.X_ENCRYPT);
        this.updateGlobalOptionComponentEnabled(this._setCompressionLevelCheckBox, CVSGlobalOptionId.Z_SET_GZIP_LEVEL);
        this._compressionLevelSlider.setEnabled(this._setCompressionLevelCheckBox.isEnabled() && this._setCompressionLevelCheckBox.isSelected());
    }

    private void updateGlobalOptionComponentEnabled(AbstractButton component, CVSGlobalOptionId id) {
        component.setEnabled(this.isGlobalSupported(id));
        if (!component.isEnabled()) {
            component.setSelected(false);
        }
    }

    private boolean isGlobalSupported(CVSGlobalOptionId id) {
        return this._externalClientSelected || CVSInternalClientSupport.isSupportedGlobalOption(id);
    }
}

