/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.cvs;

import java.awt.Component;
import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.ide.ProductInformation;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.layout.ViewId;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPrintWriter;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.vcs.VCS;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.changelist.ChangeListCommentsCustomizer;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdeveloper.vcs.nav.VersioningNavigatorConstants;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSDockableViewRegistry;
import oracle.jdeveloper.vcs.spi.VCSExceptionHandler;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSRecentCommentsModel;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSIdeEventRecorder;
import oracle.jdeveloper.vcs.util.VCSOperatingSystem;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.VCSManagerImpl;
import oracle.jdevimpl.vcs.cvs.CVSActiveClient;
import oracle.jdevimpl.vcs.cvs.CVSChangeListWindow;
import oracle.jdevimpl.vcs.cvs.CVSClientInfo;
import oracle.jdevimpl.vcs.cvs.CVSClientVerification;
import oracle.jdevimpl.vcs.cvs.CVSCommandConstants;
import oracle.jdevimpl.vcs.cvs.CVSCommandOptionsPrefs;
import oracle.jdevimpl.vcs.cvs.CVSController;
import oracle.jdevimpl.vcs.cvs.CVSFileStatus;
import oracle.jdevimpl.vcs.cvs.CVSOverlayItemProducer;
import oracle.jdevimpl.vcs.cvs.CVSPrefs;
import oracle.jdevimpl.vcs.cvs.CVSStatusCache;
import oracle.jdevimpl.vcs.cvs.CVSUtil;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodeUtils;
import oracle.jdevimpl.vcs.cvs.nav.CVSConnectionNodes;
import oracle.jdevimpl.vcs.cvs.resource.CVSArb;
import oracle.jdevimpl.vcs.cvs.util.CVSAdminPropertyKey;
import oracle.jdevimpl.vcs.cvs.util.CVSMessageDialog;

public class CVSClient
implements CVSCommandConstants,
CVSAdminPropertyKey {
    public static final String CVS_EXTENSION_ID = "oracle.jdeveloper.cvs";
    public static final String CHANGE_LIST_ID = ViewId.validate((String)"CVS.PendingChangesWindow");
    private static boolean _offeredInheritedConnection;
    private boolean _clientStateVerified;
    private boolean _executableInstalled;
    private LogPrintWriter _logWriter;
    private VCSOptionsCustomizer _changeListCustomizer;
    private CVSOverlayItemProducer _changeListOverlayItemProducer;
    private VCSRecentCommentsModel _recentCommentsModel;
    private Collection<Component> _advancedMenuItems;
    private static CVSClient _instance;
    private Controller _controller;

    public static final synchronized CVSClient getInstance() {
        if (_instance == null) {
            _instance = new CVSClient();
        }
        return _instance;
    }

    public final synchronized Controller getController() {
        if (this._controller == null) {
            this._controller = new CVSController();
        }
        return this._controller;
    }

    final synchronized Collection<Component> getAdvancedMenuItems() {
        if (this._advancedMenuItems == null) {
            this._advancedMenuItems = new ArrayList<Component>();
        }
        return this._advancedMenuItems;
    }

    void updateOverlayScheme() {
        String overlayScheme = CVSPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).getOverlayScheme();
        CVSFileStatus.setScheme(CVSFileStatus.Scheme.valueOf(overlayScheme));
    }

    void updateControlsForAdvancedMode() {
        if (this.getAdvancedMenuItems().isEmpty()) {
            return;
        }
        boolean visible = CVSClient.getInstance().isAdvancedModeSet();
        Iterator<Component> itr = this.getAdvancedMenuItems().iterator();
        while (itr.hasNext()) {
            itr.next().setVisible(visible);
        }
    }

    public static final VCSProfile getProfile() {
        return VCSProfileRegistry.getInstance().getProfile(CVS_EXTENSION_ID);
    }

    public static final VCSExtension getExtension() {
        return CVSClient.getProfile();
    }

    public final VCSExceptionHandler getExceptionHandler() {
        return CVSClient.getExtension().getExceptionHandler();
    }

    public final boolean isControlled(URL url) {
        return CVSClient.getExtension().isControlled(url);
    }

    public final String getId() {
        return CVS_EXTENSION_ID;
    }

    public URLFilter getURLFilter() {
        return CVSClient.getProfile().getURLFilter("oracle.jdeveloper.vcs.filters.url.DEFAULT");
    }

    public boolean isAdvancedModeSet() {
        return CVSCommandOptionsPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).getAdvancedMode();
    }

    public VCSOptionsCustomizer getChangeListOptionsCustomizer() {
        if (this._changeListCustomizer == null) {
            ChangeListCommentsCustomizer changeListCustomizer = new ChangeListCommentsCustomizer(CVS_EXTENSION_ID);
            changeListCustomizer.setRecentCommentsModel(this.getRecentCommentsModel());
            changeListCustomizer.setShowTemplatesAndCommentsCombo(true);
            this._changeListCustomizer = changeListCustomizer;
        }
        return this._changeListCustomizer;
    }

    public LogPrintWriter getLogWriter() {
        if (this._logWriter == null) {
            this._logWriter = new LogPrintWriter(LogManager.getLogManager().getMsgPage());
        }
        return this._logWriter;
    }

    public static StatusCache<VCSStatus> getStatusCache() {
        return CVSClient.getProfile().getPolicyStatusCache();
    }

    public String getExecutablePath() {
        if (this.isUsingInternalClient() && !Boolean.getBoolean("jdev.cvs.enablefork")) {
            return "cvs";
        }
        return CVSPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).getCVSPath();
    }

    public boolean isUsingInternalClient() {
        return !CVSPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).getCVSExternalClient();
    }

    public boolean isPreferenceReadOnlyModeSet() {
        return CVSPrefs.getInstance((PropertyStorage)Preferences.getPreferences()).getRunInEditMode();
    }

    public synchronized boolean isExecutableInstalled() {
        return this._executableInstalled;
    }

    public synchronized boolean isClientStateVerified() {
        return this._clientStateVerified;
    }

    public synchronized boolean isClientAvailable() {
        return this.isUsingInternalClient() || !this.isClientStateVerified() || this.isExecutableInstalled();
    }

    public synchronized void resetClientStateVerification() {
        this._clientStateVerified = false;
        this._executableInstalled = false;
        this.removeVersionComponents();
        CVSActiveClient.setClientInformation(null);
        if (CVSClient.getStatusCache() != null) {
            CVSClient.getStatusCache().clear();
        }
        CVSUtil.clearPerformanceCaches();
    }

    private void removeVersionComponents() {
        Ide.getVersionInfo().removeComponent(CVSArb.get("CVS_ABOUT_TITLE_EXTERNAL"));
        Ide.getVersionInfo().removeComponent(CVSArb.get("CVS_ABOUT_TITLE_INTERNAL"));
    }

    void updateVersionComponents() {
        String versionInfoString;
        this.removeVersionComponents();
        if (this.isUsingInternalClient()) {
            Ide.getVersionInfo().addComponent(CVSArb.get("CVS_ABOUT_TITLE_INTERNAL"), CVSArb.format("CVS_ABOUT_VERSION_INTERNAL", IdeUtil.getProgramName()));
            return;
        }
        CVSClientInfo clientInfo = CVSActiveClient.getClientInformation();
        String string = versionInfoString = clientInfo != null ? clientInfo.getVersionInfoString() : null;
        if (versionInfoString != null) {
            Ide.getVersionInfo().addComponent(CVSArb.get("CVS_ABOUT_TITLE_EXTERNAL"), versionInfoString);
        }
    }

    public void verifyClientState() {
        if (this._clientStateVerified) {
            return;
        }
        this._verifyClientState();
        CVSUtil.clearPerformanceCaches();
    }

    private synchronized void _verifyClientState() {
        try {
            this.removeVersionComponents();
            this.checkVersion();
            this._executableInstalled = true;
            if (this.isUsingInternalClient()) {
                return;
            }
            CVSClientInfo clientInfo = CVSActiveClient.getClientInformation();
            if (this.checkForClientVersionNotSupported(clientInfo)) {
                return;
            }
            this.checkForClientNonCVSNTOnWindows(clientInfo);
        }
        catch (Exception e) {
            if (this.isUsingInternalClient()) {
                return;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                VCSIdeEventRecorder.invokeAfterMainWindowOpened((Runnable)new Runnable(){

                    @Override
                    public final void run() {
                        MessageDialog.error((Component)VCSWindowUtils.getCurrentWindow(), (Object)CVSArb.format("CVS_NOT_INSTALLED", CVSClient.this.getExecutablePath()), (String)CVSArb.get("CVS_NOT_INSTALLED_TITLE"), null);
                    }
                });
            }
        }
        finally {
            this._clientStateVerified = true;
            this.updateVersionComponents();
        }
    }

    private boolean checkForClientVersionNotSupported(CVSClientInfo clientInfo) {
        if (clientInfo != null && clientInfo.isSupported()) {
            return false;
        }
        VCSIdeEventRecorder.invokeAfterMainWindowOpened((Runnable)new Runnable(){

            @Override
            public final void run() {
                MessageDialog.information((Component)VCSWindowUtils.getCurrentWindow(), (Object)CVSArb.format("CVS_NOT_SUPPORTED", ProductInformation.getProductInformation().getShortName(), "1.11"), (String)CVSArb.get("CVS_NOT_SUPPORTED_TITLE"), null);
            }
        });
        return true;
    }

    private boolean checkForClientNonCVSNTOnWindows(CVSClientInfo clientInfo) {
        if (clientInfo == null || clientInfo.isCVSNT() || !VCSOperatingSystem.isWindows()) {
            return false;
        }
        VCSIdeEventRecorder.invokeAfterMainWindowOpened((Runnable)new Runnable(){

            @Override
            public final void run() {
                MessageDialog.optionalInformation((String)"CVS.ClientNonCVSNTOnWindowsInformation", (Component)VCSWindowUtils.getCurrentWindow(), (Object)CVSArb.format("CVS_NONCVSNT_ON_WINDOWS", ProductInformation.getProductInformation().getShortName()), (String)CVSArb.get("CVS_NONCVSNT_ON_WINDOWS_TITLE"), null);
            }
        });
        return true;
    }

    public VCSRecentCommentsModel getRecentCommentsModel() {
        if (this._recentCommentsModel == null) {
            this._recentCommentsModel = new VCSRecentCommentsModel();
        }
        return this._recentCommentsModel;
    }

    public static final boolean createEnvironmentConnection() {
        if (_offeredInheritedConnection) {
            return false;
        }
        _offeredInheritedConnection = true;
        Map details = CVSConnectionNodeUtils.createEnvironmentConnectionDetails();
        if (details == null) {
            return false;
        }
        if (!CVSMessageDialog.confirm((Component)Ide.getMainWindow(), CVSArb.get("CONFIRM_INHERITED_CONNECTION"), CVSArb.get("CONFIRM_INHERITED_CONNECTION_TITLE"), null, true)) {
            return false;
        }
        CVSConnectionNodes.getConnectionListAPI().addConnection(details);
        VCSControlCache.getInstance().fireControlStateChanged(CVS_EXTENSION_ID);
        CVSClient.getInstance();
        CVSClient.getStatusCache().clear();
        CVSConnectionNodes.updateOverlays();
        final IdeAction showNavigatorAction = IdeAction.find((int)VersioningNavigatorConstants.SHOW_NAVIGATOR_CMD_ID);
        if (showNavigatorAction == null) {
            return true;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    showNavigatorAction.performAction();
                }
                catch (Exception e) {
                    Assert.printStackTrace((Throwable)e);
                }
            }
        });
        return true;
    }

    public static final CVSChangeListWindow invokePendingChanges() {
        Assert.checkAWTThread();
        Dockable dockable = DockStation.getDockStation().getDockable(new ViewId(CHANGE_LIST_ID));
        if (dockable == null || !DockStation.getDockStation().isDockableVisible(dockable)) {
            VCSDockableViewRegistry.showDockableView((String)CHANGE_LIST_ID);
        }
        if (dockable == null) {
            dockable = DockStation.getDockStation().getDockable(new ViewId(CHANGE_LIST_ID));
        }
        return (CVSChangeListWindow)dockable;
    }

    CVSOverlayItemProducer getChangeListOverlayItemProducer() {
        if (this._changeListOverlayItemProducer == null) {
            this._changeListOverlayItemProducer = new CVSOverlayItemProducer((StatusCache<VCSStatus>)((CVSStatusCache)CVSClient.getStatusCache()));
        }
        return this._changeListOverlayItemProducer;
    }

    boolean isUsingNavigatorOverlays() {
        return true;
    }

    private final String checkVersion() throws Exception {
        CVSClientInfo clientInfo = CVSClientVerification.verifyExecutableVersion(this.getExecutablePath());
        if (clientInfo == null) {
            clientInfo = new CVSClientInfo();
        }
        CVSActiveClient.setClientInformation(clientInfo);
        return clientInfo.isSupported() ? clientInfo.getResponse() : null;
    }

    public static void _test_ActivateCVS() {
        VCSManagerImpl._test_SelectSystem((VCS)CVSClient.getExtension());
    }
}

