/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.plsql.old.symbol;

import oracle.javatools.parser.plsql.old.PlsqlLexer;
import oracle.javatools.parser.plsql.old.symbol.ExpressionWrapper;
import oracle.javatools.parser.plsql.old.symbol.NameSymbol;
import oracle.javatools.parser.plsql.old.symbol.Nameable;
import oracle.javatools.parser.plsql.old.symbol.PlsqlSymbol;
import oracle.javatools.parser.plsql.old.symbol.PlsqlSymbolFactory;
import oracle.javatools.parser.plsql.old.symbol.Statement;

public class ExpressionSymbol
extends PlsqlSymbol
implements Nameable {
    static final ExpressionSymbol[] EMPTY_ARRAY = new ExpressionSymbol[0];
    static final int verboseValue = 0;
    static final int VERBOSE_RECYCLING = 16;
    static final int VERBOSE_LIST = 4;
    static final int VERBOSE_WRAPPER = 2;
    static final int VERBOSE_BASE = 1;
    public static final int CATEGORY_WRAPPER = 600;
    public static final int CATEGORY_UNKNOWN = -1;
    public static final int CATEGORY_PAREN_WRAPPER = 610;
    public static final int CATEGORY_SQL = 630;
    public static final int CATEGORY_PREFIX_OPERATOR = 711;
    public static final int CATEGORY_POSTFIX_OPERATOR = 714;
    public static final int CATEGORY_INFIX_OPERATOR = 712;
    public static final int CATEGORY_SPECIAL_OPERATOR = 713;
    public static final int CATEGORY_PRIMARY = 750;
    public static final int CATEGORY_ARGUMENTS = 760;
    protected ExpressionSymbol firstOperand = null;
    protected ExpressionSymbol secondOperand = null;
    protected ExpressionSymbol thirdOperand = null;
    private NameSymbol name = null;
    private PlsqlSymbolFactory factory;

    static boolean verboseOutput(int filter) {
        return (0 & filter) == filter;
    }

    public int getCategory() {
        return this.code;
    }

    public int getExactCode() {
        return this.dataValue;
    }

    public ExpressionSymbol getFirstOperand() {
        return this.firstOperand;
    }

    public ExpressionSymbol getSecondOperand() {
        return this.secondOperand;
    }

    public ExpressionSymbol getThirdOperand() {
        return this.thirdOperand;
    }

    ExpressionSymbol(int code, PlsqlSymbolFactory factory) {
        super(code);
        this.factory = factory;
    }

    void addOperand(ExpressionSymbol e) {
        if (e.getCategory() == 600) {
            ExpressionSymbol wrapper = e;
            e = e.getFirstOperand();
            this.recycleExpression(wrapper);
        }
        ExpressionSymbol.verbosePrintln("ESymbol: Adding operand, child: ", e);
        ExpressionSymbol.verbosePrintln("ESymbol:  Parent: ", this);
        if (this.firstOperand == null) {
            this.firstOperand = e;
        } else if (this.secondOperand == null) {
            this.secondOperand = e;
        } else if (this.thirdOperand == null) {
            this.thirdOperand = e;
        } else {
            System.out.println("Too many child expressions");
        }
        e.parent = this;
    }

    void recycleExpression(ExpressionSymbol e) {
        ExpressionWrapper toRecycle = (ExpressionWrapper)e;
        if (ExpressionSymbol.verboseOutput(16)) {
            System.out.println("Recycling expression");
            this.factory.reclaimWrapper(toRecycle);
        }
    }

    @Override
    void doneParsing() {
        if (this.parent instanceof ExpressionSymbol) {
            ((ExpressionSymbol)this.parent).addOperand(this);
        } else if (this.parent instanceof Statement) {
            ((Statement)this.parent).setExpression(this);
        }
    }

    void adjustOffsets() {
        switch (this.getExactCode()) {
            case -1011: 
            case 1011: {
                ExpressionSymbol tmp = this.firstOperand;
                ExpressionSymbol tmp2 = this.secondOperand;
                ExpressionSymbol tmp3 = this.thirdOperand;
                this.firstOperand = null;
                this.secondOperand = null;
                this.thirdOperand = null;
                this.addOperand(tmp3);
                this.addOperand(tmp);
                this.addOperand(tmp2);
                break;
            }
        }
    }

    @Override
    public NameSymbol getName() {
        return this.name;
    }

    @Override
    public void setName(NameSymbol name) {
        this.name = name;
    }

    String verbose() {
        int value = this.getExactCode();
        String token = value == 0 ? "<wrapper>" : PlsqlLexer.tokenToText(value);
        return this.code + "-" + token;
    }

    static void verbosePrintln(String msg, ExpressionSymbol e) {
        if (ExpressionSymbol.verboseOutput(1)) {
            System.out.print(msg);
            System.out.println(e.verbose());
        }
    }
}

