/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.common;

import java.util.Collection;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.common.QuickUnresolvedType;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasAnnotations;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.UnresolvedType;

public abstract class AbstractElement
implements JavaElement,
JavaConstants {
    @Override
    public abstract int getElementKind();

    @Override
    public abstract JavaElement getOwner();

    @Override
    public abstract int getModifiers();

    @Override
    public boolean isSourceElement() {
        return false;
    }

    @Override
    public SourceElement getSourceElement() {
        return null;
    }

    public SourceElement getSourceSymbol() {
        return this.getSourceElement();
    }

    public boolean isPublic() {
        return (this.getModifiers() & 1) != 0;
    }

    public boolean isProtected() {
        return (this.getModifiers() & 4) != 0;
    }

    public boolean isPrivate() {
        return (this.getModifiers() & 2) != 0;
    }

    public boolean isPackagePrivate() {
        return (this.getModifiers() & 7) == 0;
    }

    public boolean isStatic() {
        return (this.getModifiers() & 8) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.getModifiers() & 0x10) != 0;
    }

    public boolean isVarargs() {
        return (this.getModifiers() & 0x80) != 0;
    }

    public boolean isAbstract() {
        return (this.getModifiers() & 0x400) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    public boolean isTransient() {
        return (this.getModifiers() & 0x80) != 0;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    public UnresolvedType getUnresolvedType() {
        return QuickUnresolvedType.EMPTY_UNRESOLVED_TYPE;
    }

    public Collection getDeclaredAnnotations() {
        return kEmptyCollection;
    }

    public Collection getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    public JavaAnnotation getDeclaredAnnotation(JavaType annotationType) {
        return CommonUtilities.getDeclaredAnnotation((JavaHasAnnotations)((Object)this), annotationType);
    }

    public JavaAnnotation getAnnotation(JavaType annotationType) {
        return this.getDeclaredAnnotation(annotationType);
    }

    public boolean hasTypeParameters() {
        return !this.getTypeParameters().isEmpty();
    }

    public Collection getTypeParameters() {
        return kEmptyCollection;
    }

    public boolean hasActualTypeArguments() {
        return !this.getActualTypeArguments().isEmpty();
    }

    public Collection getActualTypeArguments() {
        return kEmptyCollection;
    }

    public void clearCompiledInfo() {
    }

    @Override
    public String printCompiledInfo() {
        return "";
    }
}

