/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.parser.java.v2.classfile;

import oracle.javatools.parser.java.v2.classfile.Convert;

public final class Name {
    static final Name[] EMPTY_ARRAY = new Name[0];
    private byte[] bytes;
    private int hashCode = -1;
    private String string;

    Name(byte[] bytes) {
        this.bytes = bytes;
    }

    public int hashCode() {
        if (this.hashCode < 0) {
            int computeHashCode = 0;
            for (int i = 0; i < this.bytes.length; ++i) {
                computeHashCode = 31 * computeHashCode + this.bytes[i];
            }
            this.hashCode = computeHashCode;
        }
        return this.hashCode;
    }

    public boolean equals(Name other) {
        if (this.bytes.length == other.bytes.length && this.hashCode() == other.hashCode()) {
            for (int x = 0; x < this.bytes.length; ++x) {
                if (this.bytes[x] == other.bytes[x]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof Name) {
            return this.equals((Name)o);
        }
        return super.equals(o);
    }

    public byte[] toUTF() {
        return this.bytes;
    }

    public byte[] toSource() {
        return Convert.string2source(this.toString());
    }

    public String toString() {
        if (this.string == null) {
            this.string = Convert.ascii2string(this.bytes, 0, this.bytes.length);
        }
        return this.string;
    }

    void setString(String s) {
        this.string = s;
    }
}

