/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.util.EnumSet;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.buffer.JdkReadWriteLockImplementation;
import oracle.javatools.buffer.LegacyReadWriteLockImplementation;
import oracle.javatools.buffer.ReadWriteLockImplementation;
import oracle.javatools.buffer.WriteLockRequestListener;
import oracle.javatools.util.Log;

public final class ReadWriteLock {
    public static final EnumSet<Options> DEFAULT_OPTIONS = ReadWriteLock.options(System.getProperty("oracle.javatools.lock"));
    public static final Implementation DEFAULT_IMPLEMENTATION = DEFAULT_OPTIONS.contains((Object)Options.JDK) ? Implementation.JDK : Implementation.LEGACY;
    public static final int DEFAULT_DEADLOCK_INTERVAL = 20000;
    public static final int DEFAULT_WAIT_INTERVAL = 2000;
    public static final int DEFAULT_HISTORY_LIMIT = ReadWriteLock.defaultHistoryLimit();
    private static final Logger LOGGER = Logger.getLogger("oracle.javatools.lock");
    private final ReadWriteLockImplementation implementation;
    private volatile Object name;
    private int writeRequestCount;
    private CopyOnWriteArrayList<WriteLockRequestListener> writeRequestListeners;

    public ReadWriteLock() {
        this(null);
    }

    public ReadWriteLock(String name) {
        this(name, DEFAULT_IMPLEMENTATION, DEFAULT_OPTIONS, 2000, 20000, DEFAULT_HISTORY_LIMIT);
    }

    ReadWriteLock(String name, Implementation implementation, EnumSet<Options> options, int waitInterval, int deadlockInterval, int historyLimit) {
        if (options == null) {
            options = DEFAULT_OPTIONS;
        }
        this.setName(name);
        switch (implementation) {
            case JDK: {
                this.implementation = new JdkReadWriteLockImplementation(this, options, deadlockInterval);
                break;
            }
            default: {
                this.implementation = new LegacyReadWriteLockImplementation(this, options, waitInterval, deadlockInterval, historyLimit);
            }
        }
    }

    public final void setName(String name) {
        this.name = name != null ? name : Integer.valueOf(System.identityHashCode(this));
    }

    public final String getName() {
        return String.valueOf(this.name);
    }

    public void readLock() {
        this.implementation.readLock(true);
    }

    public void readLockInterruptibly() throws InterruptedException {
        this.implementation.readLockInterruptibly();
    }

    public boolean tryReadLock() {
        return this.implementation.readLock(false);
    }

    public void readUnlock() {
        this.implementation.readUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addWriteLockRequestListener(WriteLockRequestListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener null");
        }
        if (this.implementation.getReadHoldCount() == 0) {
            throw new IllegalMonitorStateException("no read lock of " + this + " held from " + Thread.currentThread());
        }
        if (this.implementation.getWriteHoldCount() > 0) {
            throw new IllegalMonitorStateException("write lock of " + this + " held from " + Thread.currentThread());
        }
        ReadWriteLockImplementation readWriteLockImplementation = this.implementation;
        synchronized (readWriteLockImplementation) {
            if (this.writeRequestListeners == null) {
                this.writeRequestListeners = new CopyOnWriteArrayList();
            }
            this.writeRequestListeners.addIfAbsent(listener);
            return this.writeRequestCount > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWriteLockRequestListener(WriteLockRequestListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener null");
        }
        if (this.implementation.getReadHoldCount() == 0) {
            throw new IllegalMonitorStateException("no read lock of " + this + " held from " + Thread.currentThread());
        }
        if (this.implementation.getWriteHoldCount() > 0) {
            throw new IllegalMonitorStateException("write lock of " + this + " held from " + Thread.currentThread());
        }
        ReadWriteLockImplementation readWriteLockImplementation = this.implementation;
        synchronized (readWriteLockImplementation) {
            if (this.writeRequestListeners != null && this.writeRequestListeners.remove(listener) && this.writeRequestListeners.isEmpty()) {
                this.writeRequestListeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLock() {
        Iterator<WriteLockRequestListener> iterator;
        ReadWriteLockImplementation readWriteLockImplementation = this.implementation;
        synchronized (readWriteLockImplementation) {
            ++this.writeRequestCount;
            iterator = this.writeRequestListeners == null || this.writeRequestListeners.isEmpty() ? null : this.writeRequestListeners.iterator();
        }
        if (iterator != null) {
            do {
                WriteLockRequestListener listener = iterator.next();
                try {
                    listener.writeRequested(this);
                }
                catch (Throwable e) {
                    LOGGER.log(Level.SEVERE, "unexpected exception invoking write request listener " + listener + " for " + this, e);
                }
            } while (iterator.hasNext());
        }
        this.implementation.writeLock(true);
        readWriteLockImplementation = this.implementation;
        synchronized (readWriteLockImplementation) {
            --this.writeRequestCount;
        }
    }

    public void writeLockInterruptibly() throws InterruptedException {
        this.implementation.writeLockInterruptibly();
    }

    public boolean tryWriteLock() {
        return this.implementation.writeLock(false);
    }

    public void writeUnlock() {
        this.implementation.writeUnlock();
    }

    public void writeLockFromReadLock() {
        int readerCount = this.implementation.releaseReaders();
        this.implementation.writeLock(true);
        this.implementation.restoreReaders(readerCount);
    }

    public boolean isReadLockHeld() {
        return this.implementation.getReadHoldCount() > 0;
    }

    public boolean isWriteLockHeld() {
        return this.implementation.getWriteHoldCount() > 0;
    }

    public boolean isLockHeld() {
        return this.isReadLockHeld() || this.isWriteLockHeld();
    }

    public int getReadHoldCount() {
        return this.implementation.getReadHoldCount();
    }

    public int getWriteHoldCount() {
        return this.implementation.getWriteHoldCount();
    }

    public void appendSnapshot(StringBuilder buffer) {
        this.implementation.appendSnapshot(buffer);
    }

    public void setEventLog(Log log) {
        this.implementation.setEventLog(log);
    }

    public String toString() {
        return "lock '" + this.name + "'";
    }

    private static EnumSet<Options> options(String text) {
        if (text != null) {
            Logger LOGGER = Logger.getLogger("oracle.javatools.lock");
            EnumSet<Options> options = EnumSet.noneOf(Options.class);
            for (String token : text.split(",")) {
                String option = token.trim().toUpperCase();
                if ("".equals(option)) continue;
                try {
                    Options value = Options.valueOf(option);
                    options.add(value);
                    switch (value) {
                        case LEGACY: {
                            options.remove((Object)Options.JDK);
                            break;
                        }
                        case JDK: {
                            options.remove((Object)Options.LEGACY);
                        }
                    }
                }
                catch (Exception e) {
                    if ("ALL".equals(option)) {
                        options = EnumSet.allOf(Options.class);
                        options.remove((Object)Options.LEGACY);
                        continue;
                    }
                    if ("NONE".equals(option)) {
                        options = EnumSet.noneOf(Options.class);
                        continue;
                    }
                    if ("TRUE".equals(option)) {
                        options = EnumSet.allOf(Options.class);
                        options.remove((Object)Options.LEGACY);
                        continue;
                    }
                    StringBuilder expectedOptions = new StringBuilder();
                    for (Options constant : (Options[])Options.class.getEnumConstants()) {
                        expectedOptions.append("'");
                        expectedOptions.append(constant.toString().toLowerCase());
                        expectedOptions.append("', ");
                    }
                    expectedOptions.append("or 'all'");
                    LOGGER.log(Level.WARNING, "option ''{0}'' from property \"oracle.javatools.lock\" not recognized: expected {1}", new Object[]{token.trim(), expectedOptions});
                }
            }
            if (options.contains((Object)Options.JDK) && options.contains((Object)Options.LEGACY)) {
                options.remove((Object)Options.LEGACY);
            } else if (!options.contains((Object)Options.JDK) && !options.contains((Object)Options.LEGACY)) {
                options.add(Options.JDK);
            }
            for (Options option : options) {
                switch (option) {
                    case DEADLOCKS: {
                        LOGGER.log(Level.CONFIG, "deadlock logging enabled");
                        break;
                    }
                    case UPGRADES: {
                        LOGGER.log(Level.CONFIG, "upgrade logging enabled");
                        break;
                    }
                    case HISTORY: {
                        LOGGER.log(Level.CONFIG, "history logging enabled");
                    }
                }
            }
            return options;
        }
        return EnumSet.of(Options.JDK, Options.DEADLOCKS, Options.UPGRADES);
    }

    private static int defaultHistoryLimit() {
        int limit;
        String value = System.getProperty("oracle.javatools.lock.history.limit");
        if (value != null) {
            try {
                limit = Integer.parseInt(value);
                if (limit <= 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                limit = 100;
                LOGGER.log(Level.WARNING, "Value ''{0}'' of property \"oracle.javatools.lock.history.limit\" not valid: expected positive integer", new Object[]{value});
            }
        } else {
            limit = 100;
        }
        return limit;
    }

    public static enum Options {
        JDK,
        LEGACY,
        DEADLOCKS,
        UPGRADES,
        DIALOGS,
        FAIR,
        HISTORY,
        NESTED_HISTORY;

    }

    public static enum Implementation {
        JDK,
        LEGACY;

    }
}

