/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.net;

import java.net.Authenticator;
import java.net.PasswordAuthentication;

public class AuthenticatorHelper {
    private static final ThreadLocal<AuthenticatorCallback> authenticationInterruption = new ThreadLocal();

    private AuthenticatorHelper() {
    }

    public static AuthenticatorCallback getAuthenticatorCallback() {
        return authenticationInterruption.get();
    }

    public static void setAuthenticatorCallback(AuthenticatorCallback cb) {
        if (authenticationInterruption.get() != null) {
            throw new IllegalStateException("Callback already set on this object, did the calling code use try/finally?");
        }
        authenticationInterruption.set(cb);
    }

    public static void clearAuthenticatorCallback() {
        if (authenticationInterruption.get() == null) {
            throw new IllegalStateException("Callback already set on this object, did the calling code use try/finally?");
        }
        authenticationInterruption.set(null);
    }

    public static interface AuthenticatorCallback {
        public PasswordAuthentication getPasswordAuthentication(Authenticator var1);
    }
}

