/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.IOException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRefUpdateResult;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class UpdateRefCommand
extends GitCommand {
    private final String revision;
    private final String refName;
    private GitRefUpdateResult result;

    public UpdateRefCommand(Repository repository, GitClassFactory gitFactory, String refName, String revision, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.refName = refName;
        this.revision = revision;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try {
            String name;
            Ref ref = repository.getRef(this.refName);
            if (ref == null || ref.isSymbolic()) {
                this.result = GitRefUpdateResult.valueOf(RefUpdate.Result.NOT_ATTEMPTED.name());
                return;
            }
            Ref newRef = repository.getRef(this.revision);
            if (newRef == null) {
                ObjectId id = repository.resolve(this.revision);
                newRef = new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, id.name(), id.copy());
                name = newRef.getName();
            } else {
                name = this.revision;
            }
            RefUpdate u = repository.updateRef(ref.getName());
            u.setNewObjectId((AnyObjectId)(newRef.isPeeled() ? newRef.getPeeledObjectId() : newRef.getObjectId()));
            u.setRefLogMessage("merge " + name + ": Fast-forward", false);
            u.update();
            this.result = GitRefUpdateResult.valueOf((u.getResult() == null ? RefUpdate.Result.NOT_ATTEMPTED : u.getResult()).name());
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        return "git update-ref " + this.refName + " " + this.revision;
    }

    public GitRefUpdateResult getResult() {
        return this.result;
    }
}

