/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.schemabrowser.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import oracle.dbtools.raptor.connections.AbstractConnectionListener;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.ViewableSelectionComponentProvider;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.db.DBNavigatorManager;
import oracle.dbtools.raptor.schemabrowser.view.SBGui;
import oracle.dbtools.raptor.schemabrowser.view.SBViewController;
import oracle.dbtools.raptor.ui.RDockableWindow;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.ContextMenuListenerSupport;
import oracle.ide.controller.ContextMenuListenersHook;
import oracle.ide.controller.Controller;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableView;
import oracle.ide.docking.DockingParam;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.util.PropertyAccess;
import oracle.javatools.util.ModelUtil;

public class SBWindow
extends RDockableWindow
implements ViewableSelectionComponentProvider {
    public static final String SB_MENU_TAG = "schemabrowser";
    public static final String VIEW_TYPE = "SchemaBrowser";
    public static final String CONNECTION_KEY = "SchemaBrowser.Connection";
    public static final String CATALOG_KEY = "SchemaBrowser.CATALOG";
    public static final String SCHEMA_KEY = "SchemaBrowser.Schema";
    public static final String TYPE_KEY = "SchemaBrowser.Type";
    private static Map<String, ViewId> s_viewMap = new HashMap<String, ViewId>();
    private static int s_counter = 0;
    private static ContextMenu s_menu;
    private String m_connName;
    private Controller m_controller;
    private JPanel m_gui;
    private SBGui m_content;
    private Context m_context;

    public static SBWindow findBrowser(String string) {
        DockStation dockStation = DockStation.getDockStation();
        SBWindow sBWindow = null;
        ViewId viewId = s_viewMap.get(string);
        if (viewId != null) {
            sBWindow = (SBWindow)dockStation.findDockable(viewId);
        } else {
            viewId = new ViewId(VIEW_TYPE, Integer.toString(s_counter++));
        }
        if (sBWindow == null) {
            sBWindow = new SBWindow(viewId, string);
            DockingParam dockingParam = new DockingParam();
            NavigatorWindow navigatorWindow = DBNavigatorManager.getInstance().getNavigatorWindow();
            if (navigatorWindow != null) {
                dockingParam.setTabbedWith((Dockable)navigatorWindow);
            }
            dockStation.dock((Dockable)sBWindow, dockingParam);
            s_viewMap.put(string, viewId);
        }
        return sBWindow;
    }

    protected static synchronized ContextMenu getOrCreateContextMenu() {
        if (s_menu == null) {
            ContextMenuListenerSupport contextMenuListenerSupport = ContextMenuListenerSupport.createInstance();
            ContextMenuListenersHook contextMenuListenersHook = (ContextMenuListenersHook)ExtensionRegistry.getExtensionRegistry().getHook(ContextMenuListenersHook.ELEMENT);
            if (contextMenuListenersHook != null) {
                ContextMenuListener contextMenuListener = contextMenuListenersHook.getListener("db_nav");
                if (contextMenuListener != null) {
                    contextMenuListenerSupport.addContextMenuListener(contextMenuListener, null);
                }
                if ((contextMenuListener = contextMenuListenersHook.getListener(SB_MENU_TAG)) != null) {
                    contextMenuListenerSupport.addContextMenuListener(contextMenuListener, null);
                }
            }
            s_menu = new ContextMenu(new MnemonicSolver(), contextMenuListenerSupport);
        }
        return s_menu;
    }

    private SBWindow(ViewId viewId, String string) {
        super(viewId.getId());
        this.m_connName = string;
        this.setToolbarVisible(true);
        this.setType(32);
    }

    public String getTitleName() {
        return Connections.getDisplayName((String)this.m_connName);
    }

    public Icon getTabIcon() {
        return RaptorImagesArb.getIcon((String)"SCHEMA");
    }

    public Component getGUI() {
        this.createGUI();
        return this.m_gui;
    }

    public ContextMenu getContextMenu() {
        return SBWindow.getOrCreateContextMenu();
    }

    public Toolbar getToolbar() {
        return null;
    }

    public void saveLayout(PropertyAccess propertyAccess) {
    }

    public void setToolbarVisible(boolean bl) {
    }

    public void setContext(Context context) {
        this.m_context = context;
        if (this.m_content != null) {
            this.m_content.setContext(this.m_context);
        }
    }

    protected Element[] getSelectionFromUI() {
        return this.m_content != null ? this.m_content.getSelection() : super.getSelectionFromUI();
    }

    public Controller getController() {
        if (this.m_controller == null) {
            this.m_controller = new SBViewController(this);
        }
        return this.m_controller;
    }

    private void createGUI() {
        if (this.m_gui == null) {
            this.m_gui = new JPanel(new BorderLayout());
            this.m_content = new SBGui(this);
            this.m_content.setContext(this.m_context);
            this.m_gui.add((Component)this.m_content, "Center");
        }
    }

    public Component getViewableSelectionComponent() {
        this.createGUI();
        return this.m_content.getSelectableComponent();
    }

    SBGui getViewComponent() {
        this.createGUI();
        return this.m_content;
    }

    String getConnectionName() {
        return this.m_connName;
    }

    void setConnectionName(String string) {
        this.m_connName = string;
        this.updateTitle(this.m_connName);
    }

    static {
        Connections.getInstance().addConnectionListener((ConnectionListener)new AbstractConnectionListener(){

            public void connectionRemoved(ConnectionEvent connectionEvent) {
                SBWindow sBWindow;
                String string = connectionEvent.getConnectionName();
                ViewId viewId = (ViewId)s_viewMap.get(string);
                if (viewId != null && (sBWindow = (SBWindow)DockStation.getDockStation().findDockable(viewId)) != null) {
                    DockUtil.hideDockableWindow((DockableView)sBWindow);
                }
            }

            public void connectionModified(ConnectionEvent connectionEvent) {
                ViewId viewId;
                String string;
                String string2 = connectionEvent.getOldName();
                if (ModelUtil.areDifferent((Object)string2, (Object)(string = connectionEvent.getConnectionName())) && (viewId = (ViewId)s_viewMap.remove(string2)) != null) {
                    s_viewMap.put(string, viewId);
                    SBWindow sBWindow = (SBWindow)DockStation.getDockStation().findDockable(viewId);
                    if (sBWindow != null) {
                        sBWindow.setConnectionName(string);
                    }
                }
            }
        });
    }
}

